/*
 * Decompiled with CFR 0.152.
 */
package phex.common.bandwidth;

import phex.common.bandwidth.TransferAverage;
import phex.utils.NLogger;

public class BandwidthController {
    private static final int WINDOWS_PER_SECONDS = 5;
    private static final int MILLIS_PER_WINDOW = 200;
    private int bytesPerWindow;
    private int bytesRemaining;
    private long lastWindowTime;
    private long throttlingRate;
    private final String controllerName;
    private BandwidthController nextContollerInChain = null;
    private TransferAverage shortTransferAvg;
    private TransferAverage longTransferAvg;

    private BandwidthController(String controllerName, long throttlingRate) {
        this.controllerName = controllerName + " " + Integer.toHexString(this.hashCode());
        this.setThrottlingRate(throttlingRate);
        this.bytesRemaining = this.bytesPerWindow;
    }

    public synchronized void activateShortTransferAvg(int refreshRate, int period) {
        this.shortTransferAvg = new TransferAverage(refreshRate, period);
    }

    public synchronized void activateLongTransferAvg(int refreshRate, int period) {
        this.longTransferAvg = new TransferAverage(refreshRate, period);
    }

    public TransferAverage getShortTransferAvg() {
        return this.shortTransferAvg;
    }

    public TransferAverage getLongTransferAvg() {
        return this.longTransferAvg;
    }

    public synchronized BandwidthController linkControllerIntoChain(BandwidthController toLink) {
        BandwidthController temp = this.nextContollerInChain;
        this.nextContollerInChain = toLink;
        return temp;
    }

    public synchronized void setThrottlingRate(long bytesPerSecond) {
        this.throttlingRate = bytesPerSecond;
        this.bytesPerWindow = (int)((double)this.throttlingRate / 5.0);
        if (NLogger.isDebugEnabled("BANDWIDTH")) {
            NLogger.debug("BANDWIDTH", (Object)("[" + this.controllerName + "] Set throttling rate to " + bytesPerSecond + "bps (" + this.bytesPerWindow + " per window)"));
        }
        this.bytesRemaining = Math.min(this.bytesRemaining, this.bytesPerWindow);
    }

    public long getThrottlingRate() {
        return this.throttlingRate;
    }

    public synchronized int getAvailableByteCount(boolean blockTillAvailable) {
        this.updateWindow(blockTillAvailable);
        int bytesAllowed = this.bytesRemaining;
        if (this.nextContollerInChain != null) {
            bytesAllowed = Math.min(bytesAllowed, this.nextContollerInChain.getAvailableByteCount(blockTillAvailable));
        }
        if (NLogger.isDebugEnabled("BANDWIDTH")) {
            NLogger.debug("BANDWIDTH", (Object)("[" + this.controllerName + "] Available byte count " + bytesAllowed + "bps - Remaining: " + this.bytesRemaining + "."));
        }
        return bytesAllowed;
    }

    public synchronized int getAvailableByteCount(int maxToSend, boolean blockTillAvailable) {
        return Math.min(maxToSend, this.getAvailableByteCount(blockTillAvailable));
    }

    public synchronized void markBytesUsed(int byteCount) {
        this.updateWindow(false);
        this.bytesRemaining -= byteCount;
        if (this.bytesRemaining < 0) {
            this.updateWindow(true);
        }
        if (NLogger.isDebugEnabled("BANDWIDTH")) {
            NLogger.debug("BANDWIDTH", (Object)("[" + this.controllerName + "] Mark bytes used " + byteCount + " - remaining: " + this.bytesRemaining + "."));
        }
        if (this.shortTransferAvg != null) {
            this.shortTransferAvg.addValue(byteCount);
        }
        if (this.longTransferAvg != null) {
            this.longTransferAvg.addValue(byteCount);
        }
        if (this.nextContollerInChain != null) {
            this.nextContollerInChain.markBytesUsed(byteCount);
        }
    }

    private void updateWindow(boolean blockTillAvailable) {
        boolean wasInterrupted = false;
        while (true) {
            long now;
            long elapsedWindowMillis;
            if ((elapsedWindowMillis = (now = System.currentTimeMillis()) - this.lastWindowTime) >= 200L) {
                this.bytesRemaining = this.bytesRemaining < 0 ? (this.bytesRemaining += this.bytesPerWindow) : this.bytesPerWindow;
                this.lastWindowTime = now;
                if (NLogger.isDebugEnabled("BANDWIDTH")) {
                    NLogger.debug("BANDWIDTH", (Object)("[" + this.controllerName + "] Update new Window " + this.bytesPerWindow + " - Remaining: " + this.bytesRemaining + "."));
                }
            }
            if (!blockTillAvailable || this.bytesRemaining > 0) break;
            try {
                Thread.sleep(Math.max(200L - elapsedWindowMillis, 0L));
            }
            catch (InterruptedException e) {
                wasInterrupted = true;
                break;
            }
        }
        if (wasInterrupted) {
            Thread.currentThread().interrupt();
        }
    }

    public String getName() {
        return this.controllerName;
    }

    public String toDebugString() {
        return "ThrottleController[Name:" + this.controllerName + ",bytesPerWindow:" + this.bytesPerWindow + ",bytesRemaining:" + this.bytesRemaining;
    }

    public static BandwidthController acquireBandwidthController(String controllerName, long throttlingRate) {
        return new BandwidthController(controllerName, throttlingRate);
    }

    public static void releaseController(BandwidthController controller) {
        controller.nextContollerInChain = null;
    }
}

