/*
 * Decompiled with CFR 0.152.
 */
package phex.common.address;

import java.util.Arrays;
import phex.common.Ip2CountryManager;
import phex.common.address.AddressUtils;
import phex.common.address.DestAddress;
import phex.connection.NetworkManager;
import phex.utils.IOUtil;

public class IpAddress {
    public static final byte CLASS_A = 1;
    public static final byte CLASS_B = 2;
    public static final byte CLASS_C = 3;
    public static final byte[] LOCAL_HOST_IP = new byte[]{127, 0, 0, 1};
    public static final byte[] UNSET_IP = new byte[]{0, 0, 0, 0};
    public static final String LOCAL_HOST_NAME = "127.0.0.1";
    public static final int DEFAULT_PORT = 6346;
    private int hash = 0;
    private byte[] hostIP;
    public String countryCode;

    public IpAddress(byte[] aHostIP) {
        if (aHostIP == null) {
            throw new NullPointerException("Ip is null");
        }
        this.hostIP = aHostIP;
    }

    public byte[] getHostIP() {
        return this.hostIP;
    }

    public String getFormatedString() {
        return AddressUtils.ip2string(this.hostIP);
    }

    public long getLongHostIP() {
        int v1 = this.hostIP[3] & 0xFF;
        int v2 = this.hostIP[2] << 8 & 0xFF00;
        int v3 = this.hostIP[1] << 16 & 0xFF0000;
        int v4 = this.hostIP[0] << 24;
        long ipValue = (long)(v4 | v3 | v2 | v1) & 0xFFFFFFFFL;
        return ipValue;
    }

    public boolean equals(IpAddress address) {
        if (address == null) {
            return false;
        }
        return Arrays.equals(this.hostIP, address.hostIP);
    }

    public boolean equals(Object obj) {
        if (obj instanceof IpAddress) {
            return this.equals((IpAddress)obj);
        }
        return false;
    }

    public int hashCode() {
        if (this.hash == 0) {
            int ipVal;
            this.hash = ipVal = IOUtil.deserializeInt(this.hostIP, 0);
        }
        return this.hash;
    }

    public String getCountryCode() {
        if (this.countryCode == null) {
            this.countryCode = Ip2CountryManager.getInstance().getCountryCode(this);
        }
        return this.countryCode;
    }

    public boolean isLocalAddress() {
        DestAddress localAddress = NetworkManager.getInstance().getLocalAddress();
        if (this.hostIP[0] == 127) {
            return true;
        }
        return localAddress.getIpAddress().equals(this);
    }

    public boolean isSiteLocalIP() {
        if (this.hostIP[0] == 10 || this.hostIP[0] == 127) {
            return true;
        }
        if (this.hostIP[0] == -84 && this.hostIP[1] >= 16 && this.hostIP[1] <= 31) {
            return true;
        }
        return this.hostIP[0] == -64 && this.hostIP[1] == -88;
    }

    public boolean isValidIP() {
        boolean valid;
        byte clazz = this.getIPClass();
        switch (clazz) {
            case 1: {
                valid = (this.hostIP[1] & 0xFF) + (this.hostIP[2] & 0xFF) + (this.hostIP[3] & 0xFF) != 0;
                break;
            }
            case 2: {
                valid = (this.hostIP[2] & 0xFF) + (this.hostIP[3] & 0xFF) != 0;
                break;
            }
            case 3: {
                valid = (this.hostIP[3] & 0xFF) != 0;
                break;
            }
            default: {
                valid = false;
            }
        }
        return valid;
    }

    public byte getIPClass() {
        if ((this.hostIP[0] & 0x80) == 0) {
            return 1;
        }
        if ((this.hostIP[0] & 0xC0) == 128) {
            return 2;
        }
        if ((this.hostIP[0] & 0xE0) == 192) {
            return 3;
        }
        return -1;
    }

    public String toString() {
        return AddressUtils.ip2string(this.hostIP);
    }
}

