/*
 * Decompiled with CFR 0.152.
 */
package phex.common.address;

import phex.common.address.DestAddress;
import phex.common.address.IpAddress;
import phex.common.address.MalformedDestAddressException;
import phex.net.presentation.PresentationManager;
import phex.security.PhexSecurityManager;

public class AddressUtils {
    static final /* synthetic */ boolean $assertionsDisabled;

    public static String ip2string(byte[] ip) {
        if (ip == null) {
            throw new NullPointerException("Ip is null!");
        }
        if (!$assertionsDisabled && ip.length != 4) {
            throw new AssertionError();
        }
        return (ip[0] & 0xFF) + "." + (ip[1] & 0xFF) + "." + (ip[2] & 0xFF) + "." + (ip[3] & 0xFF);
    }

    public static boolean isIPHostName(String hostName) {
        int portSeparatorIdx = hostName.indexOf(58);
        if (portSeparatorIdx != -1) {
            hostName = hostName.substring(0, portSeparatorIdx);
        }
        char[] data = hostName.toCharArray();
        int hitDots = 0;
        for (int i = 0; i < data.length; ++i) {
            char c = data[i];
            if (c < '0' || c > '9') {
                return false;
            }
            while (c != '.') {
                if (c < '0' || c > '9') {
                    return false;
                }
                if (++i >= data.length) break;
                c = data[i];
            }
            ++hitDots;
        }
        return hitDots == 4 && !hostName.endsWith(".");
    }

    public static DestAddress parseAndValidateAddress(String addressString, boolean isPrivateIpAllowed) throws MalformedDestAddressException {
        byte[] ip = AddressUtils.parseIP(addressString);
        if (ip == null) {
            throw new MalformedDestAddressException("Invalid IP: " + addressString);
        }
        int port = AddressUtils.parsePort(addressString);
        if (port == -1) {
            port = 6346;
        } else if (!AddressUtils.isPortInRange(port)) {
            throw new MalformedDestAddressException("Port out of range: " + addressString);
        }
        IpAddress ipAddress = new IpAddress(ip);
        DestAddress hostAddress = PresentationManager.getInstance().createHostAddress(ipAddress, port);
        if (!hostAddress.isValidAddress()) {
            throw new MalformedDestAddressException("Invalid IP: " + addressString);
        }
        if (!isPrivateIpAllowed && hostAddress.isSiteLocalAddress()) {
            throw new MalformedDestAddressException("Private IP: " + addressString);
        }
        byte access = PhexSecurityManager.getInstance().controlHostIPAccess(hostAddress.getIpAddress().getHostIP());
        switch (access) {
            case 2: 
            case 3: {
                throw new MalformedDestAddressException("Host access denied: " + addressString);
            }
        }
        return hostAddress;
    }

    public static byte[] parseIntIP(String ip) {
        long IP = Long.parseLong(ip);
        byte[] addr = new byte[]{(byte)(IP >>> 24 & 0xFFL), (byte)(IP >>> 16 & 0xFFL), (byte)(IP >>> 8 & 0xFFL), (byte)(IP & 0xFFL)};
        return addr;
    }

    public static byte[] parseIP(String hostIp) {
        int portSeparatorIdx = hostIp.indexOf(58);
        if (portSeparatorIdx != -1) {
            hostIp = hostIp.substring(0, portSeparatorIdx);
        }
        char[] data = hostIp.toCharArray();
        int IP = 0;
        int hitDots = 0;
        for (int i = 0; i < data.length; ++i) {
            char c = data[i];
            if (c < '0' || c > '9') {
                return null;
            }
            int b = 0;
            while (c != '.') {
                if (c < '0' || c > '9') {
                    return null;
                }
                b = b * 10 + c - 48;
                if (++i >= data.length) break;
                c = data[i];
            }
            if (b > 255) {
                return null;
            }
            IP = (IP << 8) + b;
            ++hitDots;
        }
        if (hitDots != 4 || hostIp.endsWith(".")) {
            return null;
        }
        byte[] addr = new byte[]{(byte)(IP >>> 24 & 0xFF), (byte)(IP >>> 16 & 0xFF), (byte)(IP >>> 8 & 0xFF), (byte)(IP & 0xFF)};
        return addr;
    }

    public static int parsePort(String hostName) {
        char c;
        int portIdx = hostName.indexOf(58);
        if (portIdx == -1) {
            return -1;
        }
        String portString = hostName.substring(portIdx + 1);
        char[] data = portString.toCharArray();
        int port = 0;
        for (int i = 0; i < data.length && (c = data[i]) >= '0' && c <= '9'; ++i) {
            port = port * 10 + c - 48;
        }
        if (!AddressUtils.isPortInRange(port)) {
            return -1;
        }
        return port;
    }

    public static String toIntValueString(byte[] ip) {
        int v1 = ip[3] & 0xFF;
        int v2 = ip[2] << 8 & 0xFF00;
        int v3 = ip[1] << 16 & 0xFF0000;
        int v4 = ip[0] << 24;
        long ipValue = (long)(v4 | v3 | v2 | v1) & 0xFFFFFFFFL;
        return String.valueOf(ipValue);
    }

    public static boolean isPortInRange(int port) {
        return (port & 0xFFFF0000) == 0 && port != 0;
    }

    static {
        $assertionsDisabled = !AddressUtils.class.desiredAssertionStatus();
    }
}

