/*
 * Decompiled with CFR 0.152.
 */
package phex.common;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import phex.host.HostManager;
import phex.msg.PongMsg;
import phex.utils.PriorityQueue;

public class PongCache {
    private static final PongCache singleton = new PongCache();
    private static final int PONGS_PER_HOP = 1;
    private static final int MAX_HOPS = 6;
    private static final int EXPIRE_TIME_MILLIS = 60000;
    private static PriorityQueue pongQueue;

    private PongCache() {
        int[] capacities = new int[6];
        Arrays.fill(capacities, 1);
        pongQueue = new PriorityQueue(capacities);
    }

    public static PongCache getInstance() {
        return Holder.instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getPongs() {
        PriorityQueue priorityQueue = pongQueue;
        synchronized (priorityQueue) {
            LinkedList<PongMsg> pongList = new LinkedList<PongMsg>();
            LinkedList<PongMsg> removeList = null;
            long now = System.currentTimeMillis();
            Iterator iterator = pongQueue.iterator();
            while (iterator.hasNext()) {
                PongMsg pong = (PongMsg)iterator.next();
                if (now - pong.getCreationTime() > 60000L) {
                    if (removeList == null) {
                        removeList = new LinkedList<PongMsg>();
                    }
                    removeList.add(pong);
                    continue;
                }
                pongList.add(pong);
            }
            this.removePongs(removeList);
            return pongList;
        }
    }

    private void removePongs(List pongList) {
        if (pongList == null) {
            return;
        }
        Iterator iterator = pongList.iterator();
        while (iterator.hasNext()) {
            PongMsg pong = (PongMsg)iterator.next();
            pongQueue.removeFromAll(pong);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPong(PongMsg pong) {
        if (!pong.isUltrapeerMarked()) {
            return;
        }
        if (!HostManager.getInstance().isUltrapeer()) {
            return;
        }
        int hops = pong.getHeader().getHopsTaken() - 1;
        if (hops >= 6) {
            return;
        }
        PriorityQueue priorityQueue = pongQueue;
        synchronized (priorityQueue) {
            pongQueue.addToHead(pong, hops);
        }
    }

    private static class Holder {
        protected static final PongCache instance = new PongCache();

        private Holder() {
        }
    }
}

