/*
 * Decompiled with CFR 0.152.
 */
package phex.common;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import phex.common.URN;
import phex.common.address.AddressUtils;
import phex.common.address.DefaultDestAddress;
import phex.common.address.DestAddress;
import phex.common.address.MalformedDestAddressException;
import phex.security.PhexSecurityManager;
import phex.utils.Logger;
import phex.utils.NLogger;

public class AlternateLocation {
    public static final Short DEFAULT_HOST_RATING = new Short(6);
    private DestAddress hostAddress;
    private URN urn;

    public AlternateLocation(DestAddress hostAddress, URN urn) {
        this.hostAddress = hostAddress;
        this.urn = urn;
    }

    public DestAddress getHostAddress() {
        return this.hostAddress;
    }

    public URN getURN() {
        return this.urn;
    }

    public String getHTTPString() {
        StringBuffer buffer = new StringBuffer(this.hostAddress.getHostName());
        int port = this.hostAddress.getPort();
        if (port != 6346) {
            buffer.append(':');
            buffer.append(port);
        }
        return buffer.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AlternateLocation)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        AlternateLocation altLoc = (AlternateLocation)obj;
        return this.hostAddress.equals(altLoc.hostAddress) && this.urn.equals(altLoc.urn);
    }

    public int hashCode() {
        int h = 7;
        h = 31 * h + (this.hostAddress != null ? ((Object)this.hostAddress).hashCode() : 0);
        h = 31 * h + (this.urn != null ? this.urn.hashCode() : 0);
        return h;
    }

    public static AlternateLocation parseCompactIpAltLoc(String line, URN urn) {
        DestAddress address;
        try {
            address = AddressUtils.parseAndValidateAddress(line, false);
        }
        catch (MalformedDestAddressException exp) {
            NLogger.debug(AlternateLocation.class, (Object)("Malformed alt-location URL: " + exp.getMessage()));
            return null;
        }
        AlternateLocation loc = new AlternateLocation(address, urn);
        return loc;
    }

    public static AlternateLocation parseUriResAltLoc(String line) {
        StringTokenizer tokenizer = new StringTokenizer(line, " \t\n\r\f\"");
        String urlStr = null;
        if (tokenizer.hasMoreTokens()) {
            urlStr = tokenizer.nextToken();
        }
        if (tokenizer.hasMoreTokens()) {
            tokenizer.nextToken();
        }
        try {
            URL url = new URL(urlStr);
            String protocol = url.getProtocol();
            if (!"http".equals(protocol)) {
                Logger.logMessage(Logger.FINE, (short)2, "Invalid alt-location URL (Not a http URL): " + urlStr);
                return null;
            }
            String host = url.getHost();
            int port = url.getPort();
            if (port == -1) {
                Logger.logMessage(Logger.FINE, (short)2, "Invalid legacy alt-loc without specified port.");
                return null;
            }
            DefaultDestAddress hostAddress = new DefaultDestAddress(host, port);
            if (!hostAddress.isValidAddress()) {
                Logger.logMessage(Logger.FINE, (short)2, "Invalid alt-location URL (Invalid address): " + urlStr);
                return null;
            }
            byte access = PhexSecurityManager.getInstance().controlHostAddressAccess(hostAddress);
            switch (access) {
                case 2: 
                case 3: {
                    Logger.logMessage(Logger.FINE, (short)2, "Alt-Location host denied: " + urlStr);
                    return null;
                }
            }
            if (!hostAddress.getIpAddress().isValidIP()) {
                Logger.logMessage(Logger.FINE, (short)2, "Invalid alt-location URL (Invalid IP used): " + urlStr);
                return null;
            }
            if (hostAddress.getIpAddress().isSiteLocalIP()) {
                Logger.logMessage(Logger.FINE, (short)2, "Invalid alt-location URL (Private IP used): " + urlStr);
                return null;
            }
            URN urn = URN.parseURNFromUriRes(url.getFile());
            if (urn == null) {
                Logger.logMessage(Logger.FINE, (short)2, "Alt-location path without URN: " + line);
                return null;
            }
            AlternateLocation loc = new AlternateLocation(hostAddress, urn);
            return loc;
        }
        catch (MalformedURLException exp) {
            Logger.logMessage(Logger.FINE, (short)2, "Invalid alt-location URL (Malformed: " + exp.getMessage() + " ): " + urlStr);
            return null;
        }
    }
}

