/*
 * Decompiled with CFR 0.152.
 */
package phex.chat;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import phex.chat.ChatEngine;
import phex.common.AbstractManager;
import phex.common.ServiceManager;
import phex.common.address.DestAddress;
import phex.event.AsynchronousDispatcher;
import phex.event.ChatListener;
import phex.net.presentation.SocketFacade;
import phex.utils.GnutellaInputStream;
import phex.utils.IOUtil;
import phex.utils.NLogger;

public class ChatManager
extends AbstractManager {
    private Set openIpAddressSet;
    private ArrayList listenerList = new ArrayList(1);

    private ChatManager() {
    }

    public static ChatManager getInstance() {
        return Holder.manager;
    }

    public boolean initialize() {
        return true;
    }

    public boolean onPostInitialization() {
        return true;
    }

    public void startupCompletedNotify() {
    }

    public void shutdown() {
    }

    public void openChat(DestAddress hostAddress) {
        ChatEngine chatEngine = new ChatEngine(hostAddress);
        chatEngine.startChat();
        this.fireChatConnectionOpened(chatEngine);
    }

    public void chatClosed(ChatEngine chatEngine) {
        this.openIpAddressSet.remove(chatEngine.getHostAddress().getIpAddress());
        this.fireChatConnectionFailed(chatEngine);
    }

    public void acceptChat(SocketFacade socket, GnutellaInputStream gInStream, DestAddress hostAddress) {
        if (!ServiceManager.sCfg.isChatEnabled) {
            IOUtil.closeQuietly(socket);
            return;
        }
        if (this.openIpAddressSet.contains(hostAddress.getIpAddress())) {
            IOUtil.closeQuietly(socket);
            return;
        }
        try {
            ChatEngine chatEngine = new ChatEngine(socket, gInStream, hostAddress);
            this.openIpAddressSet.add(hostAddress.getIpAddress());
            chatEngine.startChat();
            this.fireChatConnectionOpened(chatEngine);
        }
        catch (IOException exp) {
            NLogger.debug(ChatManager.class, (Object)exp, (Throwable)exp);
            IOUtil.closeQuietly(socket);
            return;
        }
    }

    public void addChatListener(ChatListener listener) {
        this.listenerList.add(listener);
    }

    public void removeChatListener(ChatListener listener) {
        this.listenerList.remove(listener);
    }

    public void fireChatConnectionOpened(final ChatEngine chatEngine) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] listeners = ChatManager.this.listenerList.toArray();
                for (int i = listeners.length - 1; i >= 0; --i) {
                    ChatListener listener = (ChatListener)listeners[i];
                    listener.chatConnectionOpened(chatEngine);
                }
            }
        });
    }

    public void fireChatConnectionFailed(final ChatEngine chatEngine) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] listeners = ChatManager.this.listenerList.toArray();
                for (int i = listeners.length - 1; i >= 0; --i) {
                    ChatListener listener = (ChatListener)listeners[i];
                    listener.chatConnectionFailed(chatEngine);
                }
            }
        });
    }

    public void fireChatMessageReceived(final ChatEngine chatEngine, final String chatMessage) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] listeners = ChatManager.this.listenerList.toArray();
                for (int i = listeners.length - 1; i >= 0; --i) {
                    ChatListener listener = (ChatListener)listeners[i];
                    listener.chatMessageReceived(chatEngine, chatMessage);
                }
            }
        });
    }

    private static class Holder {
        protected static final ChatManager manager = new ChatManager();

        private Holder() {
        }
    }
}

