/*
 * Decompiled with CFR 0.152.
 */
package com.onionnetworks.dime;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Random;

public class DimeRecord {
    public static final long MAX_MAX_PAYLOAD_SIZE = 0xFFFFFFFFL;
    public static final int DEFAULT_MAX_PAYLOAD_SIZE = Integer.MAX_VALUE;
    public static final int VERSION = 1;
    private static final int VERSION_MASK = 248;
    private static final int VERSION_SHIFT = 3;
    private static final int MB_MASK = 4;
    private static final int ME_MASK = 2;
    private static final int CF_MASK = 1;
    private static final int TYPE_T_MASK = 240;
    private static final int TYPE_T_SHIFT = 4;
    private static final int RESERVED_MASK = 15;
    private TypeNameFormat tnf;
    private byte[] id;
    private byte[] type;
    private boolean first;
    private boolean last;
    private boolean continued;
    private long payloadLength = -1L;
    private InputStream payload;
    private SafeFiniteInputStream fis = null;
    private Random rand = new Random();

    public DimeRecord(byte[] buf, TypeNameFormat t, String tn, String i) {
        this(new ByteArrayInputStream(buf), buf.length, t, tn, i);
    }

    public DimeRecord(InputStream is, long len, TypeNameFormat t, String tn, String i) {
        this.tnf = t;
        this.type = tn.getBytes();
        this.id = i != null ? i.getBytes() : new byte[0];
        this.payloadLength = len;
        this.payload = is;
    }

    protected static DimeRecord extract(InputStream is) throws IOException {
        int i;
        int i2;
        int i3;
        int pos;
        int i4;
        int octet1 = is.read();
        if (octet1 == -1) {
            throw new IOException("Unexpected end of stream");
        }
        boolean last = (octet1 & 2) != 0;
        boolean continued = (octet1 & 1) != 0;
        boolean first = (octet1 & 4) != 0;
        int version = (octet1 & 0xF8) >>> 3;
        if (version != 1) {
            throw new IOException("Unparsable Version: " + version);
        }
        int octet2 = is.read();
        if (octet2 == -1) {
            throw new IOException("Unexpected end of stream");
        }
        TypeNameFormat tnf = TypeNameFormat.get((octet2 & 0xF0) >>> 4);
        if ((octet2 & 0xF) != 0) {
            throw new IOException("Reserved header space must be all zero");
        }
        int optLen = DimeRecord.readUnsignedShort(is);
        int idLen = DimeRecord.readUnsignedShort(is);
        int typeLen = DimeRecord.readUnsignedShort(is);
        long payloadLength = DimeRecord.readUnsignedInt(is);
        byte[] opt = new byte[optLen];
        for (pos = 0; pos < opt.length; pos += i4) {
            i4 = is.read(opt, pos, opt.length - pos);
            if (i4 != -1) continue;
            throw new IOException("Unexpected end of stream");
        }
        byte[] pad = new byte[(4 - optLen % 4) % 4];
        for (pos = 0; pos < pad.length; pos += i3) {
            i3 = is.read(pad, pos, pad.length - pos);
            if (i3 != -1) continue;
            throw new IOException("Unexpected end of stream");
        }
        byte[] id = new byte[idLen];
        for (pos = 0; pos < id.length; pos += i2) {
            i2 = is.read(id, pos, id.length - pos);
            if (i2 != -1) continue;
            throw new IOException("Unexpected end of stream");
        }
        pad = new byte[(4 - idLen % 4) % 4];
        for (pos = 0; pos < pad.length; pos += i2) {
            i2 = is.read(pad, pos, pad.length - pos);
            if (i2 != -1) continue;
            throw new IOException("Unexpected end of stream");
        }
        byte[] type = new byte[typeLen];
        for (pos = 0; pos < type.length; pos += i) {
            i = is.read(type, pos, type.length - pos);
            if (i != -1) continue;
            throw new IOException("Unexpected end of stream");
        }
        pad = new byte[(4 - typeLen % 4) % 4];
        for (pos = 0; pos < pad.length; pos += i) {
            i = is.read(pad, pos, pad.length - pos);
            if (i != -1) continue;
            throw new IOException("Unexpected end of stream");
        }
        DimeRecord dr = new DimeRecord(is, payloadLength, tnf, new String(type), new String(id));
        dr.last = last;
        dr.first = first;
        dr.continued = continued;
        return dr;
    }

    protected synchronized void produce(OutputStream os, long length, boolean begin, boolean end) throws IOException {
        if (this.payload == null) {
            throw new IllegalStateException("produce or getPayload already called");
        }
        if (length > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("payload size cannot be bigger than 4294967295");
        }
        byte[] myId = this.id;
        byte[] myType = this.type;
        TypeNameFormat myTnf = this.tnf;
        for (long remaining = this.payloadLength; remaining > 0L; remaining -= length) {
            int got;
            int header = 1;
            header <<= 3;
            if (begin) {
                header |= 4;
                begin = false;
            }
            if (end && remaining <= length) {
                header |= 2;
            }
            if (remaining > length) {
                header |= 1;
            }
            header <<= 4;
            header |= myTnf.toInt();
            header <<= 4;
            os.write(DimeRecord.getBytes(header <<= 16));
            header = 0;
            header |= myId.length;
            header <<= 16;
            os.write(DimeRecord.getBytes(header |= myType.length));
            long chunkLen = Math.min(length, remaining);
            os.write(DimeRecord.getBytes((int)(0xFFFFFFFFL & chunkLen)));
            os.write(myId);
            os.write(this.getPad(myId.length));
            os.write(myType);
            os.write(this.getPad(myType.length));
            myType = new byte[]{};
            myId = myType;
            myTnf = TypeNameFormat.UNCHANGED;
            byte[] buff = new byte[8192];
            for (long done = 0L; done < chunkLen; done += (long)got) {
                got = this.payload.read(buff, 0, (int)Math.min((long)buff.length, chunkLen - done));
                if (got == -1) {
                    throw new IOException("Unexcepted end of payload");
                }
                os.write(buff, 0, got);
            }
            os.write(this.getPad(chunkLen));
        }
        this.payload = null;
        os.flush();
    }

    private static int readUnsignedShort(InputStream in) throws IOException {
        int i1 = in.read();
        int i2 = in.read();
        if (i1 == -1 || i2 == -1) {
            throw new IOException("unexpected end of stream");
        }
        return (i1 << 8) + i2;
    }

    private static long readUnsignedInt(InputStream in) throws IOException {
        int i1 = in.read();
        int i2 = in.read();
        int i3 = in.read();
        int i4 = in.read();
        if (i1 == -1 || i2 == -1 || i3 == -1 || i4 == -1) {
            throw new IOException("unexpected end of stream");
        }
        return i1 << 24 | i2 << 16 | i3 << 8 | i4;
    }

    private static String bytes(int x) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < 32; ++i) {
            sb.append((x & Integer.MIN_VALUE) >>> 31);
            x <<= 1;
            if ((i + 1) % 8 != 0) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    private byte[] getPad(long size) {
        byte[] retval = new byte[(4 - (int)(size % 4L)) % 4];
        return retval;
    }

    public synchronized InputStream getPayload() {
        if (this.payload == null) {
            throw new IllegalStateException("produce or getPayload already called");
        }
        InputStream data = this.payload;
        this.payload = null;
        this.fis = new SafeFiniteInputStream(data, this.payloadLength);
        return this.fis;
    }

    public long getPayloadLength() {
        return this.payloadLength;
    }

    public synchronized boolean isConsumed() {
        if (this.fis == null) {
            throw new IllegalStateException("Must call getPayload() first");
        }
        return this.fis.isDone();
    }

    public boolean isContinued() {
        return this.continued;
    }

    public String getId() {
        return this.id == null ? null : (this.id.length == 0 ? null : new String(this.id));
    }

    public String getType() {
        return this.type.length == 0 ? null : new String(this.type);
    }

    public TypeNameFormat getTypeNameFormat() {
        return this.tnf;
    }

    public boolean isLast() {
        return this.last;
    }

    public boolean isFirst() {
        return this.first;
    }

    public String toString() {
        return "DimeRecord(id='" + new String(this.id) + "', tnf='" + this.tnf + "', type='" + new String(this.type) + "', length=" + this.payloadLength + ", first=" + this.first + ", last=" + this.last + ", continued=" + this.continued + ")";
    }

    public static final byte[] getBytes(int i) {
        byte[] b = new byte[]{(byte)(i >>> 24 & 0xFF), (byte)(i >>> 16 & 0xFF), (byte)(i >>> 8 & 0xFF), (byte)(i & 0xFF)};
        return b;
    }

    public class SafeFiniteInputStream
    extends FilterInputStream {
        protected long left;
        int pad;

        public SafeFiniteInputStream(InputStream is, long count) {
            super(is);
            if (is == null) {
                throw new NullPointerException();
            }
            if (count < 0L) {
                throw new IllegalArgumentException("count must be > 0");
            }
            this.left = count;
            this.pad = (4 - (int)(count % 4L)) % 4;
        }

        public void close() throws IOException {
            this.skip(this.left);
        }

        public long skip(long n) throws IOException {
            long result = this.in.skip(Math.min(n, this.left));
            this.left -= result;
            this.checkDone();
            return result;
        }

        public int read() throws IOException {
            byte[] b = new byte[1];
            if (this.read(b, 0, 1) == -1) {
                return -1;
            }
            return b[0] & 0xFF;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            if (this.left == 0L && len > 0) {
                return -1;
            }
            int c = this.in.read(b, off, (int)Math.min((long)len, this.left));
            if (c < 0) {
                throw new EOFException();
            }
            this.left -= (long)c;
            this.checkDone();
            return c;
        }

        private synchronized void checkDone() throws IOException {
            while (this.left == 0L && this.pad != 0) {
                this.pad = (int)((long)this.pad - this.in.skip(this.pad));
            }
        }

        public synchronized boolean isDone() {
            return this.left == 0L && this.pad == 0;
        }

        public int available() throws IOException {
            return (int)Math.min((long)this.in.available(), this.left);
        }
    }

    public static class TypeNameFormat {
        public static final TypeNameFormat UNCHANGED = new TypeNameFormat(0);
        public static final TypeNameFormat MEDIA_TYPE = new TypeNameFormat(1);
        public static final TypeNameFormat URI = new TypeNameFormat(2);
        public static final TypeNameFormat UNKNOWN = new TypeNameFormat(3);
        public static final TypeNameFormat NONE = new TypeNameFormat(4);
        private int val;

        private TypeNameFormat(int i) {
            this.val = i;
        }

        public int toInt() {
            return this.val;
        }

        public static TypeNameFormat get(int v) {
            switch (v) {
                case 0: {
                    return UNCHANGED;
                }
                case 1: {
                    return MEDIA_TYPE;
                }
                case 2: {
                    return URI;
                }
                case 3: {
                    return UNKNOWN;
                }
                case 4: {
                    return NONE;
                }
            }
            throw new IllegalArgumentException("unrecognized value: " + v);
        }

        public boolean equals(Object o) {
            return o instanceof TypeNameFormat && ((TypeNameFormat)o).val == this.val;
        }

        public int hashCode() {
            return this.toInt();
        }

        public boolean isUnchanged() {
            return this.val == 0;
        }

        public boolean isMediaType() {
            return this.val == 1;
        }

        public boolean isUri() {
            return this.val == 2;
        }

        public boolean isUnknown() {
            return this.val == 3;
        }

        public boolean isNone() {
            return this.val == 4;
        }

        public String toString() {
            switch (this.val) {
                case 0: {
                    return "unchanged";
                }
                case 1: {
                    return "media_type";
                }
                case 2: {
                    return "uri";
                }
                case 3: {
                    return "unknown";
                }
                case 4: {
                    return "none";
                }
            }
            throw new IllegalStateException("Unknown value");
        }
    }
}

