/*
 * Decompiled with CFR 0.152.
 */
package com.onionnetworks.dime;

import com.onionnetworks.dime.DimeRecord;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class DimeParser
implements Iterator {
    private Object nextStoplight = new Object();
    private InputStream in;
    private DimeRecord prev = null;

    public DimeParser(InputStream is) {
        this.in = is;
    }

    public synchronized Object next() {
        try {
            return this.nextRecord();
        }
        catch (IOException doh) {
            doh.printStackTrace();
            throw new NoSuchElementException("IOException");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized DimeRecord nextRecord() throws IOException {
        if (!this.hasNext()) {
            throw new NoSuchElementException("Last Message already returned");
        }
        if (this.prev != null) {
            DimeRecord dimeRecord = this.prev;
            synchronized (dimeRecord) {
                if (!this.prev.isConsumed()) {
                    throw new IllegalStateException("No seconds until you clear your plate.");
                }
            }
        }
        this.prev = DimeRecord.extract(this.in);
        return this.prev;
    }

    public synchronized boolean hasNext() {
        return this.prev == null || !this.prev.isLast();
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public static void main(String[] args) throws Exception {
        DimeParser dp = new DimeParser(new FileInputStream(new File(args[0])));
        int nextRecord = 0;
        int nextPart = 0;
        FileOutputStream fos = null;
        while (dp.hasNext()) {
            int got;
            System.out.println("-----[ Record: " + nextRecord++);
            DimeRecord dr = dp.nextRecord();
            long pl = dr.getPayloadLength();
            System.out.println("Payload Length: " + pl);
            System.out.println("Id: " + dr.getId());
            System.out.println("Type: " + new String(dr.getType() != null ? dr.getType() : "<null>"));
            System.out.println("TNF: " + dr.getTypeNameFormat().toInt());
            System.out.println("First:" + dr.isFirst());
            System.out.println("Last:" + dr.isLast());
            System.out.println("Continued:" + dr.isContinued());
            if (fos == null) {
                fos = new FileOutputStream(new File("part-" + ++nextPart));
            }
            byte[] buf = new byte[8192];
            InputStream is = dr.getPayload();
            while ((got = is.read(buf, 0, buf.length)) != -1) {
                fos.write(buf, 0, got);
            }
            if (!dr.isContinued()) {
                fos.flush();
                fos.close();
                fos = null;
            }
            System.out.println("Payload: <part-" + nextPart + ">");
        }
    }
}

