/*
 * Decompiled with CFR 0.152.
 */
package phex.xml.sax.parser.share;

import java.io.CharArrayWriter;
import javax.xml.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import phex.utils.NLogger;
import phex.xml.sax.parser.share.AlternateLocationHandler;
import phex.xml.sax.share.DAlternateLocation;
import phex.xml.sax.share.DSharedFile;

public class SharedFileHandler
extends DefaultHandler {
    public static final String THIS_TAG_NAME = "SF";
    private CharArrayWriter text = new CharArrayWriter();
    private SAXParser parser;
    private DSharedFile dFile;
    private DefaultHandler parent;

    public SharedFileHandler(DSharedFile dSharedFile, DefaultHandler defaultHandler, SAXParser sAXParser) {
        this.dFile = dSharedFile;
        this.parser = sAXParser;
        this.parent = defaultHandler;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.text.reset();
        if (string3.equals("AltLoc")) {
            DAlternateLocation dAlternateLocation = new DAlternateLocation();
            this.dFile.getAltLocList().add(dAlternateLocation);
            AlternateLocationHandler alternateLocationHandler = new AlternateLocationHandler(dAlternateLocation, this, this.parser);
            this.parser.getXMLReader().setContentHandler(alternateLocationHandler);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (string3.equals("FID")) {
            this.dFile.setFileName(this.text.toString());
        } else if (string3.equals("SHA1")) {
            this.dFile.setSha1(this.text.toString());
        } else if (string3.equals("TxRH")) {
            this.dFile.setThexRootHash(this.text.toString());
        } else if (string3.equals("TxD")) {
            try {
                this.dFile.setThexTreeDepth(Integer.parseInt(this.text.toString()));
            }
            catch (NumberFormatException numberFormatException) {
                NLogger.error(SharedFileHandler.class, (Object)numberFormatException, (Throwable)numberFormatException);
            }
        } else if (string3.equals("TxLLN")) {
            this.dFile.setThexLowestLevelNodes(this.text.toString());
        } else if (string3.equals("CT")) {
            try {
                this.dFile.setCreationTime(Long.parseLong(this.text.toString()));
            }
            catch (NumberFormatException numberFormatException) {
                NLogger.error(SharedFileHandler.class, (Object)numberFormatException, (Throwable)numberFormatException);
            }
        } else if (string3.equals("LM")) {
            try {
                this.dFile.setLastModified(Long.parseLong(this.text.toString()));
            }
            catch (NumberFormatException numberFormatException) {
                NLogger.error(SharedFileHandler.class, (Object)numberFormatException, (Throwable)numberFormatException);
            }
        } else if (string3.equals("LS")) {
            try {
                this.dFile.setLastSeen(Long.parseLong(this.text.toString()));
            }
            catch (NumberFormatException numberFormatException) {
                NLogger.error(SharedFileHandler.class, (Object)numberFormatException, (Throwable)numberFormatException);
            }
        } else if (string3.equals("HC")) {
            try {
                this.dFile.setHitCount(Integer.parseInt(this.text.toString()));
            }
            catch (NumberFormatException numberFormatException) {
                NLogger.error(SharedFileHandler.class, (Object)numberFormatException, (Throwable)numberFormatException);
            }
        } else if (string3.equals("UC")) {
            try {
                this.dFile.setUploadCount(Integer.parseInt(this.text.toString()));
            }
            catch (NumberFormatException numberFormatException) {
                NLogger.error(SharedFileHandler.class, (Object)numberFormatException, (Throwable)numberFormatException);
            }
        } else if (string3.equals(THIS_TAG_NAME)) {
            this.parser.getXMLReader().setContentHandler(this.parent);
        }
    }

    public InputSource resolveEntity(String string, String string2) {
        return null;
    }

    public void characters(char[] cArray, int n, int n2) {
        this.text.write(cArray, n, n2);
    }
}

