/*
 * Decompiled with CFR 0.152.
 */
package phex.xml.impl.runtime;

import com.sun.xml.bind.validator.Locator;
import javax.xml.bind.ValidationEventLocator;
import javax.xml.bind.helpers.ValidationEventImpl;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import phex.xml.impl.runtime.SAXUnmarshallerHandler;

public class ErrorHandlerAdaptor
implements ErrorHandler {
    private final SAXUnmarshallerHandler host;
    private final Locator locator;

    public ErrorHandlerAdaptor(SAXUnmarshallerHandler sAXUnmarshallerHandler, Locator locator) {
        this.host = sAXUnmarshallerHandler;
        this.locator = locator;
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        this.propagateEvent(1, sAXParseException);
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        this.propagateEvent(0, sAXParseException);
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.propagateEvent(2, sAXParseException);
    }

    private void propagateEvent(int n, SAXParseException sAXParseException) throws SAXException {
        ValidationEventLocator validationEventLocator = this.locator.getLocation(sAXParseException);
        ValidationEventImpl validationEventImpl = new ValidationEventImpl(n, sAXParseException.getMessage(), validationEventLocator);
        Exception exception = sAXParseException.getException();
        if (exception != null) {
            validationEventImpl.setLinkedException(exception);
        } else {
            validationEventImpl.setLinkedException(sAXParseException);
        }
        this.host.handleEvent(validationEventImpl, n != 2);
    }
}

