/*
 * Decompiled with CFR 0.152.
 */
package phex.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TimerTask;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import phex.common.Cfg;
import phex.common.Environment;
import phex.common.ServiceManager;
import phex.common.URN;
import phex.connection.NetworkManager;
import phex.download.MagnetData;
import phex.download.swarming.SwarmingManager;
import phex.utils.IOUtil;
import phex.utils.NLogger;

public class SubscriptionDownloader
extends TimerTask {
    public SubscriptionDownloader() {
        Environment.getInstance().scheduleTimerTask(this, 0L, 172800000L);
    }

    public void run() {
        List list = this.loadSubscriptionList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            NetworkManager.getInstance().fireIncomingUriDownload(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List loadSubscriptionList() {
        String string;
        InputStream inputStream = SubscriptionDownloader.class.getResourceAsStream(string = "/subscription.list");
        if (inputStream == null) {
            ArrayList arrayList = ServiceManager.sCfg.subscriptionMagnets;
            ArrayList arrayList2 = ServiceManager.sCfg.subscriptionMagnets;
            if (arrayList == null && Cfg.default_subscriptionMagnets != null) {
                arrayList.add(Cfg.default_subscriptionMagnets);
            }
            return arrayList2;
        }
        try {
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            ArrayList<String> arrayList = new ArrayList<String>();
            String string2 = bufferedReader.readLine();
            if (string2 == null && Cfg.default_subscriptionMagnets != null) {
                arrayList.add(Cfg.default_subscriptionMagnets);
            }
            while (string2 != null) {
                arrayList.add(string2);
                string2 = bufferedReader.readLine();
            }
            ArrayList<String> arrayList3 = arrayList;
            return arrayList3;
        }
        catch (IOException iOException) {
            NLogger.warn(SubscriptionDownloader.class, (Object)iOException);
        }
        finally {
            IOUtil.closeQuietly(inputStream);
        }
        return Collections.EMPTY_LIST;
    }

    private void createDownload(String string) throws URIException {
        if (string.length() == 0) {
            return;
        }
        URI uRI = new URI(string, true);
        MagnetData magnetData = MagnetData.parseFromURI(uRI);
        URN uRN = MagnetData.lookupSHA1URN(magnetData);
        SwarmingManager swarmingManager = SwarmingManager.getInstance();
        if (!swarmingManager.isURNDownloaded(uRN)) {
            swarmingManager.addFileToDownload(uRI);
        }
    }
}

