/*
 * Decompiled with CFR 0.152.
 */
package phex.utils;

import java.text.NumberFormat;
import java.util.Random;
import java.util.StringTokenizer;
import phex.common.Cfg;

public final class StringUtils {
    public static final String FILE_DELIMITERS = " -._+/*()[]\\";
    public static NumberFormat FILE_LENGTH_FORMAT = NumberFormat.getInstance();
    private static Random randomizer = new Random();
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static String createNaturalSearchTerm(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",-._()[]");
        int n = stringTokenizer.countTokens();
        if (n == 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (string2.length() < Cfg.MIN_SEARCH_TERM_LENGTH) continue;
            stringBuffer.append(string2);
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    public static String join(Object[] objectArray, String string) {
        int n;
        if (objectArray == null) {
            return null;
        }
        if (string == null) {
            string = "";
        }
        int n2 = (n = objectArray.length) == 0 ? 0 : n * ((objectArray[0] == null ? 16 : objectArray[0].toString().length()) + string.length());
        StringBuffer stringBuffer = new StringBuffer(n2);
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuffer.append(string);
            }
            if (objectArray[i] == null) continue;
            stringBuffer.append(objectArray[i]);
        }
        return stringBuffer.toString();
    }

    public static String replace(String string, String string2, String string3, int n) {
        if (StringUtils.isEmpty(string) || StringUtils.isEmpty(string2) || string3 == null || n == 0) {
            return string;
        }
        int n2 = 0;
        int n3 = string.indexOf(string2, n2);
        if (n3 == -1) {
            return string;
        }
        int n4 = string3.length() - string2.length();
        int n5 = n4 = n4 < 0 ? 0 : n4;
        StringBuffer stringBuffer = new StringBuffer(string.length() + (n4 *= n < 0 ? 16 : (n > 64 ? 64 : n)));
        while (n3 != -1) {
            stringBuffer.append(string.substring(n2, n3)).append(string3);
            n2 = n3 + string2.length();
            if (--n == 0) break;
            n3 = string.indexOf(string2, n2);
        }
        stringBuffer.append(string.substring(n2));
        return stringBuffer.toString();
    }

    public static String generateRandomUUIDString() {
        byte[] byArray = new byte[16];
        randomizer.nextBytes(byArray);
        byArray[6] = (byte)(byArray[6] & 0xF);
        byArray[6] = (byte)(byArray[6] | 0x40);
        byArray[8] = (byte)(byArray[8] & 0x3F);
        byArray[8] = (byte)(byArray[8] | 0xFFFFFF80);
        StringBuffer stringBuffer = new StringBuffer(36);
        for (int i = 0; i < 16; ++i) {
            int n = byArray[i] & 0xFF;
            stringBuffer.append(HEX_CHARS[n >> 4]);
            stringBuffer.append(HEX_CHARS[n & 0xF]);
        }
        stringBuffer.insert(8, '-');
        stringBuffer.insert(13, '-');
        stringBuffer.insert(18, '-');
        stringBuffer.insert(23, '-');
        return stringBuffer.toString();
    }
}

