/*
 * Decompiled with CFR 0.152.
 */
package phex.utils;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class RSSParser {
    private static final String EOL_CHARACTERS = "\r\n";
    private static final char[] AMPERSAND_AMP = new char[]{'a', 'm', 'p', ';'};
    private static final String START_OF_ELEMENT_CHAR = "<";
    private static final String END_OF_ELEMENT_CHAR = ">";
    private static final String END_OF_ELEMENT_CHARN = "/";
    private static final char[] XML_LINE = new char[]{'<', '?', 'x', 'm', 'l'};
    private static final char[] MAGNET_PREFIX = new char[]{'m', 'a', 'g', 'n', 'e', 't'};
    private static final char[] HTTP_PREFIX = new char[]{'h', 't', 't', 'p', ':', '/'};
    private static final char[] MAGNET_TAG = new char[]{'<', 'm', 'a', 'g', 'n', 'e', 't', '>'};
    private static final char[] ENCLOSURE_TAG_START = new char[]{'<', 'e', 'n', 'c', 'l', 'o', 's', 'u'};
    private static final char[] ENCLOSURE_TAG_MID = new char[]{'r', 'e'};
    private static final char[] URL_IDENTIFIER = new char[]{'u', 'r', 'l', '=', '\"'};
    private static final char[] ITEM_ELEMENT = new char[]{'<', 'i', 't', 'e', 'm', '>'};
    private static final char[] END_OF_ITEM_ELEMENT = new char[]{'<', '/', 'i', 't', 'e', 'm', '>'};
    private static final char[] RSS_TAG = new char[]{'<', 'r', 's', 's', '>'};
    private static final char[] END_OF_RSS_TAG = new char[]{'<', '/', 'r', 's', 's', '>'};
    private PushbackReader reader;
    private ArrayList magnets = new ArrayList();

    public RSSParser(Reader reader) {
        this.reader = new PushbackReader(reader, 6);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws IOException {
        try {
            int n;
            char[] cArray = new char[5];
            for (int i = 0; i != 5; i += n) {
                n = this.reader.read(cArray, i, 5);
                if (n != -1) continue;
                throw new IOException("Input file is no XML-File (" + String.valueOf(cArray) + ").");
            }
            if (Arrays.equals(cArray, XML_LINE)) {
                this.parseXml();
            }
        }
        finally {
            this.reader.close();
        }
    }

    public List getMagnets() {
        return this.magnets;
    }

    private void parseXml() throws IOException {
        int n = 0;
        while (true) {
            int n2;
            if ((n2 = this.reader.read()) == RSS_TAG[n]) {
                if (++n != RSS_TAG.length) continue;
                this.parseList();
                n = 0;
                continue;
            }
            if (n2 == -1) {
                return;
            }
            n = 0;
            this.parseList();
        }
    }

    private void parseList() throws IOException {
        int n = 0;
        while (true) {
            int n2;
            if ((n2 = this.reader.read()) == ITEM_ELEMENT[n]) {
                if (++n != ITEM_ELEMENT.length) continue;
                this.parseItemBody();
                n = 0;
                continue;
            }
            if (n2 == END_OF_RSS_TAG[n]) {
                if (++n != END_OF_RSS_TAG.length) continue;
                n = 0;
                return;
            }
            if (n2 == -1) {
                return;
            }
            n = 0;
        }
    }

    public void parseItemBody() throws IOException {
        int n = 0;
        block0: while (true) {
            int n2;
            int n3;
            char[] cArray;
            int n4;
            if ((n4 = this.reader.read()) == MAGNET_TAG[n]) {
                if (++n != MAGNET_TAG.length) continue;
                cArray = new char[6];
                for (n2 = 0; n2 != 6; n2 += n3) {
                    n3 = this.reader.read(cArray, n2, 6);
                    if (n3 != -1) continue;
                    return;
                }
                this.reader.unread(cArray);
                if (Arrays.equals(cArray, MAGNET_PREFIX)) {
                    n = 0;
                    this.parseMagnet();
                } else if (Arrays.equals(cArray, HTTP_PREFIX)) {
                    n = 0;
                    this.parseMagnet();
                }
                n = 0;
                continue;
            }
            if (n4 == ENCLOSURE_TAG_START[n]) {
                if (++n != ENCLOSURE_TAG_START.length) continue;
                n = 0;
                while (true) {
                    if ((n4 = this.reader.read()) == URL_IDENTIFIER[n]) {
                        if (++n != URL_IDENTIFIER.length) continue;
                        cArray = new char[6];
                        for (n2 = 0; n2 != 6; n2 += n3) {
                            n3 = this.reader.read(cArray, n2, 6);
                            if (n3 != -1) continue;
                            return;
                        }
                        this.reader.unread(cArray);
                        if (Arrays.equals(cArray, MAGNET_PREFIX)) {
                            n = 0;
                            this.parseMagnet();
                            continue block0;
                        }
                        if (!Arrays.equals(cArray, HTTP_PREFIX)) continue;
                        n = 0;
                        this.parseMagnet();
                        continue block0;
                    }
                    if (END_OF_ELEMENT_CHAR.indexOf(n4) != -1) {
                        n = 0;
                        continue block0;
                    }
                    if (n4 == -1) {
                        n = 0;
                        return;
                    }
                    n = 0;
                }
            }
            if (n4 == -1) {
                n = 0;
                return;
            }
            if (n <= 6 && n4 == END_OF_ITEM_ELEMENT[n]) {
                if (++n != END_OF_ITEM_ELEMENT.length) continue;
                n = 0;
                return;
            }
            n = 0;
        }
    }

    public void parseMagnet() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            int n;
            if ((n = this.reader.read()) == 32 || EOL_CHARACTERS.indexOf(n) != -1) {
                continue;
            }
            if (n == 60 || n == 34) break;
            if (n == -1) {
                return;
            }
            if (n == 38) {
                int n2;
                char[] cArray = new char[4];
                for (int i = 0; i != 4; i += n2) {
                    n2 = this.reader.read(cArray, i, 4);
                    if (n2 != -1) continue;
                    return;
                }
                if (Arrays.equals(cArray, AMPERSAND_AMP)) {
                    stringBuffer.append('&');
                    continue;
                }
                this.reader.unread(cArray);
                stringBuffer.append((char)n);
                continue;
            }
            stringBuffer.append((char)n);
        }
        this.magnets.add(stringBuffer.toString());
    }

    private void skipToEndOfObject() throws IOException {
        int n;
        while ((n = this.reader.read()) >= 0) {
            if (START_OF_ELEMENT_CHAR.indexOf(n) != -1) {
                n = this.reader.read();
                if (END_OF_ELEMENT_CHARN.indexOf(n) != -1) {
                    return;
                }
                this.reader.unread(n);
                continue;
            }
            if (END_OF_ELEMENT_CHARN.indexOf(n) == -1) continue;
            n = this.reader.read();
            if (END_OF_ELEMENT_CHAR.indexOf(n) != -1) {
                return;
            }
            this.reader.unread(n);
        }
        return;
    }
}

