/*
 * Decompiled with CFR 0.152.
 */
package phex.utils;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.DecimalFormatSymbols;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import phex.common.ServiceManager;
import phex.utils.IOUtil;
import phex.utils.NLogger;

public class Localizer {
    private static Map langKeyMap;
    private static Locale usedLocale;
    private static List availableLocales;
    private static DecimalFormatSymbols decimalFormatSymbols;

    public static void initialize() {
        Locale locale;
        Localizer.setUsedLocale(Locale.US);
        String string = ServiceManager.sCfg.usedLocale;
        if (string == null || string.length() == 0 || string.length() != 2 && string.length() != 5 && string.length() != 8) {
            locale = Locale.US;
        } else {
            String string2 = string.substring(0, 2);
            String string3 = "";
            if (string.length() >= 5) {
                string3 = string.substring(3, 5);
            }
            String string4 = "";
            if (string.length() == 8) {
                string4 = string.substring(6, 8);
            }
            locale = new Locale(string2, string3, string4);
        }
        Localizer.setUsedLocale(locale);
    }

    public static void setUsedLocale(Locale locale) {
        usedLocale = locale;
        Localizer.buildResourceBundle(locale);
        decimalFormatSymbols = new DecimalFormatSymbols(usedLocale);
    }

    public static Locale getUsedLocale() {
        return usedLocale;
    }

    public static DecimalFormatSymbols getDecimalFormatSymbols() {
        return decimalFormatSymbols;
    }

    private static void buildResourceBundle(Locale locale) {
        String string;
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer("Lang");
        arrayList.add(stringBuffer.toString());
        String string2 = locale.getLanguage();
        if (string2.length() > 0) {
            stringBuffer.append('_');
            stringBuffer.append(string2);
            arrayList.add(stringBuffer.toString());
            object = locale.getCountry();
            if (((String)object).length() > 0) {
                stringBuffer.append('_');
                stringBuffer.append((String)object);
                arrayList.add(stringBuffer.toString());
                string = locale.getVariant();
                if (string.length() > 0) {
                    stringBuffer.append('_');
                    stringBuffer.append(string);
                    arrayList.add(stringBuffer.toString());
                }
            }
        }
        langKeyMap = new HashMap();
        object = new HashMap();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            string = "/phex/resources/" + (String)arrayList.get(i) + ".properties";
            object = Localizer.loadProperties(string);
            if (object != null) {
                langKeyMap.putAll(object);
                NLogger.debug("LOCALIZATION", (Object)("Loaded language map: " + string + "."));
            }
            if ((object = Localizer.loadProperties(string = "/" + (String)arrayList.get(i) + ".properties")) == null) continue;
            langKeyMap.putAll(object);
            NLogger.debug("LOCALIZATION", (Object)("Loaded language map: " + string + "."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HashMap loadProperties(String string) {
        InputStream inputStream = Localizer.class.getResourceAsStream(string);
        if (inputStream == null) {
            return null;
        }
        inputStream = new BufferedInputStream(inputStream);
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
            HashMap<Object, Object> hashMap = new HashMap<Object, Object>(properties);
            return hashMap;
        }
        catch (IOException iOException) {
        }
        finally {
            IOUtil.closeQuietly(inputStream);
        }
        return null;
    }

    public static List getAvailableLocales() {
        if (availableLocales != null) {
            return availableLocales;
        }
        availableLocales = new ArrayList();
        List list = Localizer.loadLocalList("/language.list");
        availableLocales.addAll(list);
        list = Localizer.loadLocalList("/phex/resources/language.list");
        availableLocales.addAll(list);
        return availableLocales;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List loadLocalList(String string) {
        InputStream inputStream = Localizer.class.getResourceAsStream(string);
        if (inputStream == null) {
            return Collections.EMPTY_LIST;
        }
        try {
            Object object;
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "ISO-8859-1"));
            ArrayList<Locale> arrayList = new ArrayList<Locale>();
            while ((string2 = bufferedReader.readLine()) != null) {
                if ((string2 = string2.trim()).startsWith("#") || string2.length() != 2 && string2.length() != 5 && string2.length() != 8) continue;
                object = string2.substring(0, 2);
                String string3 = "";
                if (string2.length() >= 5) {
                    string3 = string2.substring(3, 5);
                }
                String string4 = "";
                if (string2.length() == 8) {
                    string4 = string2.substring(6, 8);
                }
                Locale locale = new Locale((String)object, string3, string4);
                arrayList.add(locale);
            }
            object = arrayList;
            return object;
        }
        catch (IOException iOException) {
            NLogger.error("LOCALIZATION", (Object)iOException, (Throwable)iOException);
        }
        finally {
            IOUtil.closeQuietly(inputStream);
        }
        return Collections.EMPTY_LIST;
    }

    public static String getString(String string) {
        String string2 = (String)langKeyMap.get(string);
        if (string2 == null) {
            NLogger.error("LOCALIZATION", "Missing language key: " + string);
            string2 = string;
        }
        return string2;
    }

    public static char getChar(String string) {
        String string2 = Localizer.getString(string);
        return string2.charAt(0);
    }

    public static String getFormatedString(String string, Object[] objectArray) {
        String string2 = null;
        String string3 = (String)langKeyMap.get(string);
        if (string3 != null) {
            string2 = MessageFormat.format(string3, objectArray);
        } else {
            NLogger.info(Localizer.class, (Object)("Missing language key: " + string));
            string2 = string;
        }
        return string2;
    }
}

