/*
 * Decompiled with CFR 0.152.
 */
package phex.utils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.httpclient.URI;
import phex.common.URN;
import phex.download.MagnetData;
import phex.download.swarming.SwarmingManager;
import phex.utils.MagmaParser;
import phex.utils.NLogger;

public final class InternalFileHandler {
    public static void magmaReadout(File file) {
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            MagmaParser magmaParser = new MagmaParser(bufferedInputStream);
            magmaParser.start();
            List list = magmaParser.getMagnets();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                URI uRI = new URI(string, true);
                MagnetData magnetData = MagnetData.parseFromURI(uRI);
                URN uRN = MagnetData.lookupSHA1URN(magnetData);
                SwarmingManager swarmingManager = SwarmingManager.getInstance();
                if (swarmingManager.isURNDownloaded(uRN)) continue;
                swarmingManager.addFileToDownload(uRI);
            }
        }
        catch (IOException iOException) {
            NLogger.warn("MAGMA", (Object)iOException.getMessage(), (Throwable)iOException);
        }
    }

    public static void sheduledReadout(URI uRI, long l) {
        try {
            MagnetData magnetData = MagnetData.parseFromURI(uRI);
            URN uRN = MagnetData.lookupSHA1URN(magnetData);
            SwarmingManager swarmingManager = SwarmingManager.getInstance();
            if (!swarmingManager.isURNDownloaded(uRN)) {
                swarmingManager.addFileToDownload(uRI);
            }
        }
        catch (IOException iOException) {
            NLogger.warn("MAGMA", (Object)iOException.getMessage(), (Throwable)iOException);
        }
    }
}

