/*
 * Decompiled with CFR 0.152.
 */
package phex.utils;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import phex.utils.IOUtil;
import phex.utils.NLogger;

public class GnutellaInputStream
extends InputStream {
    private static final char CR = '\r';
    private static final char LF = '\n';
    private int READ_BUFFER_LENGTH = 2048;
    private int LINE_BUFFER_LENGTH = 64;
    private byte[] buffer;
    private int position;
    private int count;
    private InputStream inStream;
    private Inflater inflater;

    public GnutellaInputStream(InputStream inputStream) {
        this.inStream = inputStream;
        this.buffer = new byte[this.READ_BUFFER_LENGTH];
    }

    public void activateInputInflation() throws IOException {
        Object object;
        this.inflater = new Inflater();
        if (this.count - this.position > 0) {
            object = new byte[this.count - this.position];
            System.arraycopy(this.buffer, this.position, object, 0, this.count - this.position);
            this.inflater.setInput((byte[])object);
            try {
                this.inflater.inflate(this.buffer);
            }
            catch (DataFormatException dataFormatException) {
                NLogger.error("GLOBAL", (Object)dataFormatException, (Throwable)dataFormatException);
                throw new IOException(dataFormatException.getMessage());
            }
        }
        object = new InflaterInputStream(this.inStream, this.inflater);
        this.inStream = object;
        this.count = 0;
        this.position = 0;
    }

    public String readLine() throws IOException {
        if (this.inStream == null) {
            return null;
        }
        int n = 0;
        if (this.inflater != null) {
            n = this.inflater.getTotalIn();
        }
        StringBuffer stringBuffer = new StringBuffer(this.LINE_BUFFER_LENGTH);
        int n2 = 0;
        while (true) {
            int n3 = this.read();
            ++n2;
            if (n3 < 0) {
                if (stringBuffer.length() != 0) break;
                return null;
            }
            if (n3 == 13) continue;
            if (n3 == 10) break;
            stringBuffer.append((char)n3);
        }
        return stringBuffer.toString();
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.inStream == null) {
            return -1;
        }
        if ((n | n2 | n + n2 | byArray.length - (n + n2)) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        int n3 = 0;
        if (this.inflater != null) {
            n3 = this.inflater.getTotalIn();
        }
        int n4 = this.readInternal(byArray, n, n2);
        return n4;
    }

    private int readInternal(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.count - this.position;
        if (n3 <= 0) {
            if (n2 >= this.buffer.length) {
                return this.inStream.read(byArray, n, n2);
            }
            this.fill();
            n3 = this.count - this.position;
            if (n3 <= 0) {
                return -1;
            }
        }
        int n4 = n3 < n2 ? n3 : n2;
        System.arraycopy(this.buffer, this.position, byArray, n, n4);
        this.position += n4;
        return n4;
    }

    public int peek() throws IOException {
        if (this.position >= this.count) {
            this.fill();
            if (this.position >= this.count) {
                return -1;
            }
        }
        return this.buffer[this.position] & 0xFF;
    }

    public int read() throws IOException {
        if (this.position >= this.count) {
            this.fill();
            if (this.position >= this.count) {
                return -1;
            }
        }
        return this.buffer[this.position++] & 0xFF;
    }

    public synchronized int available() throws IOException {
        return this.count - this.position + this.inStream.available();
    }

    public void close() {
        IOUtil.closeQuietly(this.inStream);
        this.position = 0;
        this.count = 0;
        this.inStream = null;
        this.buffer = IOUtil.EMPTY_BYTE_ARRAY;
    }

    protected void fill() throws IOException {
        this.position = 0;
        this.count = 0;
        try {
            int n = this.inStream.read(this.buffer, 0, this.buffer.length);
            if (n > 0) {
                this.count = n;
            }
        }
        catch (EOFException eOFException) {
            return;
        }
    }
}

