/*
 * Decompiled with CFR 0.152.
 */
package phex.upload;

import java.io.File;
import phex.common.ServiceManager;
import phex.common.TransferDataProvider;
import phex.common.URN;
import phex.common.address.DestAddress;
import phex.common.bandwidth.TransferAverage;
import phex.common.log.LogRecord;
import phex.upload.UploadConstants;
import phex.upload.UploadEngine;
import phex.upload.UploadManager;
import phex.utils.Logger;

public class UploadState
implements TransferDataProvider,
UploadConstants {
    private UploadManager uploadManager = UploadManager.getInstance();
    private long transferredDataSize = 0L;
    private Integer currentProgress = new Integer(0);
    private short status;
    private DestAddress hostAddress;
    private String vendor;
    private String fileName;
    private URN fileURN;
    private File uploadFile;
    private UploadEngine uploadEngine;
    private long previousSegmentsSize = 0L;
    private TransferAverage transferAverage;
    private long transferLength;

    public UploadState(DestAddress destAddress, String string) {
        this(destAddress, string, null, null, null, -1L);
    }

    public UploadState(DestAddress destAddress, String string, String string2, URN uRN, File file, long l) {
        this.hostAddress = destAddress;
        this.vendor = string;
        this.fileName = string2;
        this.fileURN = uRN;
        this.uploadFile = file;
        this.transferLength = l;
        this.status = 0;
        this.transferAverage = new TransferAverage(1000, 10);
    }

    public void update(DestAddress destAddress, String string) {
        this.hostAddress = destAddress;
        this.vendor = string;
    }

    public void update(DestAddress destAddress, String string, String string2) {
        this.hostAddress = destAddress;
        this.vendor = string;
        this.fileName = string2;
    }

    public void update(DestAddress destAddress, String string, String string2, URN uRN, File file, long l) {
        this.hostAddress = destAddress;
        this.vendor = string;
        this.fileName = string2;
        this.fileURN = uRN;
        this.uploadFile = file;
        this.transferLength = l;
    }

    public File getUploadFile() {
        return this.uploadFile;
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getFileName() {
        return this.fileName;
    }

    public URN getFileURN() {
        return this.fileURN;
    }

    public DestAddress getHostAddress() {
        return this.hostAddress;
    }

    public short getStatus() {
        return this.status;
    }

    public void addToUploadLog(String string) {
        if (ServiceManager.sCfg.uploadStateLogBufferSize > 0L) {
            LogRecord logRecord = new LogRecord(this, string);
            UploadManager.getInstance().getUploadStateLogBuffer().addLogRecord(logRecord);
        }
    }

    public void setStatus(short s) {
        if (this.status == s) {
            return;
        }
        Logger.logMessage(Logger.FINE, (short)4, "UploadState Status " + s);
        switch (s) {
            case 3: 
            case 4: {
                this.uploadStopNotify();
                break;
            }
            case 2: {
                this.uploadStartNotify();
            }
        }
        this.status = s;
        this.uploadManager.fireUploadFileChanged(this);
    }

    private void uploadStartNotify() {
    }

    private void uploadStopNotify() {
    }

    public boolean isUploadRunning() {
        return this.status == 2;
    }

    public void setUploadEngine(UploadEngine uploadEngine) {
        this.uploadEngine = uploadEngine;
    }

    public void setTransferredDataSize(long l) {
        long l2 = l - this.transferredDataSize;
        if (l2 < 0L) {
            this.previousSegmentsSize += this.transferredDataSize;
            this.transferAverage.addValue(l);
        } else {
            this.transferAverage.addValue(l2);
        }
        this.transferredDataSize = l;
        this.uploadManager.fireUploadFileChanged(this);
    }

    public Integer getProgress() {
        int n;
        if (this.status == 3) {
            n = 100;
        } else {
            long l = this.getTransferDataSize();
            n = (int)(this.getTransferredDataSize() * 100L / (l == 0L ? 1L : l));
        }
        if (this.currentProgress != n) {
            this.currentProgress = new Integer(n);
        }
        return this.currentProgress;
    }

    public void stopUpload() {
        if (this.uploadEngine != null) {
            this.uploadEngine.stopUpload();
        }
        this.setStatus((short)4);
    }

    public long getTransferSpeed() {
        return this.transferAverage.getAverage();
    }

    public long getTransferDataSize() {
        return this.transferLength + this.previousSegmentsSize;
    }

    public long getTransferredDataSize() {
        return this.transferredDataSize + this.previousSegmentsSize;
    }

    public long getTotalDataSize() {
        return this.getTransferDataSize();
    }

    public void setTransferRateTimestamp(long l) {
        throw new UnsupportedOperationException();
    }

    public int getShortTermTransferRate() {
        throw new UnsupportedOperationException();
    }

    public int getLongTermTransferRate() {
        return (int)this.getTransferSpeed();
    }

    public short getDataTransferStatus() {
        switch (this.status) {
            case 2: {
                return 10;
            }
            case 4: {
                return 13;
            }
            case 3: {
                return 12;
            }
        }
        return 11;
    }
}

