/*
 * Decompiled with CFR 0.152.
 */
package phex.upload;

import java.util.ArrayList;
import java.util.TimerTask;
import phex.common.AbstractManager;
import phex.common.Environment;
import phex.common.IPCounter;
import phex.common.ServiceManager;
import phex.common.address.DestAddress;
import phex.common.log.LogBuffer;
import phex.event.AsynchronousDispatcher;
import phex.event.UploadFilesChangeListener;
import phex.http.HTTPRequest;
import phex.net.connection.Connection;
import phex.upload.UploadEngine;
import phex.upload.UploadState;
import phex.utils.NLogger;

public class UploadManager
extends AbstractManager {
    private LogBuffer uploadStateLogBuffer;
    private IPCounter uploadIPCounter;
    private ArrayList uploadStateList;
    private ArrayList queuedStateList;
    private ArrayList listenerList = new ArrayList(2);

    private UploadManager() {
        this.uploadIPCounter = new IPCounter(ServiceManager.sCfg.mMaxUploadPerIP);
        this.uploadStateList = new ArrayList();
        this.queuedStateList = new ArrayList();
    }

    public static UploadManager getInstance() {
        return Holder.manager;
    }

    public boolean initialize() {
        if (ServiceManager.sCfg.uploadStateLogBufferSize > 0L) {
            this.uploadStateLogBuffer = new LogBuffer(ServiceManager.sCfg.uploadStateLogBufferSize);
        }
        return true;
    }

    public boolean onPostInitialization() {
        Environment.getInstance().scheduleTimerTask(new CleanUploadStateTimer(), 10000L, 10000L);
        return true;
    }

    public void startupCompletedNotify() {
    }

    public void shutdown() {
    }

    public void handleUploadRequest(Connection connection, HTTPRequest hTTPRequest) {
        UploadEngine uploadEngine = new UploadEngine(connection, hTTPRequest);
        uploadEngine.startUpload();
    }

    public boolean isHostBusy() {
        return this.getUploadingCount() >= ServiceManager.sCfg.mMaxUpload;
    }

    public boolean isQueueLimitReached() {
        return this.queuedStateList.size() >= ServiceManager.sCfg.maxUploadQueueSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validateAndCountIP(DestAddress destAddress) {
        IPCounter iPCounter = this.uploadIPCounter;
        synchronized (iPCounter) {
            this.uploadIPCounter.setMaxCount(ServiceManager.sCfg.mMaxUploadPerIP);
            return this.uploadIPCounter.validateAndCountIP(destAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseUploadIP(DestAddress destAddress) {
        IPCounter iPCounter = this.uploadIPCounter;
        synchronized (iPCounter) {
            this.uploadIPCounter.relaseIP(destAddress);
        }
    }

    public LogBuffer getUploadStateLogBuffer() {
        return this.uploadStateLogBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUploadState(UploadState uploadState) {
        ArrayList arrayList = this.uploadStateList;
        synchronized (arrayList) {
            int n = this.uploadStateList.size();
            this.uploadStateList.add(uploadState);
            this.fireUploadFileAdded(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsUploadState(UploadState uploadState) {
        ArrayList arrayList = this.uploadStateList;
        synchronized (arrayList) {
            return this.uploadStateList.contains(uploadState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUploadListSize() {
        ArrayList arrayList = this.uploadStateList;
        synchronized (arrayList) {
            return this.uploadStateList.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUploadingCount() {
        int n = 0;
        ArrayList arrayList = this.uploadStateList;
        synchronized (arrayList) {
            for (int i = this.uploadStateList.size() - 1; i >= 0; --i) {
                UploadState uploadState = (UploadState)this.uploadStateList.get(i);
                if (uploadState.getStatus() != 2 && uploadState.getStatus() != 0) continue;
                ++n;
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UploadState getUploadStateAt(int n) {
        ArrayList arrayList = this.uploadStateList;
        synchronized (arrayList) {
            if (n < 0 || n >= this.uploadStateList.size()) {
                return null;
            }
            return (UploadState)this.uploadStateList.get(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UploadState[] getUploadStatesAt(int[] nArray) {
        ArrayList arrayList = this.uploadStateList;
        synchronized (arrayList) {
            int n = nArray.length;
            UploadState[] uploadStateArray = new UploadState[n];
            int n2 = this.uploadStateList.size();
            for (int i = 0; i < n; ++i) {
                uploadStateArray[i] = nArray[i] < 0 || nArray[i] >= n2 ? null : (UploadState)this.uploadStateList.get(nArray[i]);
            }
            return uploadStateArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUploadState(UploadState uploadState) {
        int n;
        uploadState.stopUpload();
        ArrayList arrayList = this.uploadStateList;
        synchronized (arrayList) {
            n = this.uploadStateList.indexOf(uploadState);
            if (n != -1) {
                this.uploadStateList.remove(n);
                this.fireUploadFileRemoved(n);
            }
        }
        arrayList = this.queuedStateList;
        synchronized (arrayList) {
            n = this.queuedStateList.indexOf(uploadState);
            if (n != -1) {
                this.queuedStateList.remove(n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanUploadStateList() {
        ArrayList arrayList = this.uploadStateList;
        synchronized (arrayList) {
            for (int i = this.uploadStateList.size() - 1; i >= 0; --i) {
                UploadState uploadState = (UploadState)this.uploadStateList.get(i);
                short s = uploadState.getStatus();
                if (s == 2 || s == 0) continue;
                this.uploadStateList.remove(i);
                this.fireUploadFileRemoved(i);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addQueuedUpload(UploadState uploadState) {
        int n;
        ArrayList arrayList = this.queuedStateList;
        synchronized (arrayList) {
            n = this.queuedStateList.size();
            this.queuedStateList.add(uploadState);
        }
        this.fireUploadQueueChanged();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeQueuedUpload(UploadState uploadState) {
        ArrayList arrayList = this.queuedStateList;
        synchronized (arrayList) {
            int n = this.queuedStateList.indexOf(uploadState);
            if (n != -1) {
                this.queuedStateList.remove(n);
                this.fireUploadQueueChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getQueuedPosition(UploadState uploadState) {
        ArrayList arrayList = this.queuedStateList;
        synchronized (arrayList) {
            return this.queuedStateList.indexOf(uploadState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUploadQueueSize() {
        ArrayList arrayList = this.queuedStateList;
        synchronized (arrayList) {
            return this.queuedStateList.size();
        }
    }

    public void addUploadFilesChangeListener(UploadFilesChangeListener uploadFilesChangeListener) {
        this.listenerList.add(uploadFilesChangeListener);
    }

    public void removeUploadFilesChangeListener(UploadFilesChangeListener uploadFilesChangeListener) {
        this.listenerList.remove(uploadFilesChangeListener);
    }

    private void fireUploadFileChanged(final int n) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = UploadManager.this.listenerList.toArray();
                for (int i = objectArray.length - 1; i >= 0; --i) {
                    UploadFilesChangeListener uploadFilesChangeListener = (UploadFilesChangeListener)objectArray[i];
                    uploadFilesChangeListener.uploadFileChanged(n);
                }
            }
        });
    }

    private void fireUploadFileAdded(final int n) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = UploadManager.this.listenerList.toArray();
                for (int i = objectArray.length - 1; i >= 0; --i) {
                    UploadFilesChangeListener uploadFilesChangeListener = (UploadFilesChangeListener)objectArray[i];
                    uploadFilesChangeListener.uploadFileAdded(n);
                }
            }
        });
    }

    private void fireUploadQueueChanged() {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = UploadManager.this.listenerList.toArray();
                for (int i = objectArray.length - 1; i >= 0; --i) {
                    UploadFilesChangeListener uploadFilesChangeListener = (UploadFilesChangeListener)objectArray[i];
                    uploadFilesChangeListener.uploadQueueChanged();
                }
            }
        });
    }

    private void fireUploadFileRemoved(final int n) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = UploadManager.this.listenerList.toArray();
                for (int i = objectArray.length - 1; i >= 0; --i) {
                    UploadFilesChangeListener uploadFilesChangeListener = (UploadFilesChangeListener)objectArray[i];
                    uploadFilesChangeListener.uploadFileRemoved(n);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireUploadFileChanged(UploadState uploadState) {
        ArrayList arrayList = this.uploadStateList;
        synchronized (arrayList) {
            int n = this.uploadStateList.indexOf(uploadState);
            if (n >= 0) {
                this.fireUploadFileChanged(n);
            }
        }
    }

    private class CleanUploadStateTimer
    extends TimerTask {
        private static final long TIMER_PERIOD = 10000L;

        private CleanUploadStateTimer() {
        }

        public void run() {
            try {
                if (ServiceManager.sCfg.mUploadAutoRemoveCompleted) {
                    UploadManager.this.cleanUploadStateList();
                }
            }
            catch (Throwable throwable) {
                NLogger.error("UPLOAD", (Object)throwable, throwable);
            }
        }
    }

    private static class Holder {
        protected static final UploadManager manager = new UploadManager();

        private Holder() {
        }
    }
}

