/*
 * Decompiled with CFR 0.152.
 */
package phex.upload;

import com.onionnetworks.dime.DimeGenerator;
import com.onionnetworks.dime.DimeRecord;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import phex.common.AltLocContainer;
import phex.common.AlternateLocation;
import phex.common.ServiceManager;
import phex.common.URN;
import phex.common.address.AddressUtils;
import phex.common.address.DefaultDestAddress;
import phex.common.address.DestAddress;
import phex.common.bandwidth.BandwidthController;
import phex.common.bandwidth.BandwidthManager;
import phex.download.swarming.SWDownloadFile;
import phex.download.swarming.SwarmingManager;
import phex.host.HostManager;
import phex.host.NetworkHostsContainer;
import phex.http.GnutellaRequest;
import phex.http.HTTPHeader;
import phex.http.HTTPMessageException;
import phex.http.HTTPProcessor;
import phex.http.HTTPRangeSet;
import phex.http.HTTPRequest;
import phex.http.HTTPResponse;
import phex.http.Range;
import phex.http.XQueueParameters;
import phex.net.connection.Connection;
import phex.net.presentation.SocketFacade;
import phex.share.PartialShareFile;
import phex.share.ShareFile;
import phex.share.ShareManager;
import phex.share.SharedFilesService;
import phex.statistic.SimpleStatisticProvider;
import phex.statistic.StatisticsManager;
import phex.thex.ShareFileThexData;
import phex.upload.UploadManager;
import phex.upload.UploadState;
import phex.utils.GnutellaOutputStream;
import phex.utils.IOUtil;
import phex.utils.NLogger;
import phex.utils.StringUtils;
import phex.utils.URLUtil;
import phex.utils.VendorCodes;
import phex.xml.thex.ThexHashTree;
import phex.xml.thex.ThexHashTreeCodec;

public class UploadEngine {
    private static final int BUFFER_LENGTH = 16384;
    private RandomAccessFile raFile;
    private final Connection connection;
    private boolean isUploadQueued;
    private long minNextPollTime;
    private long startOffset;
    private long endOffset;
    private long fileStartOffset;
    private HTTPRequest httpRequest;
    private UploadState uploadState;
    private boolean isIPCounted;
    private DestAddress hostAddress;
    private Set sendAltLocSet;
    public boolean isUploadCounted;
    private boolean isPersistentConnection;
    private ShareFile uploadShareFile;

    public UploadEngine(Connection connection, HTTPRequest hTTPRequest) {
        this.connection = connection;
        connection.setBandwidthController(BandwidthManager.getInstance().getUploadBandwidthController());
        this.httpRequest = hTTPRequest;
        this.isIPCounted = false;
        this.isUploadCounted = false;
        this.sendAltLocSet = new HashSet();
        SocketFacade socketFacade = connection.getSocket();
        this.hostAddress = socketFacade.getRemoteAddress();
        this.uploadState = new UploadState(this.hostAddress, VendorCodes.UNKNOWN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void startUpload() {
        NLogger.debug(UploadEngine.class, (Object)"Start upload.");
        this.uploadState.addToUploadLog("Start upload.");
        try {
            try {}
            catch (Exception exception) {
                this.uploadState.setStatus((short)4);
                NLogger.warn(UploadEngine.class, (Object)exception, (Throwable)exception);
                this.uploadState.addToUploadLog(exception.toString() + " - " + exception.getMessage());
                Object var4_8 = null;
                if (this.uploadState.getStatus() == 2 || this.uploadState.getStatus() == 0) {
                    NLogger.debug(UploadEngine.class, (Object)"Upload state should not be in init or up state anymore.");
                    NLogger.debug(UploadEngine.class, (Object)("Upload request: " + this.httpRequest.buildHTTPRequestString()));
                }
                this.stopUpload();
                UploadManager uploadManager = UploadManager.getInstance();
                if (this.isIPCounted) {
                    uploadManager.releaseUploadIP(this.hostAddress);
                }
                this.uploadState.setUploadEngine(null);
                if (!this.isUploadQueued) return;
                uploadManager.removeQueuedUpload(this.uploadState);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_9 = null;
            if (this.uploadState.getStatus() == 2 || this.uploadState.getStatus() == 0) {
                NLogger.debug(UploadEngine.class, (Object)"Upload state should not be in init or up state anymore.");
                NLogger.debug(UploadEngine.class, (Object)("Upload request: " + this.httpRequest.buildHTTPRequestString()));
            }
            this.stopUpload();
            UploadManager uploadManager = UploadManager.getInstance();
            if (this.isIPCounted) {
                uploadManager.releaseUploadIP(this.hostAddress);
            }
            this.uploadState.setUploadEngine(null);
            if (!this.isUploadQueued) throw throwable;
            uploadManager.removeQueuedUpload(this.uploadState);
            throw throwable;
        }
        do {
            block23: {
                block22: {
                    try {
                        boolean bl = this.evaluateHTTPRequest();
                        if (bl) break block22;
                        this.uploadState.setStatus((short)4);
                    }
                    catch (IOException iOException) {
                        this.uploadState.setStatus((short)4);
                        throw iOException;
                    }
                    Object var4_6 = null;
                    if (this.uploadState.getStatus() == 2 || this.uploadState.getStatus() == 0) {
                        NLogger.debug(UploadEngine.class, (Object)"Upload state should not be in init or up state anymore.");
                        NLogger.debug(UploadEngine.class, (Object)("Upload request: " + this.httpRequest.buildHTTPRequestString()));
                    }
                    this.stopUpload();
                    UploadManager uploadManager = UploadManager.getInstance();
                    if (this.isIPCounted) {
                        uploadManager.releaseUploadIP(this.hostAddress);
                    }
                    this.uploadState.setUploadEngine(null);
                    if (!this.isUploadQueued) return;
                    uploadManager.removeQueuedUpload(this.uploadState);
                    return;
                }
                if (this.httpRequest.isHeadRequest()) {
                    this.uploadState.setStatus((short)3);
                    break block23;
                }
                if (this.isUploadQueued) break block23;
                GnutellaRequest gnutellaRequest = this.httpRequest.getGnutellaRequest();
                if (gnutellaRequest.isTigerTreeRequest()) {
                    this.sendDIMEMessage(this.uploadShareFile);
                } else {
                    this.sendBinaryData();
                }
            }
            if (!this.isPersistentConnection) continue;
            try {
                this.readNextHTTPRequest();
            }
            catch (IOException iOException) {
                NLogger.debug(class$phex$upload$UploadEngine == null ? UploadEngine.class$("phex.upload.UploadEngine") : class$phex$upload$UploadEngine, (Object)iOException);
                this.uploadState.addToUploadLog(iOException.toString() + " - " + iOException.getMessage());
                this.isPersistentConnection = false;
            }
        } while (this.isPersistentConnection);
        Object var4_7 = null;
        if (this.uploadState.getStatus() == 2 || this.uploadState.getStatus() == 0) {
            NLogger.debug(UploadEngine.class, (Object)"Upload state should not be in init or up state anymore.");
            NLogger.debug(UploadEngine.class, (Object)("Upload request: " + this.httpRequest.buildHTTPRequestString()));
        }
        this.stopUpload();
        UploadManager uploadManager = UploadManager.getInstance();
        if (this.isIPCounted) {
            uploadManager.releaseUploadIP(this.hostAddress);
        }
        this.uploadState.setUploadEngine(null);
        if (!this.isUploadQueued) return;
        uploadManager.removeQueuedUpload(this.uploadState);
    }

    public void stopUpload() {
        this.connection.disconnect();
        IOUtil.closeQuietly(this.raFile);
    }

    private void sendBinaryData() throws IOException {
        Object object;
        Object object2;
        NLogger.debug(UploadEngine.class, (Object)("About to send binary range: " + this.startOffset + " to " + this.endOffset));
        this.uploadState.addToUploadLog("About to send binary range: " + this.startOffset + " to " + this.endOffset);
        if (!this.isUploadCounted) {
            this.uploadShareFile.incUploadCount();
            object2 = StatisticsManager.getInstance();
            object = (SimpleStatisticProvider)((StatisticsManager)object2).getStatisticProvider("SessionUploadCountProvider");
            ((SimpleStatisticProvider)object).increment(1);
            this.isUploadCounted = true;
        }
        this.uploadState.setStatus((short)2);
        object2 = this.uploadState.getUploadFile();
        this.raFile = new RandomAccessFile((File)object2, "r");
        this.raFile.seek(this.fileStartOffset);
        object = BandwidthManager.getInstance().getUploadBandwidthController();
        long l = 0L;
        int n = -1;
        GnutellaOutputStream gnutellaOutputStream = this.connection.getOutputStream();
        byte[] byArray = new byte[16384];
        for (long i = this.endOffset - this.startOffset + 1L; i > 0L; i -= (long)n) {
            int n2 = (int)Math.min(i, 16384L);
            int n3 = ((BandwidthController)object).getAvailableByteCount(true);
            int n4 = Math.min(n2, n3);
            if (NLogger.isDebugEnabled(class$phex$upload$UploadEngine == null ? UploadEngine.class$("phex.upload.UploadEngine") : class$phex$upload$UploadEngine)) {
                NLogger.debug(class$phex$upload$UploadEngine == null ? UploadEngine.class$("phex.upload.UploadEngine") : class$phex$upload$UploadEngine, (Object)("Reading in " + n4 + " bytes at " + this.raFile.getFilePointer() + " from " + ((File)object2).getName()));
            }
            if ((n = this.raFile.read(byArray, 0, n4)) == -1) break;
            ((OutputStream)gnutellaOutputStream).write(byArray, 0, n);
            this.uploadState.setTransferredDataSize(l += (long)n);
        }
        this.uploadState.setStatus((short)3);
    }

    private boolean evaluateHTTPRequest() throws IOException {
        HTTPResponse hTTPResponse;
        Object object;
        ShareFile shareFile;
        Object object2;
        HTTPHeader hTTPHeader;
        String string = "HTTP Request: " + this.httpRequest.buildHTTPRequestString();
        NLogger.debug(UploadEngine.class, (Object)string);
        this.uploadState.addToUploadLog(string);
        GnutellaRequest gnutellaRequest = this.httpRequest.getGnutellaRequest();
        if (gnutellaRequest == null) {
            throw new IOException("Not a Gnutella file request.");
        }
        if (gnutellaRequest.getURN() == null && (hTTPHeader = this.httpRequest.getHeader("X-Gnutella-Content-URN")) != null && URN.isValidURN(hTTPHeader.getValue())) {
            object2 = new URN(hTTPHeader.getValue());
            gnutellaRequest.setContentURN((URN)object2);
        }
        object2 = this.connection.getSocket();
        int n = -1;
        hTTPHeader = this.httpRequest.getHeader("Listen-IP");
        if (hTTPHeader == null) {
            hTTPHeader = this.httpRequest.getHeader("X-My-Address");
        }
        if (hTTPHeader != null) {
            n = AddressUtils.parsePort(hTTPHeader.getValue());
        }
        if (n <= 0) {
            n = object2.getRemoteAddress().getPort();
        }
        this.hostAddress = new DefaultDestAddress(object2.getRemoteAddress().getHostName(), n);
        UploadManager uploadManager = UploadManager.getInstance();
        if (!this.isIPCounted) {
            boolean bl = uploadManager.validateAndCountIP(this.hostAddress);
            if (!bl) {
                HTTPResponse hTTPResponse2 = new HTTPResponse(503, "Upload Limit Reached for IP", true);
                this.sendHTTPResponse(hTTPResponse2);
                return false;
            }
            this.isIPCounted = true;
        }
        if ((shareFile = this.findShareFile(gnutellaRequest)) == null) {
            HTTPResponse hTTPResponse3 = new HTTPResponse(404, "File not found", true);
            this.sendHTTPResponse(hTTPResponse3);
            return false;
        }
        this.isUploadQueued = false;
        if (uploadManager.isHostBusy()) {
            hTTPHeader = this.httpRequest.getHeader("X-Queue");
            if (hTTPHeader == null || !ServiceManager.sCfg.allowUploadQueuing || uploadManager.isQueueLimitReached()) {
                HTTPResponse hTTPResponse4 = new HTTPResponse(503, "Upload Limit Reached", true);
                this.addAltLocResponseHeader(hTTPResponse4, shareFile);
                this.sendHTTPResponse(hTTPResponse4);
                return false;
            }
            this.isUploadQueued = true;
        }
        HTTPHeader hTTPHeader2 = null;
        HTTPRangeSet hTTPRangeSet = null;
        Range range = null;
        if (!gnutellaRequest.isTigerTreeRequest()) {
            short s;
            hTTPHeader2 = this.httpRequest.getHeader("Range");
            if (hTTPHeader2 != null) {
                hTTPRangeSet = HTTPRangeSet.parseHTTPRangeSet(hTTPHeader2.getValue(), true);
                if (hTTPRangeSet == null) {
                    HTTPResponse hTTPResponse5 = new HTTPResponse(500, "Requested Range Not Parseable", true);
                    this.addAltLocResponseHeader(hTTPResponse5, shareFile);
                    this.sendHTTPResponse(hTTPResponse5);
                    return false;
                }
            } else {
                hTTPRangeSet = new HTTPRangeSet(0L, -1L);
            }
            if ((s = shareFile.getRangeAvailableStatus(range = hTTPRangeSet.getFirstRange())) != 0) {
                HTTPResponse hTTPResponse6 = s == 1 ? new HTTPResponse(503, "Requested Range Not Available", true) : new HTTPResponse(416, "Requested Range Not Satisfiable", true);
                if (shareFile instanceof PartialShareFile) {
                    PartialShareFile partialShareFile = (PartialShareFile)shareFile;
                    hTTPResponse6.addHeader(new HTTPHeader("X-Available-Ranges", partialShareFile.buildXAvailableRangesString()));
                }
                this.addAltLocResponseHeader(hTTPResponse6, shareFile);
                this.sendHTTPResponse(hTTPResponse6);
                return false;
            }
        }
        String string2 = null;
        hTTPHeader = this.httpRequest.getHeader("User-Agent");
        string2 = hTTPHeader != null ? hTTPHeader.getValue() : "";
        hTTPHeader = this.httpRequest.getHeader("Connection");
        this.isPersistentConnection = "HTTP/1.1".equals(this.httpRequest.getHTTPVersion()) ? hTTPHeader == null || !hTTPHeader.getValue().equalsIgnoreCase("CLOSE") : hTTPHeader != null && hTTPHeader.getValue().equalsIgnoreCase("KEEP-ALIVE");
        if (this.isUploadQueued) {
            this.uploadState.update(this.hostAddress, string2);
            int n2 = uploadManager.getQueuedPosition(this.uploadState) + 1;
            if (n2 < 0) {
                n2 = uploadManager.addQueuedUpload(this.uploadState) + 1;
            }
            this.uploadState.setStatus((short)1);
            int n3 = uploadManager.getUploadQueueSize();
            int n4 = ServiceManager.sCfg.mMaxUpload;
            int n5 = ServiceManager.sCfg.minUploadQueuePollTime;
            int n6 = ServiceManager.sCfg.maxUploadQueuePollTime;
            HTTPResponse hTTPResponse7 = new HTTPResponse(503, "Remotely Queued", true);
            this.addAltLocResponseHeader(hTTPResponse7, shareFile);
            XQueueParameters xQueueParameters = new XQueueParameters(n2, n3, n4, n5, n6);
            hTTPResponse7.addHeader(new HTTPHeader("X-Queue", xQueueParameters.buildHTTPString()));
            this.sendHTTPResponse(hTTPResponse7);
            object2.setSoTimeout(n6 * 1000);
            this.minNextPollTime = System.currentTimeMillis() + (long)(n5 * 1000);
            return true;
        }
        HTTPHeader hTTPHeader3 = null;
        long l = 0L;
        if (!gnutellaRequest.isTigerTreeRequest()) {
            if (shareFile instanceof PartialShareFile) {
                object = (PartialShareFile)shareFile;
                ((PartialShareFile)object).findFittingPartForRange(range);
                this.fileStartOffset = ((PartialShareFile)object).getFileStartOffset();
                hTTPHeader3 = new HTTPHeader("X-Available-Ranges", ((PartialShareFile)object).buildXAvailableRangesString());
            } else {
                this.fileStartOffset = range.getStartOffset(shareFile.getFileSize());
            }
            this.startOffset = range.getStartOffset(shareFile.getFileSize());
            this.endOffset = range.getEndOffset(shareFile.getFileSize());
            l = this.endOffset - this.startOffset + 1L;
        }
        object = shareFile.getURN();
        if (gnutellaRequest.isTigerTreeRequest()) {
            this.uploadState.update(this.hostAddress, string2, shareFile.getFileName());
        } else {
            this.uploadState.update(this.hostAddress, string2, shareFile.getFileName(), (URN)object, shareFile.getSystemFile(), l);
        }
        if (!uploadManager.containsUploadState(this.uploadState)) {
            uploadManager.addUploadState(this.uploadState);
        }
        this.uploadState.setUploadEngine(this);
        if (!gnutellaRequest.isTigerTreeRequest()) {
            hTTPResponse = this.startOffset == 0L && this.endOffset == shareFile.getFileSize() - 1L ? new HTTPResponse(200, "OK", true) : new HTTPResponse(206, "Partial Content", true);
            if (hTTPHeader3 != null) {
                hTTPResponse.addHeader(hTTPHeader3);
            }
        } else {
            hTTPResponse = new HTTPResponse(200, "OK", true);
        }
        hTTPResponse.addHeader(new HTTPHeader("Content-Type", "application/binary"));
        if (!gnutellaRequest.isTigerTreeRequest()) {
            hTTPResponse.addHeader(new HTTPHeader("Content-Length", String.valueOf(l)));
            hTTPResponse.addHeader(new HTTPHeader("Content-Range", "bytes " + this.startOffset + "-" + this.endOffset + "/" + shareFile.getFileSize()));
        }
        if (this.isPersistentConnection && !gnutellaRequest.isTigerTreeRequest()) {
            hTTPResponse.addHeader(new HTTPHeader("Connection", "Keep-Alive"));
        } else {
            hTTPResponse.addHeader(new HTTPHeader("Connection", "close"));
            this.isPersistentConnection = false;
        }
        if (object != null) {
            hTTPResponse.addHeader(new HTTPHeader("X-Gnutella-Content-URN", ((URN)object).getAsString()));
        }
        if (!gnutellaRequest.isTigerTreeRequest()) {
            this.addAltLocResponseHeader(hTTPResponse, shareFile);
            this.addPushProxyResponseHeader(hTTPResponse);
        }
        if (object != null && !gnutellaRequest.isTigerTreeRequest()) {
            this.parseAltLocRequestHeader(shareFile, (URN)object);
            ShareFileThexData shareFileThexData = shareFile.getThexData(true);
            if (shareFileThexData != null) {
                String string3 = shareFileThexData.getRootHash();
                HTTPHeader hTTPHeader4 = new HTTPHeader("X-Thex-URI", URLUtil.buildName2ResThexURL((URN)object, string3));
                hTTPResponse.addHeader(hTTPHeader4);
            }
        }
        this.sendHTTPResponse(hTTPResponse);
        object2.setSoTimeout(ServiceManager.sCfg.socketConnectTimeout);
        if (this.uploadShareFile != null && !(shareFile instanceof PartialShareFile) && this.uploadShareFile != shareFile) {
            this.isUploadCounted = false;
        }
        this.uploadShareFile = shareFile;
        this.minNextPollTime = -1L;
        return true;
    }

    private void parseAltLocRequestHeader(ShareFile shareFile, URN uRN) {
        AltLocContainer altLocContainer = shareFile.getAltLocContainer();
        ArrayList arrayList = new ArrayList();
        HTTPHeader[] hTTPHeaderArray = this.httpRequest.getHeaders("Alt-Location");
        List list = AltLocContainer.parseUriResAltLocFromHeaders(hTTPHeaderArray);
        arrayList.addAll(list);
        hTTPHeaderArray = this.httpRequest.getHeaders("X-Gnutella-Alternate-Location");
        list = AltLocContainer.parseUriResAltLocFromHeaders(hTTPHeaderArray);
        arrayList.addAll(list);
        hTTPHeaderArray = this.httpRequest.getHeaders("X-Alt");
        list = AltLocContainer.parseCompactIpAltLocFromHeaders(hTTPHeaderArray, uRN);
        arrayList.addAll(list);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            AlternateLocation alternateLocation = (AlternateLocation)iterator.next();
            String string = "Adding AltLoc " + alternateLocation.getHTTPString();
            NLogger.debug(class$phex$upload$UploadEngine == null ? UploadEngine.class$("phex.upload.UploadEngine") : class$phex$upload$UploadEngine, (Object)string);
            this.uploadState.addToUploadLog(string);
            altLocContainer.addAlternateLocation(alternateLocation);
        }
    }

    private void addAltLocResponseHeader(HTTPResponse hTTPResponse, ShareFile shareFile) {
        AltLocContainer altLocContainer = shareFile.getAltLocContainer();
        HTTPHeader hTTPHeader = altLocContainer.getAltLocHTTPHeaderForAddress("X-Alt", this.hostAddress, this.sendAltLocSet);
        if (hTTPHeader != null) {
            hTTPResponse.addHeader(hTTPHeader);
        }
    }

    private void addPushProxyResponseHeader(HTTPResponse hTTPResponse) {
        HostManager hostManager = HostManager.getInstance();
        NetworkHostsContainer networkHostsContainer = hostManager.getNetworkHostsContainer();
        DestAddress[] destAddressArray = networkHostsContainer.getPushProxies();
        if (destAddressArray == null) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = Math.min(4, destAddressArray.length);
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(destAddressArray[i].getFullHostName());
        }
        if (stringBuffer.length() > 0) {
            HTTPHeader hTTPHeader = new HTTPHeader("X-Push-Proxy", stringBuffer.toString());
            hTTPResponse.addHeader(hTTPHeader);
        }
    }

    private void readNextHTTPRequest() throws IOException {
        try {
            this.httpRequest = HTTPProcessor.parseHTTPRequest(this.connection);
            if (this.minNextPollTime > 0L && System.currentTimeMillis() < this.minNextPollTime) {
                throw new IOException("Queued host is requesting too soon.");
            }
        }
        catch (HTTPMessageException hTTPMessageException) {
            throw new IOException("Invalid HTTP Message: " + hTTPMessageException.getMessage());
        }
    }

    private void sendHTTPResponse(HTTPResponse hTTPResponse) throws IOException {
        String string = hTTPResponse.buildHTTPResponseString();
        String string2 = "HTTP Response: " + string;
        NLogger.debug(UploadEngine.class, (Object)string2);
        this.uploadState.addToUploadLog(string2);
        this.connection.write(string.getBytes());
    }

    private ShareFile findShareFile(GnutellaRequest gnutellaRequest) {
        ShareFile shareFile = null;
        SharedFilesService sharedFilesService = ShareManager.getInstance().getSharedFilesService();
        URN uRN = gnutellaRequest.getURN();
        if (uRN != null) {
            SwarmingManager swarmingManager;
            SWDownloadFile sWDownloadFile;
            if (!uRN.isSha1Nid()) {
                uRN = new URN("urn:sha1:" + uRN.getSHA1Nss());
            }
            if ((shareFile = sharedFilesService.getFileByURN(uRN)) == null && ServiceManager.sCfg.arePartialFilesShared && (sWDownloadFile = (swarmingManager = SwarmingManager.getInstance()).getDownloadFileByURN(uRN)) != null) {
                shareFile = new PartialShareFile(sWDownloadFile);
            }
        } else if (gnutellaRequest.getFileIndex() != -1) {
            int n = gnutellaRequest.getFileIndex();
            shareFile = sharedFilesService.getFileByIndex(n);
            if (shareFile != null) {
                String string = shareFile.getFileName();
                if (!gnutellaRequest.getFileName().equalsIgnoreCase(string)) {
                    String string2 = "Requested index '" + n + "' with filename '" + string + "' dosn't match request filename '" + gnutellaRequest.getFileName() + "'.";
                    NLogger.debug(UploadEngine.class, (Object)string2);
                    this.uploadState.addToUploadLog(string2);
                    shareFile = null;
                }
            } else if (gnutellaRequest.getFileName() != null) {
                shareFile = sharedFilesService.getFileByName(gnutellaRequest.getFileName());
            }
        }
        return shareFile;
    }

    private void sendDIMEMessage(ShareFile shareFile) throws IOException {
        this.uploadState.setStatus((short)2);
        ShareFileThexData shareFileThexData = shareFile.getThexData(true);
        String string = StringUtils.generateRandomUUIDString();
        ThexHashTree thexHashTree = new ThexHashTree();
        thexHashTree.setFileSize(String.valueOf(shareFile.getFileSize()));
        thexHashTree.setFileSegmentSize("1024");
        thexHashTree.setDigestAlgorithm("http://open-content.net/spec/digest/tiger");
        thexHashTree.setDigestOutputSize("24");
        thexHashTree.setSerializedTreeDepth(String.valueOf(shareFileThexData.getTreeDepth()));
        thexHashTree.setSerializedTreeType("http://open-content.net/spec/thex/breadthfirst");
        thexHashTree.setSerializedTreeUri("uuid:" + string);
        String string2 = "http://open-content.net/spec/thex/breadthfirst";
        byte[] byArray = ThexHashTreeCodec.generateThexHashTreeXML(thexHashTree);
        byte[] byArray2 = shareFileThexData.getSerializedTreeNodes();
        DimeGenerator dimeGenerator = new DimeGenerator(this.connection.getOutputStream());
        DimeRecord dimeRecord = new DimeRecord(byArray, DimeRecord.TypeNameFormat.MEDIA_TYPE, string2, null);
        dimeGenerator.addRecord(dimeRecord, false);
        DimeRecord dimeRecord2 = new DimeRecord(byArray2, DimeRecord.TypeNameFormat.URI, string2, null);
        dimeGenerator.addRecord(dimeRecord2, true);
        this.connection.flush();
        this.uploadState.setStatus((short)3);
    }
}

