/*
 * Decompiled with CFR 0.152.
 */
package phex.upload;

import java.io.IOException;
import phex.common.ThreadPool;
import phex.common.bandwidth.BandwidthController;
import phex.common.bandwidth.BandwidthManager;
import phex.http.HTTPMessageException;
import phex.http.HTTPProcessor;
import phex.http.HTTPRequest;
import phex.msg.PushRequestMsg;
import phex.net.connection.Connection;
import phex.net.connection.OIOSocketFactory;
import phex.net.presentation.SocketFacade;
import phex.share.ShareFile;
import phex.share.ShareManager;
import phex.statistic.UploadDownloadCountStatistic;
import phex.upload.UploadManager;
import phex.utils.IOUtil;
import phex.utils.Logger;
import phex.utils.NLogger;
import phex.utils.URLCodecUtils;

public class PushWorker
implements Runnable {
    private static final int PUSH_TIMEOUT = 45000;
    private final PushRequestMsg pushMsg;
    private Connection connection;

    public PushWorker(PushRequestMsg pushRequestMsg) {
        this.pushMsg = pushRequestMsg;
        ThreadPool.getInstance().addJob(this, "PushWorker-" + Integer.toHexString(this.hashCode()));
        UploadDownloadCountStatistic.pushUploadAttempts.increment(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() {
        try {
            try {
                HTTPRequest hTTPRequest = this.connectAndGetRequest();
                if (hTTPRequest == null) {
                    UploadDownloadCountStatistic.pushUploadFailure.increment(1);
                    Object var4_2 = null;
                    if (this.connection == null) return;
                    this.connection.disconnect();
                    return;
                }
                this.handleRequest(hTTPRequest);
                Logger.logMessage(Logger.FINER, (short)4, "PushWorker finished");
            }
            catch (Exception exception) {
                NLogger.error("PUSH", (Object)exception, (Throwable)exception);
                Object var4_4 = null;
                if (this.connection == null) return;
                this.connection.disconnect();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (this.connection == null) throw throwable;
            this.connection.disconnect();
            throw throwable;
        }
        Object var4_3 = null;
        if (this.connection == null) return;
        this.connection.disconnect();
    }

    private void handleRequest(HTTPRequest hTTPRequest) {
        Logger.logMessage(Logger.FINE, (short)4, "Handle PUSH request: " + hTTPRequest.buildHTTPRequestString());
        UploadDownloadCountStatistic.pushUploadSuccess.increment(1);
        if (hTTPRequest.isGnutellaRequest()) {
            UploadManager.getInstance().handleUploadRequest(this.connection, hTTPRequest);
        } else {
            ShareManager.getInstance().httpRequestHandler(this.connection, hTTPRequest);
        }
    }

    private HTTPRequest connectAndGetRequest() {
        try {
            Logger.logMessage(Logger.FINE, (short)4, "Try PUSH connect to: " + this.pushMsg.getRequestAddress());
            SocketFacade socketFacade = OIOSocketFactory.connect(this.pushMsg.getRequestAddress(), 45000);
            BandwidthController bandwidthController = BandwidthManager.getInstance().getUploadBandwidthController();
            this.connection = new Connection(socketFacade, bandwidthController);
            this.sendGIV(this.connection);
            HTTPRequest hTTPRequest = HTTPProcessor.parseHTTPRequest(this.connection);
            return hTTPRequest;
        }
        catch (IOException iOException) {
            Logger.logMessage(Logger.FINER, (short)4, iOException);
            return null;
        }
        catch (HTTPMessageException hTTPMessageException) {
            Logger.logMessage(Logger.FINER, (short)4, hTTPMessageException);
            return null;
        }
    }

    private void sendGIV(Connection connection) throws IOException {
        ShareManager shareManager = ShareManager.getInstance();
        ShareFile shareFile = shareManager.getSharedFilesService().getFileByIndex((int)this.pushMsg.getFileIndex());
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("GIV ");
        stringBuffer.append(this.pushMsg.getFileIndex());
        stringBuffer.append(':');
        stringBuffer.append(this.pushMsg.getClientGUID().toHexString());
        stringBuffer.append('/');
        if (shareFile != null) {
            stringBuffer.append(URLCodecUtils.encodeURL(shareFile.getFileName()));
        }
        Logger.logMessage(Logger.FINE, (short)4, "Send GIV: " + stringBuffer.toString());
        byte[] byArray = new byte[stringBuffer.length() + 2];
        int n = IOUtil.serializeString(stringBuffer.toString(), byArray, 0);
        byArray[n++] = 10;
        byArray[n++] = 10;
        connection.write(byArray, 0, n);
        connection.flush();
    }
}

