/*
 * Decompiled with CFR 0.152.
 */
package phex.update;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import javax.xml.bind.JAXBException;
import org.apache.commons.lang.SystemUtils;
import phex.common.Cfg;
import phex.common.Environment;
import phex.common.IntObj;
import phex.common.LongObj;
import phex.common.ServiceManager;
import phex.event.UpdateNotificationListener;
import phex.gui.common.GUIRegistry;
import phex.share.ShareManager;
import phex.share.SharedFilesService;
import phex.statistic.StatisticProvider;
import phex.statistic.StatisticsManager;
import phex.utils.IOUtil;
import phex.utils.NLogger;
import phex.utils.VersionUtils;
import phex.xml.XJBPhex;
import phex.xml.XJBUpdateResponse;
import phex.xml.XMLBuilder;
import phex.xml.sax.DPhex;
import phex.xml.sax.DUpdateRequest;

public class UpdateCheckRunner
implements Runnable {
    private static final String UPDATE_CHECK_URL = "http://phex.kouk.de/update/update.php";
    private Throwable updateCheckError;
    private UpdateNotificationListener listener;
    private String releaseVersion;
    private String betaVersion;
    static final /* synthetic */ boolean $assertionsDisabled;

    public UpdateCheckRunner(UpdateNotificationListener updateNotificationListener) {
        this.listener = updateNotificationListener;
    }

    public String getReleaseVersion() {
        return this.releaseVersion;
    }

    public String getBetaVersion() {
        return this.betaVersion;
    }

    public Throwable getUpdateCheckError() {
        return this.updateCheckError;
    }

    public void run() {
        try {
            this.performUpdateCheck();
        }
        catch (Throwable throwable) {
            this.updateCheckError = throwable;
            NLogger.warn("GLOBAL", (Object)throwable, throwable);
        }
    }

    private void performUpdateCheck() {
        XJBPhex xJBPhex;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        try {
            URL uRL = new URL(UPDATE_CHECK_URL);
            object5 = (HttpURLConnection)uRL.openConnection();
            ((URLConnection)object5).setUseCaches(false);
            ((URLConnection)object5).setRequestProperty("User-Agent", Environment.getPhexVendor());
            ((HttpURLConnection)object5).setRequestMethod("POST");
            ((URLConnection)object5).setDoOutput(true);
            ((URLConnection)object5).setRequestProperty("Content-Type", "text/xml; charset=UTF-8");
            object4 = ((URLConnection)object5).getOutputStream();
            object3 = this.buildXMLUpdateRequest();
            if (object3 == null) {
                throw new IOException("Missing XML update data");
            }
            ((OutputStream)object4).write((byte[])object3);
            if (NLogger.isDebugEnabled("UpdateCheck.Request")) {
                NLogger.debug("UpdateCheck.Request", (Object)new String((byte[])object3));
            }
            object2 = ((URLConnection)object5).getInputStream();
            if (NLogger.isDebugEnabled("UpdateCheck.Response")) {
                object = IOUtil.toByteArray((InputStream)object2);
                NLogger.debug("UpdateCheck.Response", (Object)new String((byte[])object));
                object2 = new ByteArrayInputStream((byte[])object);
            }
            xJBPhex = XMLBuilder.readXJBPhexFromStream((InputStream)object2);
        }
        catch (MalformedURLException malformedURLException) {
            this.updateCheckError = malformedURLException;
            NLogger.warn("GLOBAL", (Object)malformedURLException, (Throwable)malformedURLException);
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            throw new RuntimeException();
        }
        catch (UnknownHostException unknownHostException) {
            this.updateCheckError = unknownHostException;
            NLogger.warn("GLOBAL", (Object)unknownHostException, (Throwable)unknownHostException);
            return;
        }
        catch (SocketException socketException) {
            this.updateCheckError = socketException;
            NLogger.warn("GLOBAL", (Object)socketException, (Throwable)socketException);
            return;
        }
        catch (IOException iOException) {
            this.updateCheckError = iOException;
            NLogger.warn("GLOBAL", (Object)iOException, (Throwable)iOException);
            return;
        }
        catch (JAXBException jAXBException) {
            this.updateCheckError = jAXBException;
            NLogger.warn("GLOBAL", (Object)jAXBException, (Throwable)jAXBException);
            return;
        }
        ServiceManager.sCfg.lastUpdateCheckTime = System.currentTimeMillis();
        object5 = xJBPhex.getUpdateResponse();
        object4 = object5.getVersionList();
        object3 = object4.iterator();
        object2 = null;
        object = null;
        while (object3.hasNext()) {
            XJBUpdateResponse.VersionType versionType = (XJBUpdateResponse.VersionType)object3.next();
            if (versionType.isBeta()) {
                if (object != null && VersionUtils.compare(versionType.getId(), object.getId()) <= 0) continue;
                object = versionType;
                continue;
            }
            if (object2 != null && VersionUtils.compare(versionType.getId(), object2.getId()) <= 0) continue;
            object2 = versionType;
        }
        this.betaVersion = "0";
        this.releaseVersion = "0";
        if (object != null) {
            this.betaVersion = object.getId();
        }
        if (object2 != null) {
            this.releaseVersion = object2.getId();
        }
        int n = 0;
        int n2 = 0;
        n2 = VersionUtils.compare(this.betaVersion, VersionUtils.getFullProgramVersion());
        n = VersionUtils.compare(this.releaseVersion, VersionUtils.getFullProgramVersion());
        if (n <= 0 && n2 <= 0) {
            ServiceManager.sCfg.save();
            return;
        }
        n2 = VersionUtils.compare(this.betaVersion, ServiceManager.sCfg.lastBetaUpdateCheckVersion);
        n = VersionUtils.compare(this.releaseVersion, ServiceManager.sCfg.lastUpdateCheckVersion);
        int n3 = VersionUtils.compare(this.betaVersion, this.releaseVersion);
        boolean bl = false;
        if (n > 0) {
            ServiceManager.sCfg.lastUpdateCheckVersion = this.releaseVersion;
            bl = true;
        }
        if (n2 > 0) {
            ServiceManager.sCfg.lastBetaUpdateCheckVersion = this.betaVersion;
            bl = true;
        }
        if (n3 > 0) {
            this.releaseVersion = null;
        } else {
            this.betaVersion = null;
        }
        ServiceManager.sCfg.save();
        if (bl) {
            this.fireUpdateNotification();
        }
    }

    private void fireUpdateNotification() {
        this.listener.updateNotification(this);
    }

    private byte[] buildXMLUpdateRequest() {
        try {
            Cfg cfg = ServiceManager.sCfg;
            DPhex dPhex = new DPhex();
            DUpdateRequest dUpdateRequest = new DUpdateRequest();
            dPhex.setUpdateRequest(dUpdateRequest);
            dUpdateRequest.setCurrentVersion(VersionUtils.getFullProgramVersion());
            dUpdateRequest.setStartupCount(cfg.totalStartupCounter);
            dUpdateRequest.setLafUsed(GUIRegistry.getInstance().getUsedLAFClass());
            dUpdateRequest.setJavaVersion(System.getProperty("java.version"));
            dUpdateRequest.setOperatingSystem(SystemUtils.OS_NAME);
            dUpdateRequest.setHostid(cfg.mProgramClientID.toHexString());
            dUpdateRequest.setShowBetaInfo(cfg.showBetaUpdateNotification);
            dUpdateRequest.setLastInfoId(cfg.lastShownUpdateInfoId);
            String string = VersionUtils.compare(cfg.lastUpdateCheckVersion, cfg.lastBetaUpdateCheckVersion) > 0 ? cfg.lastUpdateCheckVersion : cfg.lastBetaUpdateCheckVersion;
            dUpdateRequest.setLastCheckVersion(string);
            StatisticsManager statisticsManager = StatisticsManager.getInstance();
            StatisticProvider statisticProvider = statisticsManager.getStatisticProvider("UptimeProvider");
            dUpdateRequest.setAvgUptime(((LongObj)statisticProvider.getAverageValue()).value);
            StatisticProvider statisticProvider2 = statisticsManager.getStatisticProvider("DailyUptimeProvider");
            dUpdateRequest.setDailyAvgUptime(((IntObj)statisticProvider2.getValue()).value);
            StatisticProvider statisticProvider3 = statisticsManager.getStatisticProvider("TotalDownloadCountProvider");
            dUpdateRequest.setDownloadCount((int)((LongObj)statisticProvider3.getValue()).value);
            StatisticProvider statisticProvider4 = statisticsManager.getStatisticProvider("TotalUploadCountProvider");
            dUpdateRequest.setUploadCount((int)((LongObj)statisticProvider4.getValue()).value);
            SharedFilesService sharedFilesService = ShareManager.getInstance().getSharedFilesService();
            dUpdateRequest.setSharedFiles(sharedFilesService.getFileCount());
            dUpdateRequest.setSharedSize(sharedFilesService.getTotalFileSizeInKb());
            dUpdateRequest.setErrorLog(this.getErrorLogFileTail());
            return phex.xml.sax.XMLBuilder.serializeToBytes(dPhex);
        }
        catch (IOException iOException) {
            NLogger.error("GLOBAL", (Object)iOException, (Throwable)iOException);
            return null;
        }
    }

    private String getErrorLogFileTail() {
        try {
            File file = Environment.getInstance().getPhexConfigFile("phex.error.log");
            if (!file.exists()) {
                return null;
            }
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
            long l = Math.max(randomAccessFile.length() - 10240L, 0L);
            randomAccessFile.seek(l);
            byte[] byArray = new byte[10240];
            int n = randomAccessFile.read(byArray);
            return new String(byArray, 0, n);
        }
        catch (IOException iOException) {
            NLogger.error("GLOBAL", (Object)iOException, (Throwable)iOException);
            return iOException.toString();
        }
    }

    static {
        $assertionsDisabled = !UpdateCheckRunner.class.desiredAssertionStatus();
    }
}

