/*
 * Decompiled with CFR 0.152.
 */
package phex.udp.hostcache;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import phex.common.address.DestAddress;
import phex.common.address.MalformedDestAddressException;
import phex.connection.NetworkManager;
import phex.net.presentation.PresentationManager;
import phex.security.PhexSecurityManager;
import phex.udp.hostcache.UdpHostCache;
import phex.udp.hostcache.UdpHostCacheComparator;
import phex.utils.IPUtils;
import phex.utils.NLogger;

public class UdpHostCacheContainer {
    private static int MIN_UDP_HOST_CACHE_SIZE = 20;
    private List functionalUdpCaches = new ArrayList();
    private List generalUdpCaches = new ArrayList();
    private static final List defaultCaches = new ArrayList();
    public static final Comparator cacheComparator = new UdpHostCacheComparator();

    public UdpHostCacheContainer() {
        NLogger.debug("UDP_HOST_CACHE", (Object)" Started up UDP HOST CACHE CONTAINER ");
    }

    public void initialize() {
        this.functionalUdpCaches.clear();
        this.generalUdpCaches.clear();
        this.loadCachesFromFile();
        this.generalUdpCaches.addAll(defaultCaches);
        NLogger.debug("UDP_HOST_CACHE", (Object)" Initialized UDP HOST CACHE CONTAINER ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addFunctionalCache(UdpHostCache udpHostCache) {
        List list = this.generalUdpCaches;
        synchronized (list) {
            if (this.generalUdpCaches.contains(udpHostCache)) {
                this.generalUdpCaches.remove(udpHostCache);
            }
        }
        udpHostCache.resetFailCount();
        NLogger.info("UDP_HOST_CACHE", (Object)" Adding a UDP Host Cache to the FUNCTIONAL Container");
        return this.addTo(udpHostCache, this.functionalUdpCaches);
    }

    public boolean addCache(UdpHostCache udpHostCache) {
        int n = this.generalUdpCaches.size() + this.functionalUdpCaches.size();
        if (udpHostCache.getFailCount() >= 3 && n > MIN_UDP_HOST_CACHE_SIZE) {
            NLogger.info("UDP_HOST_CACHE", (Object)(" Udp host cache dropped due to failure count : " + udpHostCache));
            return false;
        }
        NLogger.info("UDP_HOST_CACHE", (Object)" Adding a UDP Host Cache to the GENERAL HOST CACHE CONTAINER ");
        return this.addTo(udpHostCache, this.generalUdpCaches);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createPackedHostCaches() {
        StringBuffer stringBuffer = new StringBuffer(168);
        List list = this.functionalUdpCaches;
        synchronized (list) {
            Iterator iterator = this.functionalUdpCaches.iterator();
            for (int i = 0; iterator.hasNext() && i < 8; ++i) {
                UdpHostCache udpHostCache = (UdpHostCache)iterator.next();
                DestAddress destAddress = udpHostCache.getHostAddress();
                String string = destAddress.getFullHostName();
                stringBuffer.append(string);
                stringBuffer.append("\n");
            }
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queryMoreHosts() {
        UdpHostCache udpHostCache;
        List list;
        int n;
        int n2 = 0;
        for (n = 0; n < 2; ++n) {
            list = this.functionalUdpCaches;
            synchronized (list) {
                if (this.functionalUdpCaches.isEmpty()) {
                    break;
                }
                udpHostCache = (UdpHostCache)this.functionalUdpCaches.remove(0);
                if (udpHostCache != null) {
                    this.queryCache(udpHostCache);
                    ++n2;
                }
                continue;
            }
        }
        for (n = n2; n <= 3; ++n) {
            list = this.generalUdpCaches;
            synchronized (list) {
                if (this.generalUdpCaches.isEmpty()) {
                    break;
                }
                udpHostCache = (UdpHostCache)this.generalUdpCaches.remove(0);
                if (udpHostCache != null) {
                    this.queryCache(udpHostCache);
                }
                continue;
            }
        }
    }

    private void queryCache(UdpHostCache udpHostCache) {
        NLogger.info("UDP_HOST_CACHE", (Object)(" Pinging UDP Host Cache :" + udpHostCache));
        udpHostCache.pingCache();
        udpHostCache.incrementFailCount();
        this.addCache(udpHostCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCachesFromFile() {
        try {
            NetworkManager networkManager = NetworkManager.getInstance();
            File file = networkManager.getGnutellaNetwork().getUdpHostCacheFile();
            if (!file.exists()) {
                NLogger.debug(UdpHostCacheContainer.class, (Object)"No UDP host cache file found.");
                return;
            }
            PhexSecurityManager phexSecurityManager = PhexSecurityManager.getInstance();
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            List list = this.generalUdpCaches;
            synchronized (list) {
                String string;
                block10: while ((string = bufferedReader.readLine()) != null) {
                    DestAddress destAddress;
                    if (string.startsWith("#")) continue;
                    try {
                        destAddress = PresentationManager.getInstance().createHostAddress(string, 6346);
                    }
                    catch (MalformedDestAddressException malformedDestAddressException) {
                        NLogger.warn("UDP_HOST_CACHE", (Object)(" Could not create cache to add to the container from the host string : " + string), (Throwable)malformedDestAddressException);
                        continue;
                    }
                    byte by = phexSecurityManager.controlHostAddressAccess(destAddress);
                    switch (by) {
                        case 2: 
                        case 3: {
                            continue block10;
                        }
                    }
                    if (IPUtils.isPortInUserInvalidList(destAddress)) continue;
                    UdpHostCache udpHostCache = new UdpHostCache(destAddress);
                    this.addCache(udpHostCache);
                }
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            NLogger.warn("UDP_HOST_CACHE", (Object)" Loading Udp Host Caches  from file FAILED ", (Throwable)iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addTo(UdpHostCache udpHostCache, List list) {
        List list2 = list;
        synchronized (list2) {
            if (!list.contains(udpHostCache)) {
                list.add(udpHostCache);
                Collections.sort(list, cacheComparator);
                NLogger.info("UDP_HOST_CACHE", (Object)(" Added UdpHostCache  : " + udpHostCache));
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean update(UdpHostCache udpHostCache, List list) {
        List list2 = list;
        synchronized (list2) {
            if (list.contains(udpHostCache)) {
                list.remove(udpHostCache);
            }
            list.add(udpHostCache);
            Collections.sort(list, cacheComparator);
            NLogger.info("UDP_HOST_CACHE", (Object)(" Added UdpHostCache  : " + udpHostCache));
            return true;
        }
    }

    public void saveCachesToFile() {
        try {
            NetworkManager networkManager = NetworkManager.getInstance();
            File file = networkManager.getGnutellaNetwork().getUdpHostCacheFile();
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            this.writeCachesToFile(bufferedWriter, this.functionalUdpCaches);
            this.writeCachesToFile(bufferedWriter, this.generalUdpCaches);
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            NLogger.warn("UDP_HOST_CACHE", (Object)" Saving Udp Host Caches  to file FAILED ", (Throwable)iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeCachesToFile(BufferedWriter bufferedWriter, List list) throws IOException {
        List list2 = list;
        synchronized (list2) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                UdpHostCache udpHostCache = (UdpHostCache)iterator.next();
                DestAddress destAddress = udpHostCache.getHostAddress();
                String string = destAddress.getFullHostName();
                bufferedWriter.write(string);
                bufferedWriter.newLine();
            }
        }
    }
}

