/*
 * Decompiled with CFR 0.152.
 */
package phex.udp.hostcache;

import java.io.IOException;
import phex.common.address.DefaultDestAddress;
import phex.common.address.DestAddress;
import phex.udp.UdpConnectionManager;
import phex.utils.NLogger;

public class UdpHostCache {
    public static final int MAX_FAIL_COUNT = 3;
    private DestAddress address;
    private int failedCount;

    public UdpHostCache(DestAddress destAddress) {
        this.address = destAddress;
        this.failedCount = 0;
    }

    public UdpHostCache(DestAddress destAddress, int n) {
        this.address = destAddress;
        this.failedCount = n;
    }

    public UdpHostCache(String string, int n, int n2) throws IllegalArgumentException {
        this.address = new DefaultDestAddress(string, n);
        this.failedCount = n2;
    }

    public void pingCache() {
        try {
            UdpConnectionManager.getInstance().sendUdpPing(this.address);
        }
        catch (IOException iOException) {
            NLogger.warn("UDP_HOST_CACHE", (Object)(" could not ping  Udp Host Cache : " + this.address + " \n "), (Throwable)iOException);
        }
    }

    public void incrementFailCount() {
        if (this.failedCount < 3) {
            ++this.failedCount;
        }
    }

    public void decrementFailCount() {
        --this.failedCount;
    }

    public int getFailCount() {
        return this.failedCount;
    }

    public void resetFailCount() {
        this.failedCount = 0;
    }

    public DestAddress getHostAddress() {
        return this.address;
    }

    public boolean equals(Object object) {
        if (object instanceof UdpHostCache) {
            UdpHostCache udpHostCache = (UdpHostCache)object;
            return this.address.equals(udpHostCache.address);
        }
        return false;
    }

    public int hashCode() {
        return ((Object)this.address).hashCode();
    }

    public String toString() {
        String string = " Host Address : " + this.address + " [ failure count : " + this.failedCount + " ] ";
        return string;
    }
}

