/*
 * Decompiled with CFR 0.152.
 */
package phex.udp;

import phex.common.address.DestAddress;
import phex.msg.Message;
import phex.msg.PingMsg;
import phex.msg.PongMsg;
import phex.utils.PriorityQueue;

public class UdpMsgQueue {
    private static final int PING_QUEUE_SIZE = 15;
    private static final int PONG_QUEUE_SIZE = 20;
    private static final int PING_PRIORITY = 0;
    private static final int PONG_PRIORITY = 1;
    private PriorityQueue queue;

    public UdpMsgQueue() {
        int[] nArray = new int[]{15, 20};
        this.queue = new PriorityQueue(nArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addMessage(Message message, DestAddress destAddress) {
        int n = -1;
        if (message == null) {
            return false;
        }
        if (message instanceof PingMsg) {
            n = 0;
        }
        if (message instanceof PongMsg) {
            n = 1;
        }
        if (n < 0) {
            return false;
        }
        QueueElement queueElement = new QueueElement(message, destAddress);
        PriorityQueue priorityQueue = this.queue;
        synchronized (priorityQueue) {
            this.queue.addToHead(queueElement, n);
            this.queue.notify();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueueElement removeMessage() {
        QueueElement queueElement = null;
        PriorityQueue priorityQueue = this.queue;
        synchronized (priorityQueue) {
            while (this.queue.isEmpty()) {
                try {
                    this.queue.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            queueElement = (QueueElement)this.queue.removeMaxPriority();
        }
        return queueElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        PriorityQueue priorityQueue = this.queue;
        synchronized (priorityQueue) {
            return this.queue.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFull(int n) {
        PriorityQueue priorityQueue = this.queue;
        synchronized (priorityQueue) {
            return this.queue.isFull(n);
        }
    }

    public class QueueElement {
        private Message msg;
        private DestAddress address;

        public QueueElement(Message message, DestAddress destAddress) {
            this.msg = message;
            this.address = destAddress;
        }

        public Message getMsg() {
            return this.msg;
        }

        public DestAddress getAddress() {
            return this.address;
        }
    }
}

