/*
 * Decompiled with CFR 0.152.
 */
package phex.udp;

import java.io.IOException;
import phex.common.AbstractManager;
import phex.common.address.DestAddress;
import phex.msg.PingMsg;
import phex.udp.UdpMessageEngine;
import phex.utils.NLogger;

public class UdpConnectionManager
extends AbstractManager {
    public static final int UDP_PING_PERIOD = 30000;
    private UdpMessageEngine udpMsgEngine;

    public static UdpConnectionManager getInstance() {
        return Holder.manager;
    }

    public boolean initialize() {
        NLogger.info("UDP_CONNECTION", (Object)"Started up Udp Connection Manager");
        return true;
    }

    public boolean onPostInitialization() {
        this.udpMsgEngine = new UdpMessageEngine();
        return true;
    }

    public void startupCompletedNotify() {
    }

    public void shutdown() {
    }

    public void sendUdpPing(DestAddress destAddress) throws IOException {
        PingMsg pingMsg = PingMsg.createUdpPingMsg();
        this.udpMsgEngine.addMessageToSend(pingMsg, destAddress);
        NLogger.debug("UDP_OUTGOING_MESSAGES", (Object)(" Sent Udp Ping to" + destAddress + " : " + pingMsg + " with Scp Byte : " + pingMsg.getScpByte()[0]));
    }

    private static class Holder {
        protected static final UdpConnectionManager manager = new UdpConnectionManager();

        private Holder() {
        }
    }
}

