/*
 * Decompiled with CFR 0.152.
 */
package phex.tools;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import phex.common.address.AddressUtils;

public class Ip2CountryDBBuilder {
    private static final String APNIC = "ftp://ftp.apnic.net/pub/stats/apnic/delegated-apnic-latest";
    private static final String RIPE = "ftp://ftp.apnic.net/pub/stats/ripe-ncc/delegated-ripencc-latest";
    private static final String ARIN = "ftp://ftp.apnic.net/pub/stats/arin/delegated-arin-latest";
    private static final String LACNIC = "ftp://ftp.apnic.net/pub/stats/lacnic/delegated-lacnic-latest";
    private static List dataList;

    public static void main(String[] stringArray) throws Exception {
        dataList = new ArrayList();
        String[] stringArray2 = new String[]{LACNIC, APNIC, RIPE, ARIN};
        for (int i = 0; i < stringArray2.length; ++i) {
            System.out.println("Loading " + stringArray2[i]);
            URL uRL = new URL(stringArray2[i]);
            URLConnection uRLConnection = uRL.openConnection();
            InputStream inputStream = uRLConnection.getInputStream();
            Ip2CountryDBBuilder.readData(inputStream);
            System.out.println("Total data read: " + dataList.size());
            inputStream.close();
        }
        Collections.sort(dataList);
        System.out.println("before size: " + dataList.size());
        Ip2CountryDBBuilder.consolidateList();
        System.out.println("after size: " + dataList.size());
        Ip2CountryDBBuilder.writeToOutputFile("ip2country.csv");
    }

    private static void writeToOutputFile(String string) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter("src/phex/resources/" + string));
        Iterator iterator = dataList.iterator();
        while (iterator.hasNext()) {
            IpCountryRange ipCountryRange = (IpCountryRange)iterator.next();
            bufferedWriter.write("" + ipCountryRange.from + "," + ipCountryRange.to + "," + ipCountryRange.countryCode + "\n");
        }
        bufferedWriter.close();
    }

    private static void consolidateList() {
        ArrayList<IpCountryRange> arrayList = new ArrayList<IpCountryRange>();
        int n = dataList.size();
        for (int i = 0; i < n; ++i) {
            IpCountryRange ipCountryRange = (IpCountryRange)dataList.get(i);
            for (int j = i + 1; j < n; ++j) {
                IpCountryRange ipCountryRange2 = (IpCountryRange)dataList.get(j);
                if (!ipCountryRange.countryCode.equals(ipCountryRange2.countryCode) || ipCountryRange.to + 1L != ipCountryRange2.from) break;
                ipCountryRange.to = ipCountryRange.to + ipCountryRange2.to - ipCountryRange2.from + 1L;
                ++i;
            }
            arrayList.add(ipCountryRange);
        }
        dataList = arrayList;
    }

    private static void readData(InputStream inputStream) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        while ((string = bufferedReader.readLine()) != null) {
            if (string.startsWith("#") || string.startsWith("2") || string.endsWith("summary")) continue;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
            stringTokenizer.nextToken();
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            if (!string3.equals("ipv4")) continue;
            String string4 = stringTokenizer.nextToken();
            String string5 = stringTokenizer.nextToken();
            long l = Long.parseLong(string5);
            byte[] byArray = AddressUtils.parseIP(string4);
            int n = byArray[3] & 0xFF;
            int n2 = byArray[2] << 8 & 0xFF00;
            int n3 = byArray[1] << 16 & 0xFF0000;
            int n4 = byArray[0] << 24;
            long l2 = (long)(n4 | n3 | n2 | n) & 0xFFFFFFFFL;
            long l3 = l2 + l - 1L;
            IpCountryRange ipCountryRange = new IpCountryRange(l2, l3, string2);
            dataList.add(ipCountryRange);
        }
    }

    private static class IpCountryRange
    implements Comparable {
        long from;
        long to;
        String countryCode;

        public IpCountryRange(long l, long l2, String string) {
            this.from = l;
            this.to = l2;
            this.countryCode = string;
        }

        public String toString() {
            return String.valueOf(this.from) + " - " + String.valueOf(this.to) + " " + this.countryCode;
        }

        public int compareTo(Object object) {
            IpCountryRange ipCountryRange = (IpCountryRange)object;
            if (this.from > ipCountryRange.from) {
                return 1;
            }
            if (this.from < ipCountryRange.from) {
                return -1;
            }
            return 0;
        }
    }
}

