/*
 * Decompiled with CFR 0.152.
 */
package phex.statistic;

import java.util.HashMap;
import phex.common.AbstractManager;
import phex.common.bandwidth.BandwidthManager;
import phex.statistic.DailyUptimeStatisticProvider;
import phex.statistic.HorizonStatisticProvider;
import phex.statistic.StatisticProvider;
import phex.statistic.StatisticProviderConstants;
import phex.statistic.TransferAverageStatisticProvider;
import phex.statistic.UploadDownloadCountStatistic;
import phex.statistic.UptimeStatisticProvider;

public class StatisticsManager
extends AbstractManager
implements StatisticProviderConstants {
    private HashMap statisticProviderMap = new HashMap();

    private StatisticsManager() {
    }

    public void registerStatisticProvider(String string, StatisticProvider statisticProvider) {
        this.statisticProviderMap.put(string, statisticProvider);
    }

    public StatisticProvider getStatisticProvider(String string) {
        return (StatisticProvider)this.statisticProviderMap.get(string);
    }

    public static StatisticsManager getInstance() {
        return Holder.manager;
    }

    public boolean initialize() {
        this.registerStatisticProvider("UptimeProvider", new UptimeStatisticProvider());
        this.registerStatisticProvider("DailyUptimeProvider", new DailyUptimeStatisticProvider());
        return true;
    }

    public boolean onPostInitialization() {
        BandwidthManager bandwidthManager = BandwidthManager.getInstance();
        this.registerStatisticProvider("TotalBandwidthProvider", new TransferAverageStatisticProvider(bandwidthManager.getPhexBandwidthController()));
        this.registerStatisticProvider("NetworkBandwidthProvider", new TransferAverageStatisticProvider(bandwidthManager.getNetworkBandwidthController()));
        this.registerStatisticProvider("DownloadBandwidthProvider", new TransferAverageStatisticProvider(bandwidthManager.getDownloadBandwidthController()));
        this.registerStatisticProvider("UploadBandwidthProvider", new TransferAverageStatisticProvider(bandwidthManager.getUploadBandwidthController()));
        UploadDownloadCountStatistic.touch();
        this.registerStatisticProvider("HorizonHostCountProvider", HorizonStatisticProvider.HORIZON_HOST_COUNT_PROVIDER);
        this.registerStatisticProvider("HorizonFileCountProvider", HorizonStatisticProvider.HORIZON_FILE_COUNT_PROVIDER);
        this.registerStatisticProvider("HorizonFileSizeProvider", HorizonStatisticProvider.HORIZON_FILE_SIZE_PROVIDER);
        return true;
    }

    public void startupCompletedNotify() {
    }

    public void shutdown() {
        UptimeStatisticProvider uptimeStatisticProvider = (UptimeStatisticProvider)this.getStatisticProvider("UptimeProvider");
        uptimeStatisticProvider.saveUptimeStats();
        DailyUptimeStatisticProvider dailyUptimeStatisticProvider = (DailyUptimeStatisticProvider)this.getStatisticProvider("DailyUptimeProvider");
        dailyUptimeStatisticProvider.shutdown();
        UploadDownloadCountStatistic.saveStats();
    }

    private static class Holder {
        protected static final StatisticsManager manager = new StatisticsManager();

        private Holder() {
        }
    }
}

