/*
 * Decompiled with CFR 0.152.
 */
package phex.statistic;

import phex.common.IntObj;
import phex.common.ServiceManager;
import phex.common.format.TimeFormatUtils;
import phex.statistic.StatisticProvider;

public class DailyUptimeStatisticProvider
implements StatisticProvider {
    private static final int SECONDS_PER_DAY = 86400;
    private static final int WINDOW_MILLISECONDS = 604800000;
    private long startTime;
    private IntObj valueObj = new IntObj();

    public DailyUptimeStatisticProvider() {
        this.startUptimeMeasurement();
    }

    private void startUptimeMeasurement() {
        this.startTime = System.currentTimeMillis();
    }

    public Object getValue() {
        this.valueObj.setValue(this.calculateDailyUptime());
        return this.valueObj;
    }

    public Object getAverageValue() {
        return null;
    }

    public Object getMaxValue() {
        return null;
    }

    public String toStatisticString(Object object) {
        return TimeFormatUtils.formatSignificantElapsedTime(((IntObj)object).intValue());
    }

    private int calculateDailyUptime() {
        return (int)(this.calculateFractionalUptime() * 86400.0f);
    }

    private float calculateFractionalUptime() {
        float f = Math.min(6.048E8f, (float)(System.currentTimeMillis() - ServiceManager.sCfg.lastShutdownTime));
        float f2 = Math.min(6.048E8f, (float)(System.currentTimeMillis() - this.startTime));
        float f3 = ServiceManager.sCfg.fractionalUptime;
        if (f2 < 0.0f || f < 0.0f || f2 > f) {
            return f3;
        }
        return f2 / 6.048E8f + (6.048E8f - f) / 6.048E8f * f3;
    }

    public void shutdown() {
        ServiceManager.sCfg.fractionalUptime = this.calculateFractionalUptime();
        ServiceManager.sCfg.lastShutdownTime = System.currentTimeMillis();
    }
}

