/*
 * Decompiled with CFR 0.152.
 */
package phex.share.export;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Map;
import phex.common.URN;
import phex.common.address.DestAddress;
import phex.connection.NetworkManager;
import phex.share.ShareFile;
import phex.share.ShareManager;
import phex.share.SharedFilesService;
import phex.utils.IOUtil;
import phex.utils.NLogger;
import phex.utils.URLCodecUtils;
import phex.utils.URLUtil;
import phex.xml.XMLUtils;

public class SharedFilesPipeFiller
implements Runnable {
    private Writer utf8Writer;
    private Map exportOptions;
    static final /* synthetic */ boolean $assertionsDisabled;

    public SharedFilesPipeFiller(OutputStream outputStream, Map map) {
        block2: {
            try {
                this.utf8Writer = new OutputStreamWriter(outputStream, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        this.exportOptions = map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            Object object;
            Object object2;
            DestAddress destAddress = NetworkManager.getInstance().getLocalAddress();
            this.utf8Writer.write("<shared-file-export>");
            if (this.exportOptions != null && this.exportOptions.size() > 0) {
                this.utf8Writer.write("<export-options>");
                object2 = this.exportOptions.keySet().iterator();
                while (object2.hasNext()) {
                    object = (String)object2.next();
                    this.utf8Writer.write("<option name='" + (String)object + "'>");
                    this.utf8Writer.write(this.exportOptions.get(object).toString());
                    this.utf8Writer.write("</option>");
                }
                this.utf8Writer.write("</export-options>");
            }
            this.utf8Writer.write("<shared-file-list>");
            object2 = ShareManager.getInstance().getSharedFilesService();
            object = ((SharedFilesService)object2).getSharedFiles();
            for (int i = 0; i < ((ShareFile[])object).length; ++i) {
                ShareFile shareFile = object[i];
                URN uRN = shareFile.getURN();
                if (uRN == null) continue;
                this.utf8Writer.write("<shared-file>");
                this.utf8Writer.write("<index>");
                XMLUtils.writeEncoded(this.utf8Writer, String.valueOf(shareFile.getFileIndex()));
                this.utf8Writer.write("</index>");
                this.utf8Writer.write("<name>");
                XMLUtils.writeEncoded(this.utf8Writer, shareFile.getFileName());
                this.utf8Writer.write("</name>");
                this.utf8Writer.write("<name-urlenc>");
                XMLUtils.writeEncoded(this.utf8Writer, URLCodecUtils.encodeURL(shareFile.getFileName()));
                this.utf8Writer.write("</name-urlenc>");
                this.utf8Writer.write("<search-compare-term>");
                XMLUtils.writeEncoded(this.utf8Writer, String.valueOf(shareFile.getSearchCompareTerm()));
                this.utf8Writer.write("</search-compare-term>>");
                this.utf8Writer.write("<search-count>");
                XMLUtils.writeEncoded(this.utf8Writer, String.valueOf(shareFile.getSearchCount()));
                this.utf8Writer.write("</search-count>");
                this.utf8Writer.write("<sha1>");
                XMLUtils.writeEncoded(this.utf8Writer, shareFile.getSHA1());
                this.utf8Writer.write("</sha1>");
                this.utf8Writer.write("<upload-count>");
                XMLUtils.writeEncoded(this.utf8Writer, String.valueOf(shareFile.getUploadCount()));
                this.utf8Writer.write("</upload-count>");
                this.utf8Writer.write("<file-size>");
                XMLUtils.writeEncoded(this.utf8Writer, String.valueOf(shareFile.getFileSize()));
                this.utf8Writer.write("</file-size>");
                this.utf8Writer.write("<urn>");
                XMLUtils.writeEncoded(this.utf8Writer, uRN.getAsString());
                this.utf8Writer.write("</urn>");
                this.utf8Writer.write("<magnet-url>");
                if (this.exportOptions != null && "true".equals(this.exportOptions.get("UseMagnetURLWithXS"))) {
                    XMLUtils.writeEncoded(this.utf8Writer, URLUtil.buildMagnetURLWithXS(shareFile.getSHA1(), shareFile.getFileName(), destAddress));
                } else {
                    XMLUtils.writeEncoded(this.utf8Writer, URLUtil.buildMagnetURL(shareFile.getSHA1(), shareFile.getFileName()));
                }
                this.utf8Writer.write("</magnet-url>");
                this.utf8Writer.write("<name2res-url>");
                XMLUtils.writeEncoded(this.utf8Writer, URLUtil.buildFullName2ResourceURL(destAddress, uRN));
                this.utf8Writer.write("</name2res-url>");
                this.utf8Writer.write("</shared-file>");
            }
            this.utf8Writer.write("</shared-file-list>");
            this.utf8Writer.write("</shared-file-export>");
        }
        catch (IOException iOException) {
            NLogger.error("Sharing", (Object)iOException, (Throwable)iOException);
        }
        finally {
            IOUtil.closeQuietly(this.utf8Writer);
        }
    }

    static {
        $assertionsDisabled = !SharedFilesPipeFiller.class.desiredAssertionStatus();
    }
}

