/*
 * Decompiled with CFR 0.152.
 */
package phex.security;

import javax.xml.bind.JAXBException;
import phex.common.ExpiryDate;
import phex.security.PhexSecurityManager;
import phex.xml.XJBIPAccessRule;
import phex.xml.XJBSecurityRule;

public abstract class SecurityRule {
    protected String description;
    protected boolean isSystemRule;
    protected boolean isStrongFilter;
    protected boolean isDenyingRule;
    protected boolean isDisabled;
    protected Integer triggerCount;
    protected ExpiryDate expiryDate;
    protected boolean isDeletedOnExpiry;

    public SecurityRule(String string, boolean bl) {
        this(string, bl, false, false, false);
    }

    public SecurityRule(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.description = string;
        this.isDenyingRule = bl;
        this.isSystemRule = bl2;
        this.isStrongFilter = bl3;
        this.isDisabled = bl4;
        this.expiryDate = ExpiryDate.NEVER_EXPIRY_DATE;
        this.isDeletedOnExpiry = false;
        this.triggerCount = new Integer(0);
    }

    public SecurityRule(XJBIPAccessRule xJBIPAccessRule) {
        this.description = xJBIPAccessRule.getDescription();
        this.isDenyingRule = xJBIPAccessRule.isDenyingRule();
        this.isDisabled = xJBIPAccessRule.isDisabled();
        long l = xJBIPAccessRule.getExpiryDate();
        this.expiryDate = ExpiryDate.getExpiryDate(l);
        this.isDeletedOnExpiry = xJBIPAccessRule.isDeletedOnExpiry();
        this.triggerCount = new Integer(xJBIPAccessRule.getTriggerCount());
        this.isSystemRule = false;
        this.isStrongFilter = false;
    }

    public void setDisabled(boolean bl) {
        if (this.isDisabled != bl) {
            this.isDisabled = bl;
            PhexSecurityManager.getInstance().fireSecurityRuleChanged(this);
        }
    }

    public boolean isDisabled() {
        return this.isDisabled;
    }

    public void setExpiryDate(ExpiryDate expiryDate) {
        if (!this.expiryDate.equals(expiryDate)) {
            this.expiryDate = expiryDate;
            PhexSecurityManager.getInstance().fireSecurityRuleChanged(this);
        }
    }

    public ExpiryDate getExpiryDate() {
        return this.expiryDate;
    }

    public Integer getTriggerCountObject() {
        return this.triggerCount;
    }

    protected void incrementTriggerCount() {
        this.triggerCount = new Integer(this.triggerCount + 1);
        PhexSecurityManager.getInstance().fireSecurityRuleChanged(this);
    }

    public void setTriggerCount(int n) {
        this.triggerCount = new Integer(n);
    }

    public boolean isDenyingRule() {
        return this.isDenyingRule;
    }

    public void setDenyingRule(boolean bl) {
        if (this.isDenyingRule != bl) {
            this.isDenyingRule = bl;
            PhexSecurityManager.getInstance().fireSecurityRuleChanged(this);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        if (!this.description.equals(string)) {
            this.description = string;
            PhexSecurityManager.getInstance().fireSecurityRuleChanged(this);
        }
    }

    public void setDeleteOnExpiry(boolean bl) {
        if (this.isDeletedOnExpiry != bl) {
            this.isDeletedOnExpiry = bl;
            PhexSecurityManager.getInstance().fireSecurityRuleChanged(this);
        }
    }

    public boolean isDeletedOnExpiry() {
        return this.isDeletedOnExpiry;
    }

    public void setSystemRule(boolean bl) {
        if (this.isSystemRule != bl) {
            this.isSystemRule = bl;
            PhexSecurityManager.getInstance().fireSecurityRuleChanged(this);
        }
    }

    public boolean isSystemRule() {
        return this.isSystemRule;
    }

    public void setStrongFilter(boolean bl) {
        if (this.isStrongFilter != bl) {
            this.isStrongFilter = bl;
            PhexSecurityManager.getInstance().fireSecurityRuleChanged(this);
        }
    }

    public boolean isStrongFilter() {
        return this.isStrongFilter;
    }

    public boolean equals(Object object) {
        if (!(object instanceof SecurityRule)) {
            return false;
        }
        SecurityRule securityRule = (SecurityRule)object;
        return this.description.equals(securityRule.description) && securityRule.isSystemRule == this.isSystemRule && securityRule.isStrongFilter == this.isStrongFilter && securityRule.expiryDate.equals(this.expiryDate) && securityRule.isDeletedOnExpiry == this.isDeletedOnExpiry && securityRule.isDenyingRule == this.isDenyingRule && securityRule.isDisabled == this.isDisabled;
    }

    public abstract XJBSecurityRule createXJBSecurityRule() throws JAXBException;
}

