/*
 * Decompiled with CFR 0.152.
 */
package phex.security;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import phex.common.AbstractManager;
import phex.common.Environment;
import phex.common.ExpiryDate;
import phex.common.address.AddressUtils;
import phex.common.address.DestAddress;
import phex.common.address.IpAddress;
import phex.common.file.FileManager;
import phex.common.file.ManagedFile;
import phex.common.file.ManagedFileException;
import phex.event.AsynchronousDispatcher;
import phex.event.SecurityRulesChangeListener;
import phex.security.FastIpList;
import phex.security.IPAccessRule;
import phex.security.SecurityRule;
import phex.utils.NLogger;
import phex.utils.StringUtils;
import phex.utils.VersionUtils;
import phex.xml.ObjectFactory;
import phex.xml.PhexElement;
import phex.xml.XJBIPAccessRule;
import phex.xml.XJBPhex;
import phex.xml.XJBSecurity;
import phex.xml.XJBSecurityRule;
import phex.xml.XMLBuilder;

public class PhexSecurityManager
extends AbstractManager {
    public static final byte ACCESS_GRANTED = 1;
    public static final byte ACCESS_DENIED = 2;
    public static final byte ACCESS_STRONGLY_DENIED = 3;
    private ArrayList ipAccessRuleList;
    private FastIpList fastIpList;
    private ArrayList listenerList = new ArrayList();

    public PhexSecurityManager() {
        this.ipAccessRuleList = new ArrayList();
        this.fastIpList = new FastIpList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIPAccessRuleCount() {
        ArrayList arrayList = this.ipAccessRuleList;
        synchronized (arrayList) {
            return this.ipAccessRuleList.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPAccessRule getIPAccessRule(int n) {
        ArrayList arrayList = this.ipAccessRuleList;
        synchronized (arrayList) {
            if (n < 0 || n >= this.ipAccessRuleList.size()) {
                return null;
            }
            return (IPAccessRule)this.ipAccessRuleList.get(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPAccessRule[] getIPAccessRulesAt(int[] nArray) {
        ArrayList arrayList = this.ipAccessRuleList;
        synchronized (arrayList) {
            int n = nArray.length;
            IPAccessRule[] iPAccessRuleArray = new IPAccessRule[n];
            int n2 = this.ipAccessRuleList.size();
            for (int i = 0; i < n; ++i) {
                iPAccessRuleArray[i] = nArray[i] < 0 || nArray[i] >= n2 ? null : (IPAccessRule)this.ipAccessRuleList.get(nArray[i]);
            }
            return iPAccessRuleArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPAccessRule createIPAccessRule(String string, boolean bl, byte by, byte[] byArray, byte[] byArray2, boolean bl2, ExpiryDate expiryDate, boolean bl3) {
        int n;
        IPAccessRule iPAccessRule = new IPAccessRule(string, bl, by, byArray, byArray2, false, false, bl2);
        iPAccessRule.setExpiryDate(expiryDate);
        iPAccessRule.setDeleteOnExpiry(bl3);
        ArrayList arrayList = this.ipAccessRuleList;
        synchronized (arrayList) {
            n = this.ipAccessRuleList.size();
            this.ipAccessRuleList.add(iPAccessRule);
            this.fastIpList.add(iPAccessRule);
        }
        this.fireSecurityRuleAdded(iPAccessRule, n);
        return iPAccessRule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSecurityRule(SecurityRule securityRule) {
        int n;
        ArrayList arrayList = this.ipAccessRuleList;
        synchronized (arrayList) {
            n = this.ipAccessRuleList.indexOf(securityRule);
            if (n != -1) {
                this.ipAccessRuleList.remove(n);
                this.fastIpList.remove((IPAccessRule)securityRule);
            }
        }
        this.fireSecurityRuleRemoved(n);
    }

    public byte controlHostAddressAccess(DestAddress destAddress) {
        IpAddress ipAddress = destAddress.getIpAddress();
        if (ipAddress == null) {
            return 1;
        }
        byte[] byArray = ipAddress.getHostIP();
        return this.controlHostIPAccess(byArray);
    }

    public byte controlHostIPAccess(byte[] byArray) {
        return this.fastIpList.controlHostIPAccess(byArray);
    }

    private void loadHostileHostList(Map map) {
        try {
            String string;
            BufferedReader bufferedReader;
            NLogger.debug("Security", (Object)"Load hostile hosts file.");
            long l = System.currentTimeMillis();
            InputStream inputStream = ClassLoader.getSystemResourceAsStream("phex/resources/hostilehosts.cfg");
            if (inputStream != null) {
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            } else {
                NLogger.debug("Security", (Object)"Hostile hosts file not found.");
                return;
            }
            while ((string = bufferedReader.readLine()) != null) {
                Object object;
                int n;
                byte[] byArray;
                byte[] byArray2;
                if (StringUtils.isEmpty(string) || string.startsWith("#")) continue;
                int n2 = string.indexOf(47);
                if (n2 == -1) {
                    byArray2 = AddressUtils.parseIP(string);
                    byArray = null;
                    n = 1;
                } else {
                    object = string.substring(0, n2).trim();
                    String string2 = string.substring(n2 + 1).trim();
                    byArray2 = AddressUtils.parseIP((String)object);
                    byArray = AddressUtils.parseIP(string2);
                    n = 2;
                }
                IPAccessRule iPAccessRule = new IPAccessRule("System rule.", true, (byte)n, byArray2, byArray, true, true, false);
                object = this.findSystemXJBRule(map, byArray2, byArray);
                if (object != null) {
                    iPAccessRule.setTriggerCount(object.getTriggerCount());
                }
                this.ipAccessRuleList.add(iPAccessRule);
                this.fastIpList.add(iPAccessRule);
            }
            bufferedReader.close();
            long l2 = System.currentTimeMillis();
            NLogger.debug("Security", (Object)("Loaded hostile hosts file: " + (l2 - l)));
        }
        catch (IOException iOException) {
            NLogger.warn("Security", (Object)iOException, (Throwable)iOException);
        }
    }

    private XJBSecurityRule findSystemXJBRule(Map map, byte[] byArray, byte[] byArray2) {
        XJBIPAccessRule xJBIPAccessRule;
        StringBuffer stringBuffer = new StringBuffer(AddressUtils.ip2string(byArray));
        if (byArray2 != null) {
            stringBuffer.append("-").append(AddressUtils.ip2string(byArray2));
        }
        if ((xJBIPAccessRule = (XJBIPAccessRule)map.get(stringBuffer.toString())) == null || !xJBIPAccessRule.isSystemRule()) {
            return null;
        }
        return xJBIPAccessRule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSecurityRuleList() {
        NLogger.debug("Security", (Object)"Loading security rule list...");
        File file = Environment.getInstance().getPhexConfigFile("security.xml");
        ObjectFactory objectFactory = new ObjectFactory();
        try {
            XJBPhex xJBPhex;
            Object object;
            Object object2;
            if (file.exists()) {
                object2 = FileManager.getInstance();
                object = ((FileManager)object2).getReadWriteManagedFile(file);
                xJBPhex = XMLBuilder.loadXJBPhexFromFile((ManagedFile)object);
            } else {
                xJBPhex = objectFactory.createXJBPhex();
            }
            object2 = xJBPhex.getSecurity();
            if (object2 == null) {
                NLogger.debug("Security", (Object)"No security definition found.");
                object2 = objectFactory.createXJBSecurity();
            }
            object = object2.getIpAccessRuleList();
            ArrayList arrayList = this.ipAccessRuleList;
            synchronized (arrayList) {
                Iterator iterator = object.iterator();
                HashMap<String, XJBIPAccessRule> hashMap = new HashMap<String, XJBIPAccessRule>();
                while (iterator.hasNext()) {
                    XJBIPAccessRule xJBIPAccessRule = (XJBIPAccessRule)iterator.next();
                    if (!xJBIPAccessRule.isSystemRule()) {
                        IPAccessRule iPAccessRule = new IPAccessRule(xJBIPAccessRule);
                        this.ipAccessRuleList.add(iPAccessRule);
                        this.fastIpList.add(iPAccessRule);
                        continue;
                    }
                    StringBuffer stringBuffer = new StringBuffer(AddressUtils.ip2string(xJBIPAccessRule.getIp()));
                    if (xJBIPAccessRule.getCompareIP() != null) {
                        stringBuffer.append("-").append(AddressUtils.ip2string(xJBIPAccessRule.getCompareIP()));
                    }
                    hashMap.put(stringBuffer.toString(), xJBIPAccessRule);
                }
                this.loadHostileHostList(hashMap);
                this.ipAccessRuleList.trimToSize();
            }
        }
        catch (JAXBException jAXBException) {
            Throwable throwable = jAXBException.getLinkedException();
            if (throwable != null) {
                NLogger.error("Security", (Object)throwable, throwable);
            }
            NLogger.error("Security", (Object)jAXBException, (Throwable)jAXBException);
            Environment.getInstance().fireDisplayUserMessage("SecuritySettingsLoadFailed", new String[]{jAXBException.toString()});
            return;
        }
        catch (ManagedFileException managedFileException) {
            NLogger.error("Security", (Object)managedFileException, (Throwable)managedFileException);
            Environment.getInstance().fireDisplayUserMessage("SecuritySettingsLoadFailed", new String[]{managedFileException.toString()});
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveSecurityRuleList() {
        NLogger.debug("Security", (Object)"Saving security rule list...");
        try {
            Object object;
            ObjectFactory objectFactory = new ObjectFactory();
            PhexElement phexElement = objectFactory.createPhexElement();
            XJBSecurity xJBSecurity = objectFactory.createXJBSecurity();
            phexElement.setSecurity(xJBSecurity);
            phexElement.setPhexVersion(VersionUtils.getFullProgramVersion());
            List list = xJBSecurity.getIpAccessRuleList();
            Serializable serializable = this.ipAccessRuleList;
            synchronized (serializable) {
                object = this.ipAccessRuleList.iterator();
                while (object.hasNext()) {
                    IPAccessRule iPAccessRule = (IPAccessRule)object.next();
                    if (!iPAccessRule.isSystemRule() && iPAccessRule.isDeletedOnExpiry() && (iPAccessRule.getExpiryDate().isExpiringEndOfSession() || iPAccessRule.getExpiryDate().isExpired()) || iPAccessRule.isSystemRule() && iPAccessRule.getTriggerCountObject() == 0) continue;
                    XJBSecurityRule xJBSecurityRule = iPAccessRule.createXJBSecurityRule();
                    list.add(xJBSecurityRule);
                }
            }
            serializable = Environment.getInstance().getPhexConfigFile("security.xml");
            object = FileManager.getInstance().getReadWriteManagedFile((File)serializable);
            XMLBuilder.saveToFile((ManagedFile)object, phexElement);
        }
        catch (JAXBException jAXBException) {
            NLogger.error("Security", (Object)jAXBException, (Throwable)jAXBException);
            Environment.getInstance().fireDisplayUserMessage("SecuritySettingsSaveFailed", new String[]{jAXBException.toString()});
        }
        catch (ManagedFileException managedFileException) {
            NLogger.error("Security", (Object)managedFileException, (Throwable)managedFileException);
            Environment.getInstance().fireDisplayUserMessage("SecuritySettingsSaveFailed", new String[]{managedFileException.toString()});
        }
    }

    public static PhexSecurityManager getInstance() {
        return Holder.manager;
    }

    public boolean initialize() {
        return true;
    }

    public boolean onPostInitialization() {
        this.loadSecurityRuleList();
        return true;
    }

    public void startupCompletedNotify() {
    }

    public void shutdown() {
        this.saveSecurityRuleList();
    }

    public void addSecurityRuleChangeListener(SecurityRulesChangeListener securityRulesChangeListener) {
        this.listenerList.add(securityRulesChangeListener);
    }

    public void removeSecurityRuleChangeListener(SecurityRulesChangeListener securityRulesChangeListener) {
        this.listenerList.remove(securityRulesChangeListener);
    }

    private void fireSecurityRuleChanged(final int n) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = PhexSecurityManager.this.listenerList.toArray();
                for (int i = objectArray.length - 1; i >= 0; --i) {
                    SecurityRulesChangeListener securityRulesChangeListener = (SecurityRulesChangeListener)objectArray[i];
                    securityRulesChangeListener.securityRuleChanged(n);
                }
            }
        });
    }

    private void fireSecurityRuleAdded(final SecurityRule securityRule, final int n) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = PhexSecurityManager.this.listenerList.toArray();
                for (int i = objectArray.length - 1; i >= 0; --i) {
                    SecurityRulesChangeListener securityRulesChangeListener = (SecurityRulesChangeListener)objectArray[i];
                    securityRulesChangeListener.securityRuleAdded(securityRule, n);
                }
            }
        });
    }

    private void fireSecurityRuleRemoved(final int n) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = PhexSecurityManager.this.listenerList.toArray();
                for (int i = objectArray.length - 1; i >= 0; --i) {
                    SecurityRulesChangeListener securityRulesChangeListener = (SecurityRulesChangeListener)objectArray[i];
                    securityRulesChangeListener.securityRuleRemoved(n);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireSecurityRuleChanged(SecurityRule securityRule) {
        ArrayList arrayList = this.ipAccessRuleList;
        synchronized (arrayList) {
            int n = this.ipAccessRuleList.indexOf(securityRule);
            if (n >= 0) {
                this.fireSecurityRuleChanged(n);
            }
        }
    }

    private static class Holder {
        protected static final PhexSecurityManager manager = new PhexSecurityManager();

        private Holder() {
        }
    }
}

