/*
 * Decompiled with CFR 0.152.
 */
package phex.rules.condition;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.collections.set.ListOrderedSet;
import phex.common.MediaType;
import phex.download.RemoteFile;
import phex.query.Search;
import phex.rules.condition.Condition;
import phex.xml.sax.rules.DCondition;
import phex.xml.sax.rules.DMediaTypeCondition;

public class MediaTypeCondition
implements Condition {
    private ListOrderedSet types = new ListOrderedSet();

    public MediaTypeCondition() {
    }

    public MediaTypeCondition(MediaType mediaType) {
        this();
        this.addType(mediaType);
    }

    public MediaTypeCondition(MediaTypeCondition mediaTypeCondition) {
        this();
        this.update(mediaTypeCondition);
    }

    public synchronized void update(MediaTypeCondition mediaTypeCondition) {
        this.types.clear();
        this.types.addAll((Collection)mediaTypeCondition.types);
    }

    public synchronized Set getTypes() {
        return Collections.unmodifiableSet(this.types);
    }

    public synchronized MediaTypeCondition addType(MediaType mediaType) {
        this.types.add(mediaType);
        return this;
    }

    public synchronized void removeType(MediaType mediaType) {
        this.types.remove(mediaType);
    }

    public synchronized boolean isMatched(Search search, RemoteFile remoteFile) {
        Iterator iterator = this.types.iterator();
        while (iterator.hasNext()) {
            MediaType mediaType = (MediaType)iterator.next();
            if (!mediaType.isFilenameOf(remoteFile.getFilename())) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean isComplete() {
        return this.types.size() > 0;
    }

    public synchronized Object clone() {
        try {
            MediaTypeCondition mediaTypeCondition = (MediaTypeCondition)super.clone();
            mediaTypeCondition.types = new ListOrderedSet();
            mediaTypeCondition.types.addAll((Collection)this.types);
            return mediaTypeCondition;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public synchronized DCondition createDCondition() {
        DMediaTypeCondition dMediaTypeCondition = new DMediaTypeCondition();
        ArrayList arrayList = new ArrayList(this.types);
        dMediaTypeCondition.setTypes(arrayList);
        return dMediaTypeCondition;
    }
}

