/*
 * Decompiled with CFR 0.152.
 */
package phex.rules;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TimerTask;
import phex.common.Environment;
import phex.common.ThreadPool;
import phex.common.file.FileManager;
import phex.common.file.ManagedFile;
import phex.common.file.ManagedFileException;
import phex.connection.NetworkManager;
import phex.rules.DefaultSearchFilterRules;
import phex.rules.Rule;
import phex.rules.condition.AndConcatCondition;
import phex.rules.condition.Condition;
import phex.rules.consequence.Consequence;
import phex.utils.NLogger;
import phex.utils.VersionUtils;
import phex.xml.sax.DElement;
import phex.xml.sax.DPhex;
import phex.xml.sax.DSubElementList;
import phex.xml.sax.XMLBuilder;
import phex.xml.sax.rules.DAndConcatCondition;
import phex.xml.sax.rules.DConsequence;
import phex.xml.sax.rules.DConsequencesList;
import phex.xml.sax.rules.DSearchRule;

public class SearchFilterRules {
    private boolean hasChangedSinceLastSave;
    private List searchFilterRules = new ArrayList();

    public SearchFilterRules() {
        this.searchFilterRules.add(DefaultSearchFilterRules.ADULT_FILTER_RULE);
        this.searchFilterRules.add(DefaultSearchFilterRules.SCAM_FILE_FILTER_RULE);
        this.hasChangedSinceLastSave = false;
        Environment.getInstance().scheduleTimerTask(new SaveFavoritesTimer(), 60000L, 60000L);
    }

    public synchronized void setRuleList(List list) {
        this.searchFilterRules = list;
        this.hasChangedSinceLastSave = true;
    }

    public synchronized List getAsList() {
        return Collections.unmodifiableList(this.searchFilterRules);
    }

    public synchronized List getPermanentList() {
        ArrayList<Rule> arrayList = new ArrayList<Rule>();
        Iterator iterator = this.searchFilterRules.iterator();
        while (iterator.hasNext()) {
            Rule rule = (Rule)iterator.next();
            if (!rule.isPermanentlyEnabled()) continue;
            arrayList.add(rule);
        }
        return arrayList;
    }

    public synchronized int getCount() {
        return this.searchFilterRules.size();
    }

    public synchronized Rule getRuleAt(int n) {
        if (n < 0 || n >= this.searchFilterRules.size()) {
            return null;
        }
        return (Rule)this.searchFilterRules.get(n);
    }

    public synchronized Rule getRuleById(String string) {
        Iterator iterator = this.searchFilterRules.iterator();
        while (iterator.hasNext()) {
            Rule rule = (Rule)iterator.next();
            if (!string.equals(rule.getId())) continue;
            return rule;
        }
        return null;
    }

    public synchronized void save() {
        if (!this.hasChangedSinceLastSave) {
            return;
        }
        NLogger.debug(SearchFilterRules.class, (Object)"Saving search filters.");
        try {
            Object object;
            Object object2;
            Object object3;
            DPhex dPhex = new DPhex();
            dPhex.setPhexVersion(VersionUtils.getFullProgramVersion());
            DSubElementList dSubElementList = new DSubElementList("search-rule-list");
            dPhex.setSearchRuleList(dSubElementList);
            List list = dSubElementList.getSubElementList();
            Iterator iterator = this.searchFilterRules.iterator();
            while (iterator.hasNext()) {
                Object object4;
                Object object5;
                object3 = (Rule)iterator.next();
                object2 = new DSearchRule();
                ((DSearchRule)object2).setId(((Rule)object3).getId());
                ((DSearchRule)object2).setName(((Rule)object3).getName());
                ((DSearchRule)object2).setDescription(((Rule)object3).getDescription());
                ((DSearchRule)object2).setPermanentlyEnabled(((Rule)object3).isPermanentlyEnabled());
                object = new DAndConcatCondition();
                List list2 = ((DSubElementList)object).getSubElementList();
                Iterator iterator2 = ((Rule)object3).getConditions().iterator();
                while (iterator2.hasNext()) {
                    object5 = (Condition)iterator2.next();
                    object4 = object5.createDCondition();
                    list2.add(object4);
                }
                ((DSearchRule)object2).setAndConcatCondition((DAndConcatCondition)object);
                object5 = new DConsequencesList();
                object4 = ((DSubElementList)object5).getSubElementList();
                Iterator iterator3 = ((Rule)object3).getConsequences().iterator();
                while (iterator3.hasNext()) {
                    Consequence consequence = (Consequence)iterator3.next();
                    DElement dElement = consequence.createDConsequence();
                    object4.add(dElement);
                }
                ((DSearchRule)object2).setConsequencesList((DConsequencesList)object5);
                list.add(object2);
            }
            object3 = NetworkManager.getInstance();
            object2 = ((NetworkManager)object3).getGnutellaNetwork().getSearchFilterFile();
            object = FileManager.getInstance().getReadWriteManagedFile((File)object2);
            XMLBuilder.saveToFile((ManagedFile)object, dPhex);
            this.hasChangedSinceLastSave = false;
        }
        catch (IOException iOException) {
            NLogger.error("Favorites", (Object)iOException, (Throwable)iOException);
            Environment.getInstance().fireDisplayUserMessage("FavoritesSettingsSaveFailed", new String[]{iOException.toString()});
        }
        catch (ManagedFileException managedFileException) {
            NLogger.error("Favorites", (Object)managedFileException, (Throwable)managedFileException);
            Environment.getInstance().fireDisplayUserMessage("FavoritesSettingsSaveFailed", new String[]{managedFileException.toString()});
        }
    }

    public synchronized void load() {
        NLogger.debug(SearchFilterRules.class, (Object)"Loading search filters.");
        NetworkManager networkManager = NetworkManager.getInstance();
        File file = networkManager.getGnutellaNetwork().getSearchFilterFile();
        try {
            if (!file.exists()) {
                return;
            }
            FileManager fileManager = FileManager.getInstance();
            ManagedFile managedFile = fileManager.getReadWriteManagedFile(file);
            DPhex dPhex = XMLBuilder.loadDPhexFromFile(managedFile);
            if (dPhex == null) {
                NLogger.debug("Favorites", (Object)"No DPhex found.");
                return;
            }
            DSubElementList dSubElementList = dPhex.getSearchRuleList();
            if (dSubElementList == null) {
                NLogger.warn("Favorites", (Object)"No DSearchRule list found.");
            }
            ArrayList<Rule> arrayList = new ArrayList<Rule>();
            Iterator iterator = dSubElementList.getSubElementList().iterator();
            while (iterator.hasNext()) {
                DSearchRule dSearchRule = (DSearchRule)iterator.next();
                Rule rule = null;
                boolean bl = false;
                String string = dSearchRule.getId();
                if (string != null) {
                    rule = this.getRuleById(string);
                }
                if (rule == null) {
                    bl = true;
                    rule = new Rule();
                }
                if (!rule.isDefaultRule()) {
                    String string2 = dSearchRule.getName();
                    rule.setName(string2);
                    DAndConcatCondition dAndConcatCondition = dSearchRule.getAndConcatCondition();
                    AndConcatCondition andConcatCondition = (AndConcatCondition)dAndConcatCondition.createCondition();
                    Iterator iterator2 = andConcatCondition.getConditions().iterator();
                    while (iterator2.hasNext()) {
                        rule.addCondition((Condition)iterator2.next());
                    }
                    DConsequencesList dConsequencesList = dSearchRule.getConsequencesList();
                    Iterator iterator3 = dConsequencesList.getSubElementList().iterator();
                    while (iterator3.hasNext()) {
                        DConsequence dConsequence = (DConsequence)iterator3.next();
                        Consequence consequence = dConsequence.createConsequence();
                        rule.addConsequence(consequence);
                    }
                }
                if (dSearchRule.isHasPermanentlyEnabled()) {
                    rule.setPermanentlyEnabled(dSearchRule.isPermanentlyEnabled());
                }
                if (!bl) continue;
                arrayList.add(rule);
            }
            this.searchFilterRules.addAll(arrayList);
        }
        catch (IOException iOException) {
            NLogger.error("Favorites", (Object)iOException, (Throwable)iOException);
            Environment.getInstance().fireDisplayUserMessage("FavoritesSettingsLoadFailed", new String[]{iOException.toString()});
            return;
        }
        catch (ManagedFileException managedFileException) {
            NLogger.error("Favorites", (Object)managedFileException, (Throwable)managedFileException);
            Environment.getInstance().fireDisplayUserMessage("FavoritesSettingsLoadFailed", new String[]{managedFileException.toString()});
            return;
        }
    }

    private class SaveFavoritesTimer
    extends TimerTask {
        public static final long TIMER_PERIOD = 60000L;

        private SaveFavoritesTimer() {
        }

        public void run() {
            try {
                ThreadPool.getInstance().addJob(new SaveRunner(), "SaveSearchFilterRules");
            }
            catch (Throwable throwable) {
                NLogger.error("Favorites", (Object)throwable, throwable);
            }
        }
    }

    private class SaveRunner
    implements Runnable {
        private SaveRunner() {
        }

        public void run() {
            SearchFilterRules.this.save();
        }
    }
}

