/*
 * Decompiled with CFR 0.152.
 */
package phex.query;

import java.util.ArrayList;
import java.util.Iterator;
import phex.common.ServiceManager;
import phex.common.address.DestAddress;
import phex.event.AsynchronousDispatcher;
import phex.event.SearchDataEvent;
import phex.event.SearchDataListener;
import phex.event.SearchListChangeListener;
import phex.msg.GUID;
import phex.msg.QueryResponseMsg;
import phex.query.BrowseHostResults;
import phex.query.KeywordSearch;
import phex.query.Search;
import phex.query.WhatsNewSearch;

public class SearchContainer {
    private ArrayList listenerList = new ArrayList(2);
    protected ArrayList searchList;
    private SearchDataListener searchChangeListener = new SingleSearchChangeListener();

    public SearchContainer() {
        this.searchList = new ArrayList();
    }

    public synchronized Search createSearch(String string) {
        KeywordSearch keywordSearch = new KeywordSearch(string);
        this.insertToSearchList(keywordSearch, 0);
        if (this.searchList.size() > ServiceManager.sCfg.mSearchMaxConcurrent) {
            int n = this.searchList.size() - 1;
            this.removeFromSearchList(n);
        }
        keywordSearch.startSearching();
        return keywordSearch;
    }

    public synchronized Search createWhatsNewSearch() {
        WhatsNewSearch whatsNewSearch = new WhatsNewSearch();
        this.insertToSearchList(whatsNewSearch, 0);
        if (this.searchList.size() > ServiceManager.sCfg.mSearchMaxConcurrent) {
            int n = this.searchList.size() - 1;
            this.removeFromSearchList(n);
        }
        whatsNewSearch.startSearching();
        return whatsNewSearch;
    }

    public synchronized BrowseHostResults createBrowseHostSearch(DestAddress destAddress, GUID gUID) {
        BrowseHostResults browseHostResults = new BrowseHostResults(destAddress, gUID);
        this.insertToSearchList(browseHostResults, 0);
        if (this.searchList.size() > ServiceManager.sCfg.mSearchMaxConcurrent) {
            int n = this.searchList.size() - 1;
            this.removeFromSearchList(n);
        }
        browseHostResults.startSearching();
        return browseHostResults;
    }

    protected synchronized void insertToSearchList(Search search, int n) {
        search.addSearchChangeListener(this.searchChangeListener);
        this.searchList.add(n, search);
        this.fireSearchAdded(search, n);
    }

    protected synchronized void removeFromSearchList(int n) {
        Search search = this.getSearchAt(n);
        search.stopSearching();
        search.removeSearchChangeListener(this.searchChangeListener);
        this.searchList.remove(n);
        this.fireSearchRemoved(search, n);
    }

    public synchronized Search getRunningKeywordSearch(String string) {
        Iterator iterator = this.searchList.iterator();
        while (iterator.hasNext()) {
            Search search = (Search)iterator.next();
            if (!search.isSearching() || !(search instanceof KeywordSearch) || !((KeywordSearch)search).getSearchString().equals(string)) continue;
            return search;
        }
        return null;
    }

    public synchronized Search getRunningBrowseHost(DestAddress destAddress, GUID gUID) {
        Iterator iterator = this.searchList.iterator();
        while (iterator.hasNext()) {
            BrowseHostResults browseHostResults;
            Search search = (Search)iterator.next();
            if (!search.isSearching() || !(search instanceof BrowseHostResults) || !(browseHostResults = (BrowseHostResults)search).getDestAddress().equals(destAddress) && !browseHostResults.getHostGUID().equals(gUID)) continue;
            return search;
        }
        return null;
    }

    public synchronized int getSearchCount() {
        return this.searchList.size();
    }

    public synchronized int getIndexOfSearch(Search search) {
        int n = this.searchList.size();
        for (int i = 0; i < n; ++i) {
            if (search != this.searchList.get(i)) continue;
            return i;
        }
        return -1;
    }

    public synchronized Search getSearchAt(int n) {
        if (n < 0 || n >= this.getSearchCount()) {
            return null;
        }
        return (Search)this.searchList.get(n);
    }

    public synchronized void removeSearch(Search search) {
        int n = this.searchList.indexOf(search);
        if (n >= 0) {
            this.removeFromSearchList(n);
        }
    }

    public synchronized void removeSearch(int n) {
        this.removeFromSearchList(n);
    }

    public synchronized void stopExpiredSearches(long l) {
        for (int i = 0; i < this.searchList.size(); ++i) {
            ((Search)this.searchList.get(i)).checkForSearchTimeout(l);
        }
    }

    public synchronized void stopAllSearches() {
        for (int i = 0; i < this.searchList.size(); ++i) {
            ((Search)this.searchList.get(i)).stopSearching();
        }
    }

    public synchronized void removeAllSearches() {
        for (int i = this.searchList.size() - 1; i >= 0; --i) {
            this.removeFromSearchList(i);
        }
    }

    public synchronized void processQueryResponse(QueryResponseMsg queryResponseMsg) {
        for (int i = 0; i < this.searchList.size(); ++i) {
            Search search = (Search)this.searchList.get(i);
            if (search instanceof BrowseHostResults) continue;
            search.processResponse(queryResponseMsg);
        }
    }

    public void addSearchListChangeListener(SearchListChangeListener searchListChangeListener) {
        this.listenerList.add(searchListChangeListener);
    }

    public void removeSearchListChangeListener(SearchListChangeListener searchListChangeListener) {
        this.listenerList.remove(searchListChangeListener);
    }

    protected void fireSearchChanged(final int n) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = SearchContainer.this.listenerList.toArray();
                for (int i = objectArray.length - 1; i >= 0; --i) {
                    SearchListChangeListener searchListChangeListener = (SearchListChangeListener)objectArray[i];
                    searchListChangeListener.searchChanged(n);
                }
            }
        });
    }

    protected void fireSearchAdded(final Search search, final int n) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = SearchContainer.this.listenerList.toArray();
                for (int i = objectArray.length - 1; i >= 0; --i) {
                    SearchListChangeListener searchListChangeListener = (SearchListChangeListener)objectArray[i];
                    searchListChangeListener.searchAdded(search, n);
                }
            }
        });
    }

    protected void fireSearchRemoved(final Search search, final int n) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = SearchContainer.this.listenerList.toArray();
                for (int i = objectArray.length - 1; i >= 0; --i) {
                    SearchListChangeListener searchListChangeListener = (SearchListChangeListener)objectArray[i];
                    searchListChangeListener.searchRemoved(search, n);
                }
            }
        });
    }

    protected void setSearchChangeListener(SearchDataListener searchDataListener) {
        this.searchChangeListener = searchDataListener;
    }

    protected void fireSearchChanged(Search search) {
        int n = this.searchList.indexOf(search);
        if (n >= 0) {
            this.fireSearchChanged(n);
        }
    }

    private class SingleSearchChangeListener
    implements SearchDataListener {
        private SingleSearchChangeListener() {
        }

        public void searchDataChanged(SearchDataEvent searchDataEvent) {
            Search search = (Search)searchDataEvent.getSource();
            SearchContainer.this.fireSearchChanged(search);
        }
    }
}

