/*
 * Decompiled with CFR 0.152.
 */
package phex.query;

import java.util.ArrayList;
import phex.common.IntObj;
import phex.download.RemoteFile;
import phex.event.AsynchronousDispatcher;
import phex.event.SearchDataEvent;
import phex.event.SearchDataListener;
import phex.query.Search;
import phex.query.SearchResultHolder;
import phex.rules.Rule;

public class RuleFilteredSearch
implements SearchDataListener {
    private Search search;
    private SearchResultHolder displayedSearchResults;
    private SearchResultHolder hiddenSearchResults;
    private Rule[] searchFilterRules;
    private ArrayList listenerList = new ArrayList(2);

    public RuleFilteredSearch(Search search, Rule rule) {
        this(search, new Rule[]{rule});
    }

    public RuleFilteredSearch(Search search, Rule[] ruleArray) {
        this.displayedSearchResults = new SearchResultHolder();
        this.hiddenSearchResults = new SearchResultHolder();
        this.search = search;
        this.searchFilterRules = ruleArray;
        search.addSearchChangeListener(this);
    }

    public int getResultCount() {
        return this.displayedSearchResults.getQueryHitCount();
    }

    public int getHiddenCount() {
        return this.hiddenSearchResults.getQueryHitCount();
    }

    public int getProgress() {
        return this.search.getProgress();
    }

    public IntObj getProgressObj() {
        return this.search.getProgressObj();
    }

    public boolean isSearching() {
        return this.search.isSearching();
    }

    public void checkForSearchTimeout(long l) {
        this.search.checkForSearchTimeout(l);
    }

    public void startSearching() {
        this.search.startSearching();
    }

    public void stopSearching() {
        this.search.stopSearching();
    }

    private void processRules(RemoteFile[] remoteFileArray) {
        for (int i = 0; i < this.searchFilterRules.length; ++i) {
            this.searchFilterRules[i].process(this.search, remoteFileArray);
        }
        ArrayList<RemoteFile> arrayList = new ArrayList<RemoteFile>(remoteFileArray.length);
        for (int i = 0; i < remoteFileArray.length; ++i) {
            if (remoteFileArray[i].isFilteredRemoved()) continue;
            if (remoteFileArray[i].isFilteredHidden()) {
                this.hiddenSearchResults.addQueryHit(remoteFileArray[i]);
                continue;
            }
            this.displayedSearchResults.addQueryHit(remoteFileArray[i]);
            arrayList.add(remoteFileArray[i]);
        }
        if (arrayList.size() > 0) {
            RemoteFile[] remoteFileArray2 = new RemoteFile[arrayList.size()];
            arrayList.toArray(remoteFileArray2);
            this.fireSearchHitsAdded(remoteFileArray2);
        }
    }

    public void searchDataChanged(SearchDataEvent searchDataEvent) {
        short s = searchDataEvent.getType();
        switch (s) {
            case 1: {
                this.processRules(searchDataEvent.getSearchData());
                break;
            }
            default: {
                this.fireSearchChangeEvent(searchDataEvent);
            }
        }
    }

    public void addSearchDataListener(SearchDataListener searchDataListener) {
        this.listenerList.add(searchDataListener);
    }

    public void removeSearchDataListener(SearchDataListener searchDataListener) {
        this.listenerList.remove(searchDataListener);
    }

    protected void fireSearchStarted() {
        SearchDataEvent searchDataEvent = new SearchDataEvent(this, 0);
        this.fireSearchChangeEvent(searchDataEvent);
    }

    protected void fireSearchStoped() {
        SearchDataEvent searchDataEvent = new SearchDataEvent(this, 4);
        this.fireSearchChangeEvent(searchDataEvent);
    }

    protected void fireSearchFiltered() {
        SearchDataEvent searchDataEvent = new SearchDataEvent(this, 2);
        this.fireSearchChangeEvent(searchDataEvent);
    }

    public void fireSearchChanged() {
        SearchDataEvent searchDataEvent = new SearchDataEvent(this, 3);
        this.fireSearchChangeEvent(searchDataEvent);
    }

    protected void fireSearchHitsAdded(RemoteFile[] remoteFileArray) {
        SearchDataEvent searchDataEvent = new SearchDataEvent(this, 1, remoteFileArray);
        this.fireSearchChangeEvent(searchDataEvent);
    }

    private void fireSearchChangeEvent(final SearchDataEvent searchDataEvent) {
        AsynchronousDispatcher.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = RuleFilteredSearch.this.listenerList.toArray();
                for (int i = objectArray.length - 1; i >= 0; --i) {
                    if (!(objectArray[i] instanceof SearchDataListener)) continue;
                    SearchDataListener searchDataListener = (SearchDataListener)objectArray[i];
                    searchDataListener.searchDataChanged(searchDataEvent);
                }
            }
        });
    }
}

