/*
 * Decompiled with CFR 0.152.
 */
package phex.query;

import java.util.ArrayList;
import java.util.StringTokenizer;
import phex.common.ServiceManager;
import phex.common.URN;
import phex.common.address.DestAddress;
import phex.connection.NetworkManager;
import phex.download.RemoteFile;
import phex.msg.GUID;
import phex.msg.QueryMsg;
import phex.msg.QueryResponseMsg;
import phex.msg.QueryResponseRecord;
import phex.query.QueryHitHost;
import phex.query.Search;
import phex.utils.SearchEngine;

public class KeywordSearch
extends Search {
    private String searchString;
    private URN searchURN;

    public KeywordSearch(String string) {
        this(string, null);
    }

    public KeywordSearch(String string, URN uRN) {
        this.searchString = string;
        this.searchURN = uRN;
        boolean bl = !NetworkManager.getInstance().hasConnectedIncoming();
        this.queryMsg = new QueryMsg((byte)ServiceManager.sCfg.ttl, this.searchString, this.searchURN, false, bl);
    }

    public String getSearchString() {
        return this.searchString;
    }

    public void setSearchString(String string) {
        this.searchString = string;
        this.searchURN = null;
        boolean bl = !NetworkManager.getInstance().hasConnectedIncoming();
        this.queryMsg = new QueryMsg((byte)ServiceManager.sCfg.ttl, this.searchString, this.searchURN, false, bl);
        this.fireSearchChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processResponse(QueryResponseMsg queryResponseMsg) {
        if (!queryResponseMsg.getHeader().getMsgID().equals(this.queryMsg.getHeader().getMsgID())) {
            return;
        }
        long l = queryResponseMsg.getRemoteHostSpeed();
        GUID gUID = queryResponseMsg.getRemoteClientID();
        DestAddress destAddress = queryResponseMsg.getDestAddress();
        QueryHitHost queryHitHost = new QueryHitHost(gUID, destAddress, l);
        queryHitHost.setQHDFlags(queryResponseMsg.getPushNeededFlag(), queryResponseMsg.getServerBusyFlag(), queryResponseMsg.getHasUploadedFlag(), queryResponseMsg.getUploadSpeedFlag());
        queryHitHost.setQueryResponseFields(queryResponseMsg);
        int n = queryResponseMsg.getRecordCount();
        ArrayList<RemoteFile> arrayList = new ArrayList<RemoteFile>(n);
        for (int i = 0; i < n; ++i) {
            QueryResponseRecord queryResponseRecord = queryResponseMsg.getMsgRecord(i);
            if (this.searchURN != null && queryResponseRecord.getURN() != null && !this.searchURN.equals(queryResponseRecord.getURN())) continue;
            KeywordSearch keywordSearch = this;
            synchronized (keywordSearch) {
                RemoteFile remoteFile;
                DestAddress[] destAddressArray;
                long l2 = queryResponseRecord.getFileSize();
                String string = queryResponseRecord.getFilename();
                URN uRN = queryResponseRecord.getURN();
                int n2 = queryResponseRecord.getFileIndex();
                String string2 = queryResponseRecord.getMetaData();
                short s = this.searchString == null ? (short)100 : (short)KeywordSearch.calculateSearchScore(this.searchString, string);
                RemoteFile remoteFile2 = this.searchResultHolder.findQueryHit(queryHitHost, uRN, string, l2, n2);
                if (remoteFile2 != null) {
                    remoteFile2.updateQueryHitHost(queryHitHost);
                    remoteFile2.setMetaData(string2);
                } else {
                    destAddressArray = queryResponseRecord.getPathInfo();
                    remoteFile = new RemoteFile(queryHitHost, n2, string, (String)destAddressArray, l2, uRN, string2, s);
                    this.searchResultHolder.addQueryHit(remoteFile);
                    arrayList.add(remoteFile);
                }
                destAddressArray = queryResponseRecord.getAlternateLocations();
                if (uRN != null && destAddressArray != null) {
                    for (int j = 0; j < destAddressArray.length; ++j) {
                        QueryHitHost queryHitHost2 = new QueryHitHost(null, destAddressArray[j], -1L);
                        remoteFile2 = this.searchResultHolder.findQueryHit(queryHitHost, uRN, string, l2, n2);
                        if (remoteFile2 != null) {
                            remoteFile2.updateQueryHitHost(queryHitHost);
                            remoteFile2.setMetaData(string2);
                            continue;
                        }
                        remoteFile = new RemoteFile(queryHitHost2, -1, string, "", l2, uRN, string2, s);
                        this.searchResultHolder.addQueryHit(remoteFile);
                        arrayList.add(remoteFile);
                    }
                }
                continue;
            }
        }
        if (arrayList.size() > 0) {
            if (this.queryEngine != null) {
                this.queryEngine.incrementResultCount(arrayList.size());
            }
            RemoteFile[] remoteFileArray = new RemoteFile[arrayList.size()];
            arrayList.toArray(remoteFileArray);
            this.fireSearchHitsAdded(remoteFileArray);
        }
    }

    public static short calculateSearchScore(String string, String string2) {
        double d = 0.0;
        double d2 = 0.0;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        SearchEngine searchEngine = new SearchEngine();
        searchEngine.setText(string2, false);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            d += 1.0;
            searchEngine.setPattern(string3, false);
            if (!searchEngine.match()) continue;
            d2 += 1.0;
        }
        double d3 = d2 / d * 100.0;
        return (short)d3;
    }

    public String toString() {
        return "[KeywordSearch:" + this.searchString + "," + super.toString() + "]";
    }
}

