/*
 * Decompiled with CFR 0.152.
 */
package phex.query;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import phex.common.QueryRoutingTable;
import phex.host.Host;
import phex.host.HostManager;
import phex.host.NetworkHostsContainer;
import phex.msg.Message;
import phex.msg.MsgManager;
import phex.msg.QueryMsg;
import phex.query.DynamicQueryConstants;

public class DynamicQueryEngine
implements DynamicQueryConstants {
    private MsgManager messageMgr = MsgManager.getInstance();
    private HostManager hostMgr = HostManager.getInstance();
    private NetworkHostsContainer hostsContainer = this.hostMgr.getNetworkHostsContainer();
    private boolean isDynamicQueryStarted;
    private boolean isDynamicQueryStopped;
    private boolean areLeavesQueried;
    private boolean isProbeQuerySent;
    private long queryTimeout;
    private long queryStartTime;
    private long nextProcessTime;
    private int timeToWaitPerHop;
    private int desiredResults;
    private int receivedResults;
    private int estimatedQueriedHorizon;
    private List queriedHosts;
    private QueryMsg query;

    public DynamicQueryEngine(QueryMsg queryMsg, int n) {
        this.query = queryMsg;
        this.desiredResults = n;
        this.isDynamicQueryStarted = false;
        this.isDynamicQueryStopped = false;
        this.areLeavesQueried = false;
        this.isProbeQuerySent = false;
        this.queryTimeout = 300000L;
        this.timeToWaitPerHop = 2400;
        this.estimatedQueriedHorizon = 1;
        this.receivedResults = 0;
        this.queriedHosts = new ArrayList();
        if (queryMsg.hasQueryURNs()) {
            n = 20;
        }
    }

    public void incrementResultCount(int n) {
        this.receivedResults += n;
    }

    public int getResultCount() {
        return this.receivedResults;
    }

    public void stopQuery() {
        this.isDynamicQueryStopped = true;
    }

    public boolean areEnoughResultsRouted() {
        return this.receivedResults >= this.desiredResults;
    }

    public Host getFromHost() {
        return this.query.getHeader().getFromHost();
    }

    public boolean isQueryFinished() {
        if (!this.isDynamicQueryStarted) {
            return false;
        }
        if (this.isDynamicQueryStopped) {
            return true;
        }
        if (this.receivedResults >= this.desiredResults) {
            return true;
        }
        if (this.estimatedQueriedHorizon > 250000) {
            return true;
        }
        long l = System.currentTimeMillis();
        return l > this.queryStartTime + this.queryTimeout;
    }

    public int getProgress() {
        if (!this.isDynamicQueryStarted) {
            return 0;
        }
        if (this.isDynamicQueryStopped) {
            return 100;
        }
        int n = (int)((double)this.receivedResults / (double)this.desiredResults * 100.0);
        int n2 = (int)((double)this.estimatedQueriedHorizon / 250000.0 * 100.0);
        long l = System.currentTimeMillis();
        int n3 = (int)(100.0 - (double)(this.queryStartTime + this.queryTimeout - l) / (double)this.queryTimeout * 100.0);
        return Math.min(Math.max(n, Math.max(n2, n3)), 100);
    }

    public void processQuery() {
        long l = System.currentTimeMillis();
        if (l < this.nextProcessTime) {
            return;
        }
        if (!this.isDynamicQueryStarted) {
            this.isDynamicQueryStarted = true;
            this.queryStartTime = l;
            boolean bl = this.processQueryToLeaves();
            if (bl) {
                this.nextProcessTime = System.currentTimeMillis() + (long)this.timeToWaitPerHop;
                return;
            }
        }
        if (!this.isProbeQuerySent) {
            this.processProbeQuery();
        } else {
            this.processStandardQuery();
        }
    }

    private void processStandardQuery() {
        Object object;
        int n;
        byte by;
        Host[] hostArray = this.hostsContainer.getUltrapeerConnections();
        int n2 = 0;
        Host host = null;
        for (by = 0; by < hostArray.length; ++by) {
            if (!hostArray[by].isConnectionStable() || this.queriedHosts.contains(hostArray[by])) continue;
            ++n2;
            host = hostArray[by];
        }
        if (n2 == 0 || host == null) {
            this.nextProcessTime = System.currentTimeMillis() + 5000L;
            return;
        }
        by = host.getMaxTTL();
        byte by2 = this.calculateTTL(by, n = host.getUltrapeerDegree(), n2);
        if (by2 == 1 && host.isUPQueryRoutingSupported() && ((object = host.getLastReceivedRoutingTable()) == null || !((QueryRoutingTable)object).containsQuery(this.query))) {
            by2 = 2;
        }
        object = new QueryMsg(this.query, by2);
        host.queueMessageToSend((Message)object);
        this.queriedHosts.add(host);
        this.estimatedQueriedHorizon = this.calculateEstimatedHorizon(n, by2);
        this.nextProcessTime = System.currentTimeMillis() + (long)(by2 * this.timeToWaitPerHop);
        this.adjustTimeToWaitPerHop();
    }

    private void processProbeQuery() {
        int n;
        Host[] hostArray = this.hostsContainer.getUltrapeerConnections();
        ArrayList<Host> arrayList = new ArrayList<Host>(hostArray.length);
        ArrayList<Host> arrayList2 = new ArrayList<Host>(hostArray.length);
        for (n = 0; n < hostArray.length; ++n) {
            QueryRoutingTable queryRoutingTable = hostArray[n].getLastReceivedRoutingTable();
            if (hostArray[n].isUPQueryRoutingSupported() && queryRoutingTable != null) {
                if (queryRoutingTable.containsQuery(this.query)) {
                    arrayList.add(hostArray[n]);
                    continue;
                }
                arrayList2.add(hostArray[n]);
                continue;
            }
            arrayList2.add(0, hostArray[n]);
        }
        n = arrayList.size();
        int n2 = 0;
        int n3 = Math.min(10, n);
        this.sendProbeQueryToHosts(arrayList.subList(0, n3), (byte)1);
        n = n3;
        if (n < 4) {
            n3 = Math.min(3, arrayList2.size());
            this.sendProbeQueryToHosts(arrayList2.subList(0, n3), (byte)2);
            n2 = n3;
        }
        this.nextProcessTime = System.currentTimeMillis() + (long)(this.timeToWaitPerHop * (n + n2));
        this.isProbeQuerySent = true;
    }

    private boolean processQueryToLeaves() {
        QueryRoutingTable queryRoutingTable = this.messageMgr.getLastSentQueryRoutingTable();
        if (queryRoutingTable != null && queryRoutingTable.containsQuery(this.query)) {
            QueryMsg queryMsg = new QueryMsg(this.query, 1);
            this.estimatedQueriedHorizon += this.hostsContainer.getLeafConnectionCount();
            this.messageMgr.forwardQueryToLeaves(queryMsg, queryMsg.getHeader().getFromHost());
            return true;
        }
        return false;
    }

    public void sendProbeQueryToHosts(List list, byte by) {
        Iterator iterator = list.iterator();
        QueryMsg queryMsg = new QueryMsg(this.query, 1);
        while (iterator.hasNext()) {
            Host host = (Host)iterator.next();
            host.queueMessageToSend(queryMsg);
            this.queriedHosts.add(host);
            int n = host.getUltrapeerDegree();
            this.estimatedQueriedHorizon = this.calculateEstimatedHorizon(n, by);
        }
    }

    private int calculateEstimatedHorizon(int n, byte by) {
        int n2 = 0;
        while (by > 0) {
            n2 = (int)((double)n2 + Math.pow(n - 1, by - 1));
            by = (byte)(by - 1);
        }
        return n2;
    }

    private byte calculateTTL(byte by, int n, int n2) {
        double d = (double)this.receivedResults / (double)this.estimatedQueriedHorizon;
        int n3 = this.desiredResults - this.receivedResults;
        int n4 = d == 0.0 ? 50000 : (int)((double)n3 / d);
        int n5 = n4 / n2;
        for (byte by2 = 1; by2 < 6; by2 = (byte)(by2 + 1)) {
            if (by2 > by) {
                return by;
            }
            int n6 = (int)(16.0 * (double)this.calculateEstimatedHorizon(n, by2));
            if (n6 < n5) continue;
            return by2;
        }
        return by;
    }

    private void adjustTimeToWaitPerHop() {
        if (this.timeToWaitPerHop > 100 && System.currentTimeMillis() - this.queryStartTime > 6000L) {
            double d = this.receivedResults == 0 ? 20.0 : (double)Math.max(20, this.desiredResults / 2 / this.receivedResults);
            this.timeToWaitPerHop -= (int)(200.0 * d);
            if (this.timeToWaitPerHop < 100) {
                this.timeToWaitPerHop = 100;
            }
        }
    }
}

