/*
 * Decompiled with CFR 0.152.
 */
package phex.net.presentation;

import java.io.IOException;
import phex.common.address.DestAddress;
import phex.common.address.DestAddressFactory;
import phex.net.presentation.SocketFacade;

public abstract class PresentationManager
implements DestAddressFactory {
    private static final String PRESENTATION_MANAGER_DEFAULT = "phex.net.presentation.def.DefaultPresentationManager";
    private static PresentationManager instance;

    public abstract SocketFacade createSocket(DestAddress var1, int var2) throws IOException;

    public static PresentationManager getInstance() {
        if (instance == null) {
            instance = PresentationManager.createInstance();
        }
        return instance;
    }

    private static PresentationManager createInstance() {
        String string = PRESENTATION_MANAGER_DEFAULT;
        try {
            Class<?> clazz = Class.forName(string);
            if (!PresentationManager.class.isAssignableFrom(clazz)) {
                throw new RuntimeException("Can't create PresentationManager from: " + string);
            }
            return (PresentationManager)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("Class not found " + string);
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException("Failed to instantiate " + string);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("Illegal access to " + string);
        }
    }

    public boolean initialize() {
        return true;
    }

    public boolean onPostInitialization() {
        return true;
    }

    public void startupCompletedNotify() {
    }

    public void shutdown() {
    }
}

