/*
 * Decompiled with CFR 0.152.
 */
package phex.net.connection;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import phex.common.ServiceManager;
import phex.common.address.DestAddress;
import phex.utils.IOUtil;

public class NIOSocketFactory {
    private NIOSocketFactory() {
    }

    public static Socket connectNIO(DestAddress destAddress) throws IOException {
        return NIOSocketFactory.connectNIO(destAddress.getHostName(), destAddress.getPort(), ServiceManager.sCfg.socketConnectTimeout);
    }

    public static Socket connectNIO(DestAddress destAddress, int n) throws IOException {
        return NIOSocketFactory.connectNIO(destAddress.getHostName(), destAddress.getPort(), n);
    }

    public static Socket connectNIO(String string, int n, int n2) throws IOException {
        if (n < 0 || n > 65535) {
            throw new IOException("Wrong host address (port out of range: " + n + " )");
        }
        if (ServiceManager.sCfg.mProxyUse) {
            return NIOSocketFactory.connectSock5NIO(string, n);
        }
        SocketChannel socketChannel = SocketChannel.open();
        socketChannel.configureBlocking(true);
        Socket socket = socketChannel.socket();
        socket.connect(new InetSocketAddress(string, n), n2);
        socket.setSoTimeout(ServiceManager.sCfg.socketRWTimeout);
        return socket;
    }

    private static Socket connectSock5NIO(String string, int n) throws IOException {
        Socket socket = null;
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            SocketChannel socketChannel = SocketChannel.open();
            socketChannel.configureBlocking(true);
            socket = socketChannel.socket();
            socket.connect(new InetSocketAddress(ServiceManager.sCfg.mProxyHost, ServiceManager.sCfg.mProxyPort), ServiceManager.sCfg.socketConnectTimeout);
            socket.setSoTimeout(ServiceManager.sCfg.socketRWTimeout);
            inputStream = socket.getInputStream();
            outputStream = socket.getOutputStream();
            byte[] byArray = ServiceManager.sCfg.mProxyUserName.length() > 0 ? new byte[]{5, 2, 0, 2} : new byte[]{5, 1, 0};
            outputStream.write(byArray, 0, byArray.length);
            int n2 = inputStream.read();
            if (n2 != 5) {
                throw new IOException("Invalid SOCKS server version: " + n2);
            }
            byte by = (byte)inputStream.read();
            if (by == -1) {
                throw new IOException("SOCKS: No acceptable authentication.");
            }
            if (by != 0) {
                if (by == 2) {
                    NIOSocketFactory.authenticateUserPassword(inputStream, outputStream);
                } else {
                    throw new IOException("Unknown SOCKS5 authentication method required.");
                }
            }
            byte[] byArray2 = new byte[10];
            byArray2[0] = 5;
            byArray2[1] = 1;
            byArray2[2] = 0;
            byArray2[3] = 1;
            IOUtil.serializeIP(string, byArray2, 4);
            byArray2[8] = (byte)(n >> 8);
            byArray2[9] = (byte)n;
            outputStream.write(byArray2, 0, byArray2.length);
            int n3 = inputStream.read();
            int n4 = inputStream.read();
            inputStream.read();
            int n5 = inputStream.read();
            if (n5 == 1) {
                inputStream.read();
                inputStream.read();
                inputStream.read();
                inputStream.read();
            } else if (n5 == 3) {
                int n6 = inputStream.read();
                if (n6 < 0) {
                    n6 += 256;
                }
                while (n6 > 0) {
                    inputStream.read();
                    --n6;
                }
            } else if (n5 == 4) {
                for (int i = 0; i < 16; ++i) {
                    inputStream.read();
                }
            } else {
                throw new IOException("Invalid return address type for SOCKS5");
            }
            inputStream.read();
            inputStream.read();
            if (n3 != 5) {
                throw new IOException("Invalid SOCKS server version: " + n3);
            }
            switch (n4) {
                case 0: {
                    return socket;
                }
                case 1: {
                    throw new IOException("SOCKS: General SOCKS server failure");
                }
                case 2: {
                    throw new IOException("SOCKS: Connection not allowed by ruleset");
                }
                case 3: {
                    throw new IOException("SOCKS: Network unreachable");
                }
                case 4: {
                    throw new IOException("SOCKS: Host unreachable");
                }
                case 5: {
                    throw new IOException("SOCKS: Connection refused");
                }
                case 6: {
                    throw new IOException("SOCKS: TTL expired");
                }
                case 7: {
                    throw new IOException("SOCKS: Command not supported");
                }
                case 8: {
                    throw new IOException("SOCKS: Address type not supported");
                }
            }
            throw new IOException("SOCKS: Unknown status response: " + n4);
        }
        catch (Exception exception) {
            IOUtil.closeQuietly(inputStream);
            IOUtil.closeQuietly(outputStream);
            IOUtil.closeQuietly(socket);
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new IOException("Error: " + exception.getMessage());
        }
    }

    private static void authenticateUserPassword(InputStream inputStream, OutputStream outputStream) throws IOException {
        String string = ServiceManager.sCfg.mProxyUserName;
        String string2 = ServiceManager.sCfg.mProxyPassword;
        byte[] byArray = new byte[3 + string.length() + string2.length()];
        int n = 0;
        byArray[n++] = 1;
        byArray[n++] = (byte)string.length();
        n = IOUtil.serializeString(string, byArray, n);
        byArray[n++] = (byte)string2.length();
        n = IOUtil.serializeString(string2, byArray, n);
        outputStream.write(byArray, 0, n);
        if (inputStream.read() == 1 && inputStream.read() == 0) {
            return;
        }
        throw new IOException("Proxy server authentication failed.");
    }
}

