/*
 * Decompiled with CFR 0.152.
 */
package phex.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.TimerTask;
import phex.common.Environment;
import phex.common.ServiceManager;
import phex.common.ThreadPool;
import phex.common.address.IpAddress;
import phex.host.HostManager;
import phex.host.NetworkHostsContainer;
import phex.msg.MsgManager;
import phex.utils.NLogger;

public abstract class Server
implements Runnable {
    protected ServerSocket serverSocket;
    protected boolean isRunning;
    protected boolean hasConnectedIncomming;
    protected long lastInConnectionTime;
    protected long lastFirewallCheckTime;

    public Server() {
        this.hasConnectedIncomming = ServiceManager.sCfg.hasConnectedIncomming;
        this.lastInConnectionTime = -1L;
        this.isRunning = false;
        Environment.getInstance().scheduleTimerTask(new FirewallCheckTimer(), 120000L, 120000L);
    }

    public synchronized void startup() throws IOException {
        if (this.isRunning) {
            return;
        }
        NLogger.debug("SERVER", (Object)"Starting listener");
        this.isRunning = true;
        this.bind();
        ThreadPool.getInstance().addJob(this, "IncommingListener-" + Integer.toHexString(this.hashCode()));
    }

    protected abstract void bind() throws IOException;

    protected abstract void closeServer();

    public synchronized void restart() throws IOException {
        this.shutdown(true);
        this.startup();
    }

    public synchronized void shutdown(boolean bl) {
        if (!this.isRunning) {
            return;
        }
        NLogger.debug("SERVER", (Object)"Shutting down listener");
        ServiceManager.sCfg.hasConnectedIncomming = this.hasConnectedIncomming;
        this.closeServer();
        if (bl) {
            while (this.isRunning) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
        }
    }

    public boolean getRunning() {
        return this.isRunning;
    }

    public boolean hasConnectedIncoming() {
        return this.hasConnectedIncomming;
    }

    public IpAddress resolveLocalHostIP() {
        byte[] byArray = null;
        InetAddress inetAddress = this.serverSocket.getInetAddress();
        byArray = inetAddress.getAddress();
        if (byArray[0] == 0 && byArray[1] == 0 && byArray[2] == 0 && byArray[3] == 0) {
            byArray = IpAddress.LOCAL_HOST_IP;
        }
        IpAddress ipAddress = new IpAddress(byArray);
        return ipAddress;
    }

    public int getListeningLocalPort() {
        if (this.serverSocket != null) {
            return this.serverSocket.getLocalPort();
        }
        return ServiceManager.sCfg.mListeningPort;
    }

    public void resetFirewallCheck() {
        this.lastFirewallCheckTime = 0L;
    }

    private class IncommingCheckRunner
    extends TimerTask {
        public static final long TIMER_PERIOD = 45000L;

        private IncommingCheckRunner() {
        }

        public void run() {
            try {
                long l = System.currentTimeMillis();
                if (l - Server.this.lastInConnectionTime > 45000L) {
                    Server.this.hasConnectedIncomming = false;
                }
            }
            catch (Throwable throwable) {
                NLogger.error("SERVER", (Object)throwable, throwable);
            }
        }
    }

    private class FirewallCheckTimer
    extends TimerTask {
        public static final long TIMER_PERIOD = 120000L;
        private static final long CHECK_TIME = 900000L;

        private FirewallCheckTimer() {
        }

        public void run() {
            try {
                long l = System.currentTimeMillis();
                if (Server.this.hasConnectedIncomming && l - Server.this.lastInConnectionTime > 900000L || !Server.this.hasConnectedIncomming && l - Server.this.lastFirewallCheckTime > 900000L) {
                    NetworkHostsContainer networkHostsContainer = HostManager.getInstance().getNetworkHostsContainer();
                    if (networkHostsContainer.getUltrapeerConnectionCount() <= 2) {
                        return;
                    }
                    boolean bl = MsgManager.getInstance().requestTCPConnectBack();
                    if (bl) {
                        Server.this.lastFirewallCheckTime = l;
                        Environment.getInstance().scheduleTimerTask(new IncommingCheckRunner(), 45000L);
                    }
                }
            }
            catch (Throwable throwable) {
                NLogger.error("SERVER", (Object)throwable, throwable);
            }
        }
    }
}

