/*
 * Decompiled with CFR 0.152.
 */
package phex.msg.vendor;

import phex.common.address.AddressUtils;
import phex.msg.InvalidMessageException;
import phex.msg.MsgHeader;
import phex.msg.vendor.VendorMsg;
import phex.utils.IOUtil;

public class TCPConnectBackVMsg
extends VendorMsg {
    public static final int VERSION = 1;
    private int port;

    public TCPConnectBackVMsg(MsgHeader msgHeader, byte[] byArray, int n, int n2, byte[] byArray2) throws InvalidMessageException {
        super(msgHeader, byArray, n, n2, byArray2);
        if (n2 > 1) {
            throw new InvalidMessageException("Vendor Message 'TCPConnectBack' with invalid version: " + n2);
        }
        if (byArray2.length != 2) {
            throw new InvalidMessageException("Vendor Message 'TCPConnectBack' invalid data length: " + byArray2.length);
        }
        this.port = IOUtil.unsignedShort2Int(IOUtil.deserializeShortLE(byArray2, 0));
        if (!AddressUtils.isPortInRange(this.port)) {
            throw new InvalidMessageException("Invalid connect back port: " + this.port);
        }
    }

    public TCPConnectBackVMsg(int n) {
        super(VENDORID_BEAR, 7, 1, TCPConnectBackVMsg.buildDataBody(n));
        this.port = n;
    }

    public int getPort() {
        return this.port;
    }

    private static byte[] buildDataBody(int n) {
        byte[] byArray = new byte[2];
        IOUtil.serializeShortLE((short)n, byArray, 0);
        return byArray;
    }
}

