/*
 * Decompiled with CFR 0.152.
 */
package phex.msg;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.io.UnsupportedEncodingException;
import java.util.Set;
import java.util.StringTokenizer;
import phex.common.URN;
import phex.common.address.DestAddress;
import phex.msg.GGEPBlock;
import phex.msg.GGEPExtension;
import phex.msg.InvalidGGEPBlockException;
import phex.utils.IOUtil;
import phex.utils.NLogger;

public class QueryResponseRecord {
    private int fileIndex = 0;
    private String fileName;
    private byte[] fileNameBytes;
    private String pathInfo;
    private int fileSize = 0;
    private URN urn;
    private String metaData;
    private DestAddress[] alternateLocations;
    private long creationTime;

    public QueryResponseRecord() {
        this.pathInfo = "";
        this.creationTime = -1L;
    }

    public QueryResponseRecord(int n, URN uRN, int n2, String string, long l, Set set) {
        this.fileIndex = n;
        this.fileSize = n2;
        this.fileName = string;
        this.creationTime = l;
        if (set != null && set.size() > 0) {
            this.alternateLocations = new DestAddress[set.size()];
            set.toArray(this.alternateLocations);
        }
        try {
            this.fileNameBytes = this.fileName.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            NLogger.error("GLOBAL", (Object)unsupportedEncodingException, (Throwable)unsupportedEncodingException);
        }
        this.urn = uRN;
        this.pathInfo = "";
    }

    public int getFileIndex() {
        return this.fileIndex;
    }

    public int getFileSize() {
        return this.fileSize;
    }

    public String getFilename() {
        return this.fileName;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public URN getURN() {
        return this.urn;
    }

    public DestAddress[] getAlternateLocations() {
        return this.alternateLocations;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public String getMetaData() {
        return this.metaData;
    }

    public void copy(QueryResponseRecord queryResponseRecord) {
        this.fileIndex = queryResponseRecord.fileIndex;
        this.fileSize = queryResponseRecord.fileSize;
        this.fileName = queryResponseRecord.fileName;
        this.fileNameBytes = queryResponseRecord.fileNameBytes;
        this.pathInfo = queryResponseRecord.pathInfo;
    }

    public void write(OutputStream outputStream) throws IOException {
        IOUtil.serializeIntLE(this.fileIndex, outputStream);
        IOUtil.serializeIntLE(this.fileSize, outputStream);
        outputStream.write(this.fileNameBytes);
        outputStream.write(0);
        byte[] byArray = GGEPBlock.getQueryReplyRecordGGEPBlock(this.creationTime, this.alternateLocations);
        if (this.urn != null) {
            outputStream.write(this.urn.getAsString().getBytes());
            if (byArray.length > 0) {
                outputStream.write(28);
            }
        }
        if (byArray.length > 0) {
            outputStream.write(byArray);
        }
        outputStream.write(0);
    }

    public int deserialize(byte[] byArray, int n) throws UnsupportedEncodingException {
        this.fileIndex = IOUtil.deserializeIntLE(byArray, n);
        this.fileSize = IOUtil.deserializeIntLE(byArray, n += 4);
        int n2 = n += 4;
        while (byArray[n2] != 0) {
            ++n2;
        }
        this.fileName = new String(byArray, n, n2 - n, "UTF-8");
        int n3 = n2 + 1;
        while (byArray[n3] != 0) {
            ++n3;
        }
        byte[] byArray2 = new byte[n3 - n2 - 1];
        System.arraycopy(byArray, n2 + 1, byArray2, 0, n3 - n2 - 1);
        this.parseExtensionArea(byArray2);
        n = n3 + 1;
        return n;
    }

    private void parseExtensionArea(byte[] byArray) {
        try {
            PushbackInputStream pushbackInputStream = new PushbackInputStream(new ByteArrayInputStream(byArray));
            StringBuffer stringBuffer = new StringBuffer();
            GGEPBlock[] gGEPBlockArray = null;
            GGEPBlock gGEPBlock = null;
            while (true) {
                byte by;
                if ((by = (byte)pushbackInputStream.read()) == -1) break;
                if (by == -61 && stringBuffer.length() == 0) {
                    pushbackInputStream.unread(by);
                    try {
                        gGEPBlockArray = GGEPBlock.parseGGEPBlocks(pushbackInputStream);
                        gGEPBlock = GGEPBlock.mergeGGEPBlocks(gGEPBlockArray);
                    }
                    catch (InvalidGGEPBlockException invalidGGEPBlockException) {
                        NLogger.error("MESSAGE_ENCODE_DECODE", (Object)invalidGGEPBlockException, (Throwable)invalidGGEPBlockException);
                    }
                    continue;
                }
                if (by == 28) {
                    this.evaluateExtensionToken(stringBuffer.toString());
                    stringBuffer.setLength(0);
                    continue;
                }
                stringBuffer.append((char)by);
            }
            this.evaluateExtensionToken(stringBuffer.toString());
            if (gGEPBlockArray != null) {
                this.alternateLocations = GGEPExtension.parseAltExtensionData(gGEPBlockArray);
                byte[] byArray2 = GGEPBlock.getExtensionDataInBlocks(gGEPBlockArray, "PATH");
                if (byArray2 != null) {
                    this.pathInfo = new String(byArray2);
                }
                this.creationTime = gGEPBlock.getLongExtensionData("CT", -1L) * 1000L;
            }
        }
        catch (IOException iOException) {
            NLogger.error("MESSAGE_ENCODE_DECODE", (Object)iOException, (Throwable)iOException);
        }
    }

    private void evaluateExtensionToken(String string) {
        if (URN.isValidURN(string)) {
            this.urn = new URN(string);
        } else if (this.metaData == null || this.metaData.length() == 0) {
            this.metaData = this.parseMetaData(string);
        }
    }

    public String toString() {
        return "[FileIndex=" + this.fileIndex + ", " + "FileSize=" + this.fileSize + ", " + "Filename=" + this.fileName + "]";
    }

    private String parseMetaData(String string) {
        int n;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (stringTokenizer.countTokens() < 2) {
            return "";
        }
        String string2 = stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        String string4 = "";
        String string5 = "";
        String string6 = "";
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (string3.toLowerCase().startsWith("kbps")) {
            bl2 = true;
            if (string3.indexOf("VBR") > 0) {
                bl = true;
            }
        } else if (string2.toLowerCase().endsWith("kbps")) {
            bl3 = true;
        }
        if (bl2) {
            string6 = string2;
        } else if (bl3) {
            n = string2.toLowerCase().indexOf("kbps");
            string6 = string2.substring(0, n);
        }
        if (bl2 || bl3) {
            String string7 = "";
            String string8 = "";
            while (stringTokenizer.hasMoreTokens()) {
                string8 = stringTokenizer.nextToken();
                if (string8.startsWith("kHz")) {
                    string5 = string7;
                }
                string7 = string8;
            }
            string4 = string8;
        } else if (string.endsWith("kHz")) {
            bl4 = true;
            string4 = string2;
            n = string3.indexOf("kbps");
            if (n > -1) {
                string6 = string3.substring(0, n);
            } else {
                bl4 = false;
            }
        }
        if (bl2 || bl3 || bl4) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string6);
            stringBuffer.append("Kbps");
            if (bl) {
                stringBuffer.append("(VBR)");
            }
            stringBuffer.append(" - ");
            if (string5 != null && string5.length() > 0) {
                stringBuffer.append(string5);
                stringBuffer.append("kHz");
                stringBuffer.append(" - ");
            }
            stringBuffer.append(string4);
            return stringBuffer.toString();
        }
        return "";
    }
}

