/*
 * Decompiled with CFR 0.152.
 */
package phex.msg;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import phex.common.ServiceManager;
import phex.common.URN;
import phex.common.address.DefaultDestAddress;
import phex.common.address.DestAddress;
import phex.connection.NetworkManager;
import phex.host.HostManager;
import phex.msg.GGEPBlock;
import phex.msg.GGEPExtension;
import phex.msg.GUID;
import phex.msg.InvalidGGEPBlockException;
import phex.msg.InvalidMessageException;
import phex.msg.Message;
import phex.msg.MsgHeader;
import phex.msg.QueryResponseRecord;
import phex.query.QueryConstants;
import phex.upload.UploadManager;
import phex.utils.GnutellaOutputStream;
import phex.utils.HexConverter;
import phex.utils.IOUtil;
import phex.utils.NLogger;
import phex.xml.XMLUtils;

public class QueryResponseMsg
extends Message
implements QueryConstants {
    private static final boolean INCLUDE_QHD = true;
    private static final byte PUSH_NEEDED_MASK = 1;
    private static final byte SERVER_BUSY_MASK = 4;
    private static final byte HAS_UPLOADED_MASK = 8;
    private static final byte UPLOAD_SPEED_MASK = 16;
    private static final byte GGEP_MASK = 32;
    private static final byte CHAT_SUPPORTED_MASK = 1;
    private byte[] body;
    private short uniqueResultCount;
    private QueryResponseRecord[] records;
    private long remoteHostSpeed;
    private DestAddress destAddress;
    private GUID remoteClientID;
    private String vendorCode;
    private short pushNeededFlag;
    private short serverBusyFlag;
    private short hasUploadedFlag;
    private short uploadSpeedFlag;
    private boolean isChatSupported;
    private boolean isBrowseHostSupported;
    private DestAddress[] pushProxyAddresses;
    private boolean isParsed;

    public QueryResponseMsg(MsgHeader msgHeader, GUID gUID, DestAddress destAddress, int n, QueryResponseRecord[] queryResponseRecordArray) {
        super(msgHeader);
        boolean bl;
        if (queryResponseRecordArray.length > 255) {
            throw new IllegalArgumentException("A maximum of 255 records can be associated with a single response: " + queryResponseRecordArray.length);
        }
        this.getHeader().setPayloadType((byte)-127);
        this.remoteClientID = gUID;
        this.destAddress = destAddress;
        this.remoteHostSpeed = n;
        this.records = queryResponseRecordArray;
        this.pushProxyAddresses = HostManager.getInstance().getNetworkHostsContainer().getPushProxies();
        if (NetworkManager.getInstance().hasConnectedIncoming()) {
            bl = false;
            this.pushNeededFlag = 0;
        } else {
            bl = true;
            this.pushNeededFlag = 1;
        }
        boolean bl2 = UploadManager.getInstance().isHostBusy();
        try {
            this.buildBody(bl, bl2);
        }
        catch (IOException iOException) {
            NLogger.error("MESSAGE_ENCODE_DECODE", (Object)iOException, (Throwable)iOException);
        }
        this.getHeader().setDataLength(this.body.length);
        this.isParsed = true;
    }

    public QueryResponseMsg(MsgHeader msgHeader, byte[] byArray) throws InvalidMessageException {
        super(msgHeader);
        this.getHeader().setPayloadType((byte)-127);
        this.body = byArray;
        msgHeader.setDataLength(this.body.length);
        int n = IOUtil.unsignedShort2Int(IOUtil.deserializeShortLE(this.body, 1));
        this.destAddress = new DefaultDestAddress(this.getHostIP(), n);
        if (!this.destAddress.isValidAddress()) {
            throw new InvalidMessageException("Invalid address: " + this.destAddress);
        }
        this.isParsed = false;
    }

    private void buildBody(boolean bl, boolean bl2) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n2 = this.records.length;
        byteArrayOutputStream.write((byte)n2);
        IOUtil.serializeShortLE((short)this.destAddress.getPort(), byteArrayOutputStream);
        byte[] byArray = this.destAddress.getIpAddress().getHostIP();
        byteArrayOutputStream.write(byArray);
        IOUtil.serializeIntLE((int)this.remoteHostSpeed, byteArrayOutputStream);
        for (n = 0; n < n2; ++n) {
            this.records[n].write(byteArrayOutputStream);
        }
        byteArrayOutputStream.write(80);
        byteArrayOutputStream.write(72);
        byteArrayOutputStream.write(69);
        byteArrayOutputStream.write(88);
        byteArrayOutputStream.write(2);
        n = 0;
        if (bl) {
            n = 1;
        }
        int n3 = 0;
        if (bl2) {
            n3 = 4;
        }
        int n4 = 0;
        if (ServiceManager.sCfg.mShareBrowseDir || this.pushProxyAddresses != null && this.pushProxyAddresses.length > 0) {
            n4 = 32;
        }
        byteArrayOutputStream.write((byte)(n | 4 | 0 | 0x10 | 0x20));
        byteArrayOutputStream.write((byte)(1 | n3 | 0 | 0 | n4));
        if (ServiceManager.sCfg.isChatEnabled) {
            byteArrayOutputStream.write(1);
        } else {
            byteArrayOutputStream.write(0);
        }
        byte[] byArray2 = GGEPBlock.getQueryReplyGGEPBlock(ServiceManager.sCfg.mShareBrowseDir, this.pushProxyAddresses);
        if (byArray2.length > 0) {
            byteArrayOutputStream.write(byArray2);
        }
        this.remoteClientID.write(byteArrayOutputStream);
        this.body = byteArrayOutputStream.toByteArray();
    }

    public short getRecordCount() {
        return (short)IOUtil.unsignedByte2int(this.body[0]);
    }

    public short getUniqueResultCount() {
        this.parseBody();
        return this.uniqueResultCount;
    }

    public byte[] getHostIP() {
        byte[] byArray = new byte[]{this.body[3], this.body[4], this.body[5], this.body[6]};
        return byArray;
    }

    public DestAddress getDestAddress() {
        return this.destAddress;
    }

    public long getRemoteHostSpeed() {
        this.parseBody();
        return this.remoteHostSpeed;
    }

    public String getVendorCode() {
        this.parseBody();
        return this.vendorCode;
    }

    public short getPushNeededFlag() {
        this.parseBody();
        return this.pushNeededFlag;
    }

    public short getServerBusyFlag() {
        this.parseBody();
        return this.serverBusyFlag;
    }

    public short getHasUploadedFlag() {
        this.parseBody();
        return this.hasUploadedFlag;
    }

    public short getUploadSpeedFlag() {
        this.parseBody();
        return this.uploadSpeedFlag;
    }

    public boolean isChatSupported() {
        this.parseBody();
        return this.isChatSupported;
    }

    public boolean isBrowseHostSupported() {
        this.parseBody();
        return this.isBrowseHostSupported;
    }

    public DestAddress[] getPushProxyAddresses() {
        this.parseBody();
        return this.pushProxyAddresses;
    }

    public GUID getRemoteClientID() {
        if (this.remoteClientID == null) {
            this.parseRemoteClientID();
        }
        return this.remoteClientID;
    }

    public QueryResponseRecord getMsgRecord(int n) {
        this.parseBody();
        return this.records[n];
    }

    public void copy(QueryResponseMsg queryResponseMsg) {
        this.getHeader().copy(queryResponseMsg.getHeader());
        this.destAddress = queryResponseMsg.destAddress;
        this.remoteHostSpeed = queryResponseMsg.remoteHostSpeed;
        this.remoteClientID = queryResponseMsg.remoteClientID;
        int n = queryResponseMsg.records.length;
        this.records = new QueryResponseRecord[n];
        for (int i = 0; i < n; ++i) {
            QueryResponseRecord queryResponseRecord = new QueryResponseRecord();
            queryResponseRecord.copy(queryResponseMsg.records[i]);
            this.records[i] = queryResponseRecord;
        }
        this.body = queryResponseMsg.body;
    }

    public void writeMessage(GnutellaOutputStream gnutellaOutputStream) throws IOException {
        this.getHeader().writeHeader(gnutellaOutputStream);
        gnutellaOutputStream.write(this.body, 0, this.body.length);
    }

    private void parseBody() {
        int n;
        if (this.isParsed) {
            return;
        }
        int n2 = 0;
        int n3 = (n = this.body[n2++]) < 0 ? 256 + n : n;
        n2 += 2;
        n2 += 4;
        try {
            int n4;
            long l;
            this.remoteHostSpeed = l = IOUtil.unsignedInt2Long(IOUtil.deserializeIntLE(this.body, n2));
            n2 += 4;
            this.uniqueResultCount = 0;
            HashSet<URN> hashSet = new HashSet<URN>();
            this.records = new QueryResponseRecord[n3];
            for (n4 = 0; n4 < n3; ++n4) {
                QueryResponseRecord queryResponseRecord = new QueryResponseRecord();
                n2 = queryResponseRecord.deserialize(this.body, n2);
                this.records[n4] = queryResponseRecord;
                URN uRN = queryResponseRecord.getURN();
                if (uRN != null) {
                    hashSet.add(uRN);
                    continue;
                }
                this.uniqueResultCount = (short)(this.uniqueResultCount + 1);
            }
            this.uniqueResultCount = (short)(this.uniqueResultCount + hashSet.size());
            this.pushNeededFlag = (short)-1;
            this.serverBusyFlag = (short)-1;
            this.hasUploadedFlag = (short)-1;
            this.uploadSpeedFlag = (short)-1;
            this.isBrowseHostSupported = false;
            if (n2 <= this.getHeader().getDataLength() - 16 - 4 - 2) {
                int n5;
                this.vendorCode = new String(this.body, n2, 4, "ISO-8859-1");
                if (!this.isVendorCodeValid(this.vendorCode)) {
                    String string = HexConverter.toHexString(this.body, n2, 4);
                    NLogger.warn(QueryResponseMsg.class, (Object)(this.getHeader().getFromHost() + ": Illegal QHD vendor code found: " + this.vendorCode + " (" + string + "). Body: " + HexConverter.toHexString(this.body)));
                    this.vendorCode = string;
                }
                n4 = IOUtil.unsignedByte2int(this.body[n2 += 4]);
                ++n2;
                if (n4 > 1) {
                    byte by = this.body[n2];
                    byte by2 = this.body[n2 + 1];
                    if ((by2 & 1) != 0) {
                        this.pushNeededFlag = (by & 1) != 0 ? (short)1 : 0;
                    }
                    if ((by & 4) != 0) {
                        this.serverBusyFlag = (by2 & 4) != 0 ? (short)1 : 0;
                    }
                    if ((by & 8) != 0) {
                        this.hasUploadedFlag = (by2 & 8) != 0 ? (short)1 : 0;
                    }
                    if ((by & 0x10) != 0) {
                        this.uploadSpeedFlag = (by2 & 0x10) != 0 ? (short)1 : 0;
                    }
                    if ((by & 0x20) != 0 && (by2 & 0x20) != 0) {
                        int n6;
                        for (n6 = n2 + 2; n6 < this.body.length && this.body[n6] != -61; ++n6) {
                        }
                        GGEPBlock[] gGEPBlockArray = null;
                        try {
                            gGEPBlockArray = GGEPBlock.parseGGEPBlocks(this.body, n6);
                            this.isBrowseHostSupported = GGEPBlock.isExtensionHeaderInBlocks(gGEPBlockArray, "BH");
                            this.pushProxyAddresses = GGEPExtension.parsePushProxyExtensionData(gGEPBlockArray);
                        }
                        catch (InvalidGGEPBlockException invalidGGEPBlockException) {
                            NLogger.debug(QueryResponseMsg.class, (Object)invalidGGEPBlockException, (Throwable)invalidGGEPBlockException);
                        }
                    }
                }
                if ((n5 = this.body.length - (n2 += n4) - 16) > 0 && (this.vendorCode.equals("LIME") || this.vendorCode.equals("RAZA") || this.vendorCode.equals("PHEX"))) {
                    byte by = this.body[n2];
                    this.isChatSupported = (by & 1) != 0;
                }
            }
            this.parseRemoteClientID();
            this.isParsed = true;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return;
        }
    }

    private void parseRemoteClientID() {
        if (this.remoteClientID == null) {
            this.remoteClientID = new GUID();
        }
        this.remoteClientID.deserialize(this.body, this.getHeader().getDataLength() - 16);
    }

    private boolean isVendorCodeValid(String string) {
        if (string.length() != 4) {
            return false;
        }
        for (int i = 0; i < 4; ++i) {
            if (XMLUtils.isXmlChar(string.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

