/*
 * Decompiled with CFR 0.152.
 */
package phex.msg;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import phex.common.URN;
import phex.connection.NetworkManager;
import phex.msg.GGEPBlock;
import phex.msg.GGEPExtension;
import phex.msg.HUGEBlock;
import phex.msg.Message;
import phex.msg.MsgHeader;
import phex.utils.GnutellaOutputStream;
import phex.utils.IOUtil;
import phex.utils.NLogger;
import phex.utils.StringUtils;

public class QueryMsg
extends Message {
    public static final boolean IS_PHEX_CAPABLE_OF_XML_RESULTS = false;
    private static final int MINSPEED_BITBASED_BIT = 15;
    private static final int MINSPEED_FIREWALL_BIT = 14;
    private static final int MINSPEED_XML_BIT = 13;
    public static final int NO_FEATURE_QUERY_SELECTOR = 0;
    public static final int WHAT_IS_NEW_FEATURE_QUERY_SELECTOR = 1;
    private static final String WHAT_IS_NEW_QUERY_STRING = "WhatIsNewXOXO";
    private boolean minSpeedIsBitBased;
    private boolean requesterIsFirewalled;
    private boolean requesterIsXmlResultsCapable;
    private String searchString;
    private int featureQuerySelector;
    private byte[] body;
    private boolean isParsed;
    private Set queryURNSet;

    public static QueryMsg createWhatsNewQuery(byte by) {
        return new QueryMsg(by, WHAT_IS_NEW_QUERY_STRING, null, false, !NetworkManager.getInstance().hasConnectedIncoming(), 1);
    }

    public QueryMsg(byte by, String string, URN uRN, boolean bl, boolean bl2) {
        this(by, string, uRN, bl, bl2, 0);
    }

    public QueryMsg(byte by, String string, URN uRN, boolean bl, boolean bl2, int n) {
        super(new MsgHeader(-128, by, 0));
        this.searchString = string;
        this.featureQuerySelector = n;
        if (StringUtils.isEmpty(this.searchString)) {
            this.searchString = "\\";
        }
        if (uRN != null) {
            this.queryURNSet = new HashSet(1);
            this.queryURNSet.add(uRN);
        } else {
            this.queryURNSet = Collections.EMPTY_SET;
        }
        this.minSpeedIsBitBased = true;
        this.requesterIsFirewalled = bl2;
        this.requesterIsXmlResultsCapable = bl;
        try {
            this.buildBody();
        }
        catch (IOException iOException) {
            NLogger.error("MESSAGE_ENCODE_DECODE", (Object)iOException, (Throwable)iOException);
        }
        this.getHeader().setDataLength(this.body.length);
    }

    public QueryMsg(MsgHeader msgHeader, byte[] byArray) {
        super(msgHeader);
        this.getHeader().setPayloadType((byte)-128);
        this.body = byArray;
        this.parseBody();
    }

    public QueryMsg(QueryMsg queryMsg, byte by) {
        super(new MsgHeader(-128, 0));
        this.getHeader().copy(queryMsg.getHeader());
        this.getHeader().setTTL(by);
        this.body = queryMsg.body;
        this.searchString = queryMsg.searchString;
        this.featureQuerySelector = queryMsg.featureQuerySelector;
        this.minSpeedIsBitBased = queryMsg.minSpeedIsBitBased;
        this.requesterIsFirewalled = queryMsg.requesterIsFirewalled;
        this.requesterIsXmlResultsCapable = queryMsg.requesterIsXmlResultsCapable;
        this.isParsed = queryMsg.isParsed;
        this.queryURNSet = new HashSet(queryMsg.queryURNSet);
    }

    private boolean isMinSpeedBitBased() {
        return this.minSpeedIsBitBased;
    }

    public boolean isRequesterFirewalled() {
        return this.minSpeedIsBitBased && this.requesterIsFirewalled;
    }

    public boolean isRequesterXmlResultsCapable() {
        return this.minSpeedIsBitBased && this.requesterIsXmlResultsCapable;
    }

    private void setMinSpeedIsBitBased(boolean bl) {
        this.minSpeedIsBitBased = bl;
    }

    private void setRequesterIsFirewalled(boolean bl) {
        this.requesterIsFirewalled = bl;
    }

    private void setRequesterIsXmlResultsCapable(boolean bl) {
        this.requesterIsXmlResultsCapable = bl;
    }

    private static boolean isBitSet(short s, int n) {
        int n2 = 1 << n;
        return (s & n2) != 0;
    }

    private static short setBit(short s, int n) {
        short s2 = (short)(1 << n);
        return (short)(s | s2);
    }

    private static short setBit(Short s, Integer n) {
        return QueryMsg.setBit((short)s, (int)n);
    }

    private static boolean isBitSet(Short s, Integer n) {
        return QueryMsg.isBitSet((short)s, (int)n);
    }

    public int getFeatureQuerySelector() {
        return this.featureQuerySelector;
    }

    public boolean isWhatsNewQuery() {
        return this.featureQuerySelector == 1;
    }

    public URN[] getQueryURNs() {
        URN[] uRNArray = new URN[this.queryURNSet.size()];
        return this.queryURNSet.toArray(uRNArray);
    }

    public boolean hasQueryURNs() {
        return !this.queryURNSet.isEmpty();
    }

    public String getSearchString() {
        return this.searchString;
    }

    public void writeMessage(GnutellaOutputStream gnutellaOutputStream) throws IOException {
        this.getHeader().writeHeader(gnutellaOutputStream);
        gnutellaOutputStream.write(this.body, 0, this.body.length);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("[").append(this.getHeader()).append(", MinSpeedIsBitBased=").append(this.minSpeedIsBitBased);
        if (this.minSpeedIsBitBased) {
            stringBuffer.append(", RequesterIsFirewalled=").append(this.requesterIsFirewalled).append(", RequesterIsXmlResultsCapable=").append(this.requesterIsXmlResultsCapable);
        }
        stringBuffer.append(", SearchString=").append(this.searchString).append("]");
        return stringBuffer.toString();
    }

    private void buildBody() throws IOException {
        Object object;
        Object object2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        short s = this.buildComplexMinSpeed();
        IOUtil.serializeShort(s, byteArrayOutputStream);
        byteArrayOutputStream.write(this.searchString.getBytes("UTF-8"));
        byteArrayOutputStream.write(0);
        boolean bl = false;
        if (this.queryURNSet.size() == 0) {
            byteArrayOutputStream.write("urn:sha1".getBytes());
            bl = true;
        } else {
            object2 = this.queryURNSet.iterator();
            while (object2.hasNext()) {
                object = (URN)object2.next();
                byteArrayOutputStream.write(((URN)object).getAsString().getBytes());
            }
            bl = true;
        }
        object2 = new GGEPBlock();
        if (this.featureQuerySelector > 0) {
            ((GGEPBlock)object2).addExtension("WH", this.featureQuerySelector);
        }
        if (((Object)(object = (Object)((GGEPBlock)object2).getBytes())).length > 0) {
            if (bl) {
                byteArrayOutputStream.write(28);
            }
            byteArrayOutputStream.write((byte[])object);
            bl = true;
        }
        byteArrayOutputStream.write(0);
        this.body = byteArrayOutputStream.toByteArray();
    }

    private void parseBody() {
        try {
            GGEPBlock[] gGEPBlockArray;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.body);
            short s = IOUtil.deserializeShort(byteArrayInputStream);
            this.parseMinSpeed(s);
            byte[] byArray = IOUtil.readBytesToNull(byteArrayInputStream);
            this.searchString = new String(byArray, "UTF-8");
            byte[] byArray2 = IOUtil.readBytesToNull(byteArrayInputStream);
            HUGEBlock hUGEBlock = new HUGEBlock(byArray2);
            this.queryURNSet = hUGEBlock.getURNS();
            if (this.queryURNSet == null) {
                this.queryURNSet = Collections.EMPTY_SET;
            }
            if ((gGEPBlockArray = hUGEBlock.getGGEPBlocks()) != null && GGEPBlock.isExtensionHeaderInBlocks(gGEPBlockArray, "WH")) {
                this.featureQuerySelector = GGEPExtension.parseIntExtensionData(gGEPBlockArray, "WH", 0);
            }
        }
        catch (IOException iOException) {
            NLogger.error("MESSAGE_ENCODE_DECODE", (Object)iOException, (Throwable)iOException);
        }
    }

    private void parseMinSpeed(short s) {
        this.minSpeedIsBitBased = QueryMsg.isBitSet(s, 15);
        if (this.isMinSpeedBitBased()) {
            this.requesterIsFirewalled = QueryMsg.isBitSet(s, 14);
            this.requesterIsXmlResultsCapable = QueryMsg.isBitSet(s, 13);
        }
    }

    private short buildComplexMinSpeed() {
        short s = 0;
        if (this.minSpeedIsBitBased) {
            s = QueryMsg.setBit(s, 15);
            if (this.requesterIsFirewalled) {
                s = QueryMsg.setBit(s, 14);
            }
            if (this.requesterIsXmlResultsCapable) {
                s = QueryMsg.setBit(s, 13);
            }
        }
        return s;
    }
}

