/*
 * Decompiled with CFR 0.152.
 */
package phex.msg;

import java.io.IOException;
import phex.msg.MsgHeader;
import phex.msg.RouteTableUpdateMsg;
import phex.utils.GnutellaOutputStream;
import phex.utils.IOUtil;

public class QRResetTableMsg
extends RouteTableUpdateMsg {
    private static final int MESSAGE_LENGTH = 6;
    private int tableSize;
    private byte infinityByte;

    public QRResetTableMsg(int n, byte by) {
        super((byte)0, 6);
        this.tableSize = n;
        this.infinityByte = by;
    }

    public QRResetTableMsg(MsgHeader msgHeader, byte[] byArray) {
        super((byte)0, msgHeader);
        msgHeader.setDataLength(byArray.length);
        this.tableSize = IOUtil.deserializeIntLE(byArray, 1);
        this.infinityByte = byArray[5];
    }

    public int getTableSize() {
        return this.tableSize;
    }

    public void writeMessage(GnutellaOutputStream gnutellaOutputStream) throws IOException {
        super.writeMessage(gnutellaOutputStream);
        byte[] byArray = new byte[5];
        IOUtil.serializeIntLE(this.tableSize, byArray, 0);
        byArray[4] = this.infinityByte;
        gnutellaOutputStream.write(byArray);
    }
}

