/*
 * Decompiled with CFR 0.152.
 */
package phex.msg;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import phex.common.IntObj;
import phex.common.address.AddressUtils;
import phex.common.address.DefaultDestAddress;
import phex.common.address.DestAddress;
import phex.common.address.IpAddress;
import phex.common.address.MalformedDestAddressException;
import phex.connection.NetworkManager;
import phex.host.CaughtHost;
import phex.host.CaughtHostsContainer;
import phex.host.Host;
import phex.host.HostManager;
import phex.host.NetworkHostsContainer;
import phex.msg.GGEPBlock;
import phex.msg.GUID;
import phex.msg.InvalidGGEPBlockException;
import phex.msg.InvalidMessageException;
import phex.msg.Message;
import phex.msg.MessageProcessor;
import phex.msg.MsgHeader;
import phex.msg.PingMsg;
import phex.net.presentation.PresentationManager;
import phex.security.PhexSecurityManager;
import phex.share.ShareManager;
import phex.share.SharedFilesService;
import phex.statistic.StatisticProvider;
import phex.statistic.StatisticsManager;
import phex.udp.hostcache.UdpHostCache;
import phex.udp.hostcache.UdpHostCacheManager;
import phex.utils.GnutellaOutputStream;
import phex.utils.HexConverter;
import phex.utils.IOUtil;
import phex.utils.NLogger;
import phex.utils.VersionUtils;

public class PongMsg
extends Message {
    private static final int MIN_PONG_DATA_LEN = 14;
    private static final byte[] GGEP_VENDOR_CODE = new byte[5];
    private byte[] body;
    private int port;
    private byte[] ip;
    private long fileCount;
    private long fileSizeInKB;
    private int avgDailyUptime;
    private boolean isUltrapeer;
    private GGEPBlock ggepBlock;
    private Set ippDestAddresses;
    private Set udpHostCaches;
    private UdpHostCache udpHostCache;

    public PongMsg(MsgHeader msgHeader, byte[] byArray) {
        super(msgHeader);
        this.getHeader().setPayloadType((byte)1);
        this.body = byArray;
        this.getHeader().setDataLength(this.body.length);
        this.avgDailyUptime = -1;
        this.parseBody();
    }

    private PongMsg(MsgHeader msgHeader, byte[] byArray, int n, int n2, int n3, boolean bl, GGEPBlock gGEPBlock) {
        super(msgHeader);
        this.getHeader().setPayloadType((byte)1);
        if (byArray.length != 4) {
            throw new IllegalArgumentException("Can't accept ip that is not 4 bytes in length: " + byArray.length);
        }
        this.ip = byArray;
        this.port = n;
        this.fileCount = n2;
        this.isUltrapeer = bl;
        this.ggepBlock = gGEPBlock;
        this.fileSizeInKB = bl ? (long)PongMsg.createUltrapeerMarking(n3) : (long)n3;
        this.buildBody();
        this.getHeader().setDataLength(this.body.length);
    }

    public int getPort() {
        return this.port;
    }

    public byte[] getIP() {
        return this.ip;
    }

    public long getFileCount() {
        return this.fileCount;
    }

    public long getFileSizeInKB() {
        return this.fileSizeInKB;
    }

    public int getDailyUptime() {
        return this.avgDailyUptime;
    }

    public boolean hasFreeLeafSlots() {
        if (!this.ggepBlock.isExtensionAvailable("UP")) {
            return false;
        }
        byte[] byArray = this.ggepBlock.getExtensionData("UP");
        return byArray != null && byArray.length >= 3 && byArray[1] > 0;
    }

    public boolean hasFreeUPSlots() {
        if (!this.ggepBlock.isExtensionAvailable("UP")) {
            return false;
        }
        byte[] byArray = this.ggepBlock.getExtensionData("UP");
        return byArray != null && byArray.length >= 3 && byArray[2] > 0;
    }

    public Set getIPPDestAddresses() {
        return this.ippDestAddresses;
    }

    public Set getUdpHostCaches() {
        return this.udpHostCaches;
    }

    public UdpHostCache getUdpHostCache() {
        return this.udpHostCache;
    }

    public void writeMessage(GnutellaOutputStream gnutellaOutputStream) throws IOException {
        this.getHeader().writeHeader(gnutellaOutputStream);
        gnutellaOutputStream.write(this.body, 0, this.body.length);
    }

    public byte[] getbytes() {
        byte[] byArray = new byte[23 + this.body.length];
        byte[] byArray2 = this.getHeader().getBytes();
        System.arraycopy(byArray2, 0, byArray, 0, 23);
        System.arraycopy(this.body, 0, byArray, 23, this.body.length);
        return byArray;
    }

    public String getDebugString() {
        return "Pong[ IP=" + AddressUtils.ip2string(this.ip) + ", Port=" + this.port + ", FileCount=" + this.fileCount + ", FileSize=" + this.fileSizeInKB + ", AvgUptime=" + this.avgDailyUptime + ", HEX=[" + HexConverter.toHexString(this.body) + "] ]";
    }

    private void buildBody() {
        int n;
        byte[] byArray;
        if (this.ggepBlock != null) {
            try {
                byArray = this.ggepBlock.getBytes();
                n = byArray.length;
            }
            catch (IOException iOException) {
                NLogger.error("MESSAGE_ENCODE_DECODE", (Object)iOException, (Throwable)iOException);
                n = 0;
                byArray = null;
            }
        } else {
            byArray = null;
            n = 0;
        }
        this.body = new byte[14 + n];
        IOUtil.serializeShortLE((short)this.port, this.body, 0);
        System.arraycopy(this.ip, 0, this.body, 2, 4);
        IOUtil.serializeIntLE((int)this.fileCount, this.body, 6);
        IOUtil.serializeIntLE((int)this.fileSizeInKB, this.body, 10);
        if (byArray != null) {
            System.arraycopy(byArray, 0, this.body, 14, n);
        }
    }

    private void parseBody() {
        this.port = IOUtil.unsignedShort2Int(IOUtil.deserializeShortLE(this.body, 0));
        this.ip = new byte[4];
        this.ip[0] = this.body[2];
        this.ip[1] = this.body[3];
        this.ip[2] = this.body[4];
        this.ip[3] = this.body[5];
        this.fileCount = IOUtil.unsignedInt2Long(IOUtil.deserializeIntLE(this.body, 6));
        this.fileSizeInKB = IOUtil.unsignedInt2Long(IOUtil.deserializeIntLE(this.body, 10));
        if (this.body.length <= 14) {
            return;
        }
        this.parseGGEPBlocks();
    }

    private void parseGGEPBlocks() {
        Object object;
        byte[] byArray;
        try {
            this.ggepBlock = GGEPBlock.mergeGGEPBlocks(GGEPBlock.parseGGEPBlocks(this.body, 14));
        }
        catch (InvalidGGEPBlockException invalidGGEPBlockException) {
            NLogger.warn("MESSAGE_ENCODE_DECODE", (Object)invalidGGEPBlockException);
            return;
        }
        if (this.ggepBlock.isExtensionAvailable("DU") && (byArray = this.ggepBlock.getExtensionData("DU")) != null) {
            try {
                this.avgDailyUptime = IOUtil.deserializeIntLE(byArray, 0, byArray.length);
            }
            catch (NumberFormatException numberFormatException) {
                NLogger.warn("MESSAGE_ENCODE_DECODE", (Object)("Invalid average uptime GGEP extension data: " + HexConverter.toHexString(byArray)), (Throwable)numberFormatException);
                this.avgDailyUptime = -1;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                NLogger.warn("MESSAGE_ENCODE_DECODE", (Object)("Invalid average uptime GGEP extension data: " + HexConverter.toHexString(byArray)));
                this.avgDailyUptime = -1;
            }
        }
        if (this.ggepBlock.isExtensionAvailable("IPP") && (byArray = this.ggepBlock.getExtensionData("IPP")) != null) {
            this.ippDestAddresses = PongMsg.unpackIpPortData(byArray);
        }
        if (this.ggepBlock.isExtensionAvailable("PHC") && (byArray = this.ggepBlock.getExtensionData("PHC")) != null) {
            object = new String(byArray);
            this.udpHostCaches = this.parsePackedHostCache((String)object);
        }
        if (this.ggepBlock.isExtensionAvailable("UDPHC")) {
            byArray = this.ggepBlock.getExtensionData("UDPHC");
            try {
                object = byArray != null && byArray.length > 0 ? new DefaultDestAddress(new String(byArray), this.port) : new DefaultDestAddress(this.ip, this.port);
                byte by = PhexSecurityManager.getInstance().controlHostAddressAccess((DestAddress)object);
                if (by == 1) {
                    this.udpHostCache = new UdpHostCache((DestAddress)object);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                NLogger.warn("UDP_HOST_CACHE", (Object)("INVALID Udp Host Cache found and ignored " + illegalArgumentException));
            }
        }
    }

    private Set parsePackedHostCache(String string) {
        PhexSecurityManager phexSecurityManager = PhexSecurityManager.getInstance();
        PresentationManager presentationManager = PresentationManager.getInstance();
        String[] stringArray = string.split("\n");
        HashSet<UdpHostCache> hashSet = new HashSet<UdpHostCache>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            int n = stringArray[i].indexOf("&");
            try {
                DestAddress destAddress;
                if (n == -1) {
                    destAddress = presentationManager.createHostAddress(stringArray[i], 6346);
                } else {
                    String string2 = stringArray[i].substring(0, n);
                    destAddress = presentationManager.createHostAddress(string2, 6346);
                }
                byte by = phexSecurityManager.controlHostAddressAccess(destAddress);
                if (by != 1) continue;
                UdpHostCache udpHostCache = new UdpHostCache(destAddress);
                hashSet.add(udpHostCache);
                continue;
            }
            catch (MalformedDestAddressException malformedDestAddressException) {
                NLogger.warn("UDP_HOST_CACHE", (Object)(" Ignored One Host Cache address in a packed host cache list  " + malformedDestAddressException));
            }
        }
        return hashSet;
    }

    private static Set unpackIpPortData(byte[] byArray) {
        HashSet<DefaultDestAddress> hashSet = null;
        try {
            if (byArray.length % 6 != 0) {
                throw new InvalidGGEPBlockException("invalid IPPORT EXTENSION DATA IN PONG");
            }
            PhexSecurityManager phexSecurityManager = PhexSecurityManager.getInstance();
            int n = byArray.length / 6;
            hashSet = new HashSet<DefaultDestAddress>();
            for (int i = 0; i < n; ++i) {
                int n2 = i * 6;
                byte[] byArray2 = new byte[4];
                System.arraycopy(byArray, n2, byArray2, 0, 4);
                int n3 = IOUtil.unsignedShort2Int(IOUtil.deserializeShortLE(byArray, n2 + 4));
                byte by = phexSecurityManager.controlHostIPAccess(byArray2);
                if (by != 1) continue;
                DefaultDestAddress defaultDestAddress = new DefaultDestAddress(byArray2, n3);
                hashSet.add(defaultDestAddress);
            }
        }
        catch (InvalidGGEPBlockException invalidGGEPBlockException) {
            NLogger.warn("MESSAGE_ENCODE_DECODE", (Object)invalidGGEPBlockException);
        }
        return hashSet;
    }

    private static byte[] packIpPortData(Collection collection) {
        byte[] byArray = new byte[collection.size() * 6];
        int n = 0;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            CaughtHost caughtHost = (CaughtHost)iterator.next();
            DestAddress destAddress = caughtHost.getHostAddress();
            byte[] byArray2 = destAddress.getIpAddress().getHostIP();
            int n2 = destAddress.getPort();
            System.arraycopy(byArray2, 0, byArray, n, 4);
            IOUtil.serializeShortLE((short)n2, byArray, n += 4);
            n += 2;
        }
        return byArray;
    }

    public boolean isUltrapeerMarked() {
        if (this.fileSizeInKB < 8L) {
            return false;
        }
        return (this.fileSizeInKB & this.fileSizeInKB - 1L) == 0L;
    }

    public static PongMsg createUdpPongMsg(byte[] byArray, Host host) throws InvalidMessageException {
        MsgHeader msgHeader = MsgHeader.createMsgHeader(byArray, 0);
        return PongMsg.createUdpPongMsg(msgHeader, byArray, 23, host);
    }

    public static PongMsg createUdpPongMsg(MsgHeader msgHeader, byte[] byArray, int n, Host host) throws InvalidMessageException {
        if (!MessageProcessor.isValidUdpMsgHeader(msgHeader)) {
            NLogger.warn("UDP_INCOMING_MESSAGES", (Object)(" Could not create udp pong from given byte array. Message Verification failed " + new String(byArray)));
            throw new InvalidMessageException(" Could not create Msg Header while trying to create udp pong Msg. Message Verification failed ");
        }
        msgHeader.setFromHost(host);
        if (msgHeader.getDataLength() < 14) {
            throw new InvalidMessageException(" Could not create Msg Body while trying to create udp pong Msg");
        }
        byte[] byArray2 = MessageProcessor.createBody(msgHeader, byArray, n);
        if (byArray2 == null) {
            throw new InvalidMessageException(" Could not create Msg Body while trying to create udp pong Msg");
        }
        return new PongMsg(msgHeader, byArray2);
    }

    public static PongMsg createUdpPongMsg(PingMsg pingMsg) {
        StatisticsManager statisticsManager = StatisticsManager.getInstance();
        NetworkManager networkManager = NetworkManager.getInstance();
        ShareManager shareManager = ShareManager.getInstance();
        HostManager hostManager = HostManager.getInstance();
        SharedFilesService sharedFilesService = shareManager.getSharedFilesService();
        int n = sharedFilesService.getFileCount();
        int n2 = sharedFilesService.getTotalFileSizeInKb();
        StatisticProvider statisticProvider = statisticsManager.getStatisticProvider("DailyUptimeProvider");
        int n3 = ((IntObj)statisticProvider.getValue()).intValue();
        boolean bl = hostManager.isUltrapeer();
        GGEPBlock gGEPBlock = PongMsg.createMyGGEPBlock(n3, bl);
        byte[] byArray = pingMsg.getScpByte();
        Collection collection = null;
        CaughtHostsContainer caughtHostsContainer = hostManager.getCaughtHostsContainer();
        switch (byArray[0] & 1) {
            case 1: {
                collection = caughtHostsContainer.getFreeUltrapeerSlotHosts();
                break;
            }
            case 0: {
                collection = caughtHostsContainer.getFreeLeafSlotHosts();
            }
        }
        PongMsg.addUdpPongGGEPExt(collection, gGEPBlock);
        DestAddress destAddress = networkManager.getLocalAddress();
        IpAddress ipAddress = destAddress.getIpAddress();
        if (ipAddress == null) {
            throw new IllegalArgumentException("Can't accept null ip.");
        }
        byte[] byArray2 = ipAddress.getHostIP();
        short s = (short)destAddress.getPort();
        MsgHeader msgHeader = new MsgHeader(pingMsg.getHeader().getMsgID(), 1, 1, 0, 0);
        PongMsg pongMsg = new PongMsg(msgHeader, byArray2, s, n, n2, bl, gGEPBlock);
        NLogger.info("UDP_OUTGOING_MESSAGES", (Object)("Created udp pong  in response to ping: " + pongMsg));
        return pongMsg;
    }

    public static PongMsg createMyOutgoingPong(GUID gUID, byte by) {
        byte[] byArray;
        StatisticsManager statisticsManager = StatisticsManager.getInstance();
        NetworkManager networkManager = NetworkManager.getInstance();
        ShareManager shareManager = ShareManager.getInstance();
        HostManager hostManager = HostManager.getInstance();
        SharedFilesService sharedFilesService = shareManager.getSharedFilesService();
        int n = sharedFilesService.getFileCount();
        int n2 = sharedFilesService.getTotalFileSizeInKb();
        StatisticProvider statisticProvider = statisticsManager.getStatisticProvider("DailyUptimeProvider");
        int n3 = ((IntObj)statisticProvider.getValue()).intValue();
        boolean bl = hostManager.isUltrapeer();
        GGEPBlock gGEPBlock = PongMsg.createMyGGEPBlock(n3, bl);
        DestAddress destAddress = networkManager.getLocalAddress();
        IpAddress ipAddress = destAddress.getIpAddress();
        if (ipAddress == null) {
            byArray = IpAddress.UNSET_IP;
            PongMsg.addPhexExtendedDestinationGGEP(destAddress, gGEPBlock);
        } else {
            byArray = ipAddress.getHostIP();
        }
        MsgHeader msgHeader = new MsgHeader(gUID, 1, by, 0, 0);
        PongMsg pongMsg = new PongMsg(msgHeader, byArray, (short)destAddress.getPort(), n, n2, bl, gGEPBlock);
        return pongMsg;
    }

    public static PongMsg createOtherLeafsOutgoingPong(GUID gUID, byte by, byte by2, DestAddress destAddress) {
        byte[] byArray;
        MsgHeader msgHeader = new MsgHeader(gUID, 1, by, by2, 0);
        GGEPBlock gGEPBlock = null;
        IpAddress ipAddress = destAddress.getIpAddress();
        if (ipAddress == null) {
            byArray = IpAddress.UNSET_IP;
            gGEPBlock = new GGEPBlock();
            PongMsg.addPhexExtendedDestinationGGEP(destAddress, gGEPBlock);
        } else {
            byArray = ipAddress.getHostIP();
        }
        PongMsg pongMsg = new PongMsg(msgHeader, byArray, (short)destAddress.getPort(), 0, 0, false, gGEPBlock);
        return pongMsg;
    }

    public static PongMsg createFromCachePong(GUID gUID, byte by, PongMsg pongMsg) {
        MsgHeader msgHeader = new MsgHeader(gUID, 1, by, 0, 0);
        PongMsg pongMsg2 = new PongMsg(msgHeader, pongMsg.body);
        return pongMsg2;
    }

    private static GGEPBlock createMyGGEPBlock(int n, boolean bl) {
        GGEPBlock gGEPBlock = new GGEPBlock();
        if (n > 0) {
            gGEPBlock.addExtension("DU", n);
        }
        if (bl) {
            byte[] byArray = new byte[3];
            byArray[0] = IOUtil.serializeGUESSVersionFormat(VersionUtils.getUltrapeerMajorVersionNumber(), VersionUtils.getUltrapeerMinorVersionNumber());
            NetworkHostsContainer networkHostsContainer = HostManager.getInstance().getNetworkHostsContainer();
            byArray[1] = (byte)networkHostsContainer.getOpenLeafSlotsCount();
            byArray[2] = (byte)networkHostsContainer.getOpenUltrapeerSlotsCount();
            gGEPBlock.addExtension("UP", byArray);
        }
        gGEPBlock.addExtension("VC", GGEP_VENDOR_CODE);
        return gGEPBlock;
    }

    private static void addUdpPongGGEPExt(Collection collection, GGEPBlock gGEPBlock) {
        Object object;
        Object object2;
        Object object3;
        if (collection != null && ((Object)(object3 = (Object)PongMsg.packIpPortData(collection))).length >= 6) {
            gGEPBlock.addExtension("IPP", (byte[])object3);
        }
        if (((UdpHostCacheManager)(object3 = UdpHostCacheManager.getInstance())).isUdpHostCache()) {
            object2 = NetworkManager.getInstance();
            object = ((NetworkManager)object2).getLocalAddress();
            byte[] byArray = object.isIpHostName() ? new byte[]{} : object.getHostName().getBytes();
            gGEPBlock.addExtension("UDPHC", byArray);
            NLogger.debug("UDP_OUTGOING_MESSAGES", (Object)"UDP HOST CACHE extension added to outgoing pongs");
        }
        if (((String)(object2 = ((UdpHostCacheManager)object3).getUdpHostCacheContainer().createPackedHostCaches())).length() > 0) {
            object = IOUtil.deflate(((String)object2).getBytes());
            gGEPBlock.addExtension("PHC", (byte[])object);
            NLogger.debug("UDP_OUTGOING_MESSAGES", (Object)" PACKED HOST CACHE extension added to outgoing pongs ");
        }
    }

    private static void addPhexExtendedDestinationGGEP(DestAddress destAddress, GGEPBlock gGEPBlock) {
        gGEPBlock.addExtension("PHEX.EXDST", destAddress.getHostName().getBytes());
    }

    private static int createUltrapeerMarking(int n) {
        if (n < 12) {
            return 8;
        }
        int n2 = IOUtil.determineBitCount(n);
        int n3 = (int)Math.pow(2.0, n2);
        int n4 = n3 - n3 / 4;
        if (n < n4) {
            n3 = (int)Math.pow(2.0, n2 - 1);
        }
        return n3;
    }

    static {
        PongMsg.GGEP_VENDOR_CODE[0] = 80;
        PongMsg.GGEP_VENDOR_CODE[1] = 72;
        PongMsg.GGEP_VENDOR_CODE[2] = 69;
        PongMsg.GGEP_VENDOR_CODE[3] = 88;
        PongMsg.GGEP_VENDOR_CODE[4] = IOUtil.serializeGUESSVersionFormat(VersionUtils.getMajorVersionNumber(), VersionUtils.getMinorVersionNumber());
    }
}

