/*
 * Decompiled with CFR 0.152.
 */
package phex.msg;

import java.io.IOException;
import phex.host.Host;
import phex.host.HostManager;
import phex.msg.GGEPBlock;
import phex.msg.InvalidGGEPBlockException;
import phex.msg.InvalidMessageException;
import phex.msg.Message;
import phex.msg.MessageProcessor;
import phex.msg.MsgHeader;
import phex.utils.GnutellaOutputStream;
import phex.utils.HexConverter;
import phex.utils.IOUtil;
import phex.utils.NLogger;

public class PingMsg
extends Message {
    private byte[] body;
    private byte[] udpScpByte = null;
    public static final byte UDP_SCP_MASK = 1;
    public static final byte UDP_SCP_LEAF = 0;
    public static final byte UDP_SCP_ULTRAPEER = 1;

    public PingMsg() {
        super(new MsgHeader(0, 0));
        this.body = IOUtil.EMPTY_BYTE_ARRAY;
    }

    public PingMsg(MsgHeader msgHeader, byte[] byArray) {
        super(msgHeader);
        this.getHeader().setPayloadType((byte)0);
        this.body = byArray;
        this.getHeader().setDataLength(this.body.length);
    }

    public static PingMsg createUdpPingMsg() throws IOException {
        HostManager hostManager = HostManager.getInstance();
        byte[] byArray = new byte[]{hostManager.isUltrapeer() ? (byte)1 : 0};
        GGEPBlock gGEPBlock = new GGEPBlock();
        gGEPBlock.addExtension("SCP", byArray);
        byte[] byArray2 = gGEPBlock.getBytes();
        PingMsg pingMsg = new PingMsg();
        pingMsg.getHeader().setTTL((byte)1);
        pingMsg.getHeader().setDataLength(byArray2.length);
        pingMsg.body = byArray2;
        pingMsg.udpScpByte = byArray;
        NLogger.debug("UDP_OUTGOING_MESSAGES", (Object)(" Created UDP Ping " + pingMsg.toString()));
        return pingMsg;
    }

    public static PingMsg createUdpPingMsg(byte[] byArray, Host host) throws InvalidMessageException {
        MsgHeader msgHeader = MsgHeader.createMsgHeader(byArray, 0);
        return PingMsg.createUdpPingMsg(msgHeader, byArray, 23, host);
    }

    public static PingMsg createUdpPingMsg(MsgHeader msgHeader, byte[] byArray, int n, Host host) throws InvalidMessageException {
        if (!MessageProcessor.isValidUdpMsgHeader(msgHeader)) {
            NLogger.warn("UDP_INCOMING_MESSAGES", (Object)(" Could not create udp ping from given byte array. Message Verification failed " + new String(byArray)));
            throw new InvalidMessageException(" Could not create Msg Header while trying to create udp ping Msg. Message Verification failed ");
        }
        msgHeader.setFromHost(host);
        byte[] byArray2 = MessageProcessor.createBody(msgHeader, byArray, n);
        if (byArray2 == null) {
            throw new InvalidMessageException(" Could not create Msg Body while trying to create udp ping Msg");
        }
        PingMsg pingMsg = new PingMsg(msgHeader, byArray2);
        pingMsg.parseGGEPBlocks();
        return pingMsg;
    }

    public void writeMessage(GnutellaOutputStream gnutellaOutputStream) throws IOException {
        this.getHeader().writeHeader(gnutellaOutputStream);
        gnutellaOutputStream.write(this.body, 0, this.body.length);
    }

    public byte[] getBytes() {
        byte[] byArray = new byte[23 + this.body.length];
        byte[] byArray2 = this.getHeader().getBytes();
        System.arraycopy(byArray2, 0, byArray, 0, 23);
        System.arraycopy(this.body, 0, byArray, 23, this.body.length);
        return byArray;
    }

    private void parseGGEPBlocks() {
        byte[] byArray;
        GGEPBlock[] gGEPBlockArray;
        try {
            gGEPBlockArray = GGEPBlock.parseGGEPBlocks(this.body, 0);
        }
        catch (InvalidGGEPBlockException invalidGGEPBlockException) {
            NLogger.warn("MESSAGE_ENCODE_DECODE", (Object)invalidGGEPBlockException);
            return;
        }
        if (GGEPBlock.isExtensionHeaderInBlocks(gGEPBlockArray, "SCP") && (byArray = GGEPBlock.getExtensionDataInBlocks(gGEPBlockArray, "SCP")) != null) {
            this.udpScpByte = byArray;
        }
    }

    public byte[] getScpByte() {
        if (this.udpScpByte == null || this.udpScpByte.length < 1) {
            return null;
        }
        return this.udpScpByte;
    }

    public String toString() {
        return this.getDebugString();
    }

    public String getDebugString() {
        return "Ping[ HEX=[" + HexConverter.toHexString(this.body) + "] ]";
    }
}

