/*
 * Decompiled with CFR 0.152.
 */
package phex.msg;

import java.util.Iterator;
import java.util.TimerTask;
import phex.common.AbstractManager;
import phex.common.Environment;
import phex.common.QueryRoutingTable;
import phex.common.address.DestAddress;
import phex.connection.NetworkManager;
import phex.host.Host;
import phex.host.HostManager;
import phex.host.NetworkHostsContainer;
import phex.msg.GUID;
import phex.msg.PingMsg;
import phex.msg.QueryMsg;
import phex.msg.QueryResponseMsg;
import phex.msg.RouteTableUpdateMsg;
import phex.msg.vendor.HopsFlowVMsg;
import phex.msg.vendor.TCPConnectBackVMsg;
import phex.query.QueryManager;
import phex.query.QueryResultMonitor;
import phex.upload.UploadManager;
import phex.utils.GUIDRoutingTable;
import phex.utils.Logger;
import phex.utils.NLogger;
import phex.utils.QueryGUIDRoutingPair;
import phex.utils.QueryGUIDRoutingTable;

public final class MsgManager
extends AbstractManager {
    private HostManager hostMgr;
    private NetworkHostsContainer hostsContainer;
    private QueryManager queryMgr;
    private QueryResultMonitor queryResultMonitor;
    private QueryRoutingTable lastSentQueryRoutingTable;
    private GUIDRoutingTable pingRoutingTable = new GUIDRoutingTable(120000L);
    private QueryGUIDRoutingTable queryRoutingTable = new QueryGUIDRoutingTable(300000L);
    private GUIDRoutingTable pushRoutingTable = new GUIDRoutingTable(420000L);

    private MsgManager() {
    }

    public static MsgManager getInstance() {
        return Holder.manager;
    }

    public boolean initialize() {
        return true;
    }

    public boolean onPostInitialization() {
        this.hostMgr = HostManager.getInstance();
        this.hostsContainer = this.hostMgr.getNetworkHostsContainer();
        this.queryMgr = QueryManager.getInstance();
        Environment.getInstance().scheduleTimerTask(new QRPUpdateTimer(), 10000L, 10000L);
        Environment.getInstance().scheduleTimerTask(new HopsFlowTimer(), 120000L, 15000L);
        this.queryResultMonitor = new QueryResultMonitor();
        return true;
    }

    public void startupCompletedNotify() {
    }

    public void shutdown() {
    }

    public QueryResultMonitor getQueryResultMonitor() {
        return this.queryResultMonitor;
    }

    public QueryRoutingTable getLastSentQueryRoutingTable() {
        return this.lastSentQueryRoutingTable;
    }

    public synchronized boolean checkAndAddToPingRoutingTable(GUID gUID, Host host) {
        boolean bl = this.pingRoutingTable.checkAndAddRouting(gUID, host);
        return bl;
    }

    public synchronized boolean checkAndAddToQueryRoutingTable(GUID gUID, Host host) {
        boolean bl = this.queryRoutingTable.checkAndAddRouting(gUID, host);
        return bl;
    }

    public synchronized void addToPushRoutingTable(GUID gUID, Host host) {
        this.pushRoutingTable.addRouting(gUID, host);
    }

    public synchronized void removeHost(Host host) {
        this.queryMgr.removeHostQueries(host);
        this.pingRoutingTable.removeHost(host);
        this.queryRoutingTable.removeHost(host);
        this.pushRoutingTable.removeHost(host);
    }

    public synchronized Host getPushRouting(GUID gUID) {
        return this.pushRoutingTable.findRouting(gUID);
    }

    public synchronized Host getPingRouting(GUID gUID) {
        return this.pingRoutingTable.findRouting(gUID);
    }

    public synchronized QueryGUIDRoutingPair getQueryRouting(GUID gUID, int n) {
        return this.queryRoutingTable.findRoutingForQuerys(gUID, n);
    }

    public synchronized void processQueryResponse(Host host, QueryResponseMsg queryResponseMsg) {
        this.queryMgr.getSearchContainer().processQueryResponse(queryResponseMsg);
        this.queryMgr.getBackgroundSearchContainer().processQueryResponse(queryResponseMsg);
        this.queryResultMonitor.processResponse(queryResponseMsg);
    }

    public void forwardQuery(QueryMsg queryMsg, Host host) {
        boolean bl = this.hostMgr.isShieldedLeafNode();
        if (bl && host != null && host.isLeafUltrapeerConnection()) {
            return;
        }
        if (host.isUltrapeerLeafConnection()) {
            this.queryMgr.sendDynamicQuery(queryMsg, 50);
        } else if (!bl) {
            if (queryMsg.getHeader().getTTL() > 0) {
                this.forwardQueryToUltrapeers(queryMsg, host);
            }
            this.forwardQueryToLeaves(queryMsg, host);
        }
        if (queryMsg.getHeader().getTTL() > 0) {
            Host[] hostArray = this.hostsContainer.getPeerConnections();
            this.forwardQuery(queryMsg, host, hostArray);
        }
    }

    public void forwardQueryToLeaves(QueryMsg queryMsg, Host host) {
        Host[] hostArray = this.hostsContainer.getLeafConnections();
        this.forwardQuery(queryMsg, host, hostArray);
    }

    private void forwardQuery(QueryMsg queryMsg, Host host, Host[] hostArray) {
        for (int i = 0; i < hostArray.length; ++i) {
            QueryRoutingTable queryRoutingTable;
            if (hostArray[i] == host || (queryRoutingTable = hostArray[i].getLastReceivedRoutingTable()) != null && !queryRoutingTable.containsQuery(queryMsg)) continue;
            hostArray[i].queueMessageToSend(queryMsg);
        }
    }

    public void forwardQueryToUltrapeers(QueryMsg queryMsg, Host host) {
        Host[] hostArray = this.hostsContainer.getUltrapeerConnections();
        boolean bl = queryMsg.getHeader().getTTL() == 1;
        for (int i = 0; i < hostArray.length; ++i) {
            QueryRoutingTable queryRoutingTable;
            if (hostArray[i] == host || bl && hostArray[i].isUPQueryRoutingSupported() && (queryRoutingTable = hostArray[i].getLastReceivedRoutingTable()) != null && !queryRoutingTable.containsQuery(queryMsg)) continue;
            hostArray[i].queueMessageToSend(queryMsg);
        }
    }

    public void forwardPing(PingMsg pingMsg, Host host) {
        Host[] hostArray;
        boolean bl = this.hostMgr.isShieldedLeafNode();
        if (bl && host != null && host.isLeafUltrapeerConnection()) {
            return;
        }
        if (!bl) {
            hostArray = this.hostsContainer.getUltrapeerConnections();
            this.forwardPing(pingMsg, host, hostArray);
            hostArray = this.hostsContainer.getLeafConnections();
            this.forwardPing(pingMsg, host, hostArray);
        }
        hostArray = this.hostsContainer.getPeerConnections();
        this.forwardPing(pingMsg, host, hostArray);
    }

    private void forwardPing(PingMsg pingMsg, Host host, Host[] hostArray) {
        for (int i = 0; i < hostArray.length; ++i) {
            if (hostArray[i] == host) continue;
            hostArray[i].queueMessageToSend(pingMsg);
        }
    }

    public void pingHost(Host host) {
        this.pingHost(host, (byte)1);
    }

    public void pingHost(Host host, byte by) {
        PingMsg pingMsg = new PingMsg();
        pingMsg.getHeader().setTTL(by);
        this.checkAndAddToPingRoutingTable(pingMsg.getHeader().getMsgID(), Host.LOCAL_HOST);
        if (NLogger.isDebugEnabled("OUTGOING_MESSAGES")) {
            NLogger.debug("OUTGOING_MESSAGES", (Object)("Queueing Ping: " + pingMsg.getDebugString() + " - " + pingMsg.getHeader().getDebugString() + " - Host: " + host.toString()));
        }
        host.queueMessageToSend(pingMsg);
    }

    public void broadcastPingHosts(byte by) {
        PingMsg pingMsg = new PingMsg();
        pingMsg.getHeader().setTTL(by);
        this.checkAndAddToPingRoutingTable(pingMsg.getHeader().getMsgID(), Host.LOCAL_HOST);
        Host[] hostArray = this.hostsContainer.getUltrapeerConnections();
        this.forwardPing(pingMsg, Host.LOCAL_HOST, hostArray);
    }

    public boolean requestTCPConnectBack() {
        DestAddress destAddress = NetworkManager.getInstance().getLocalAddress();
        TCPConnectBackVMsg tCPConnectBackVMsg = new TCPConnectBackVMsg(destAddress.getPort());
        Host[] hostArray = this.hostsContainer.getUltrapeerConnections();
        int n = 0;
        for (int i = 0; n <= 3 && i < hostArray.length; ++i) {
            if (!hostArray[i].isTCPConnectBackSupported()) continue;
            hostArray[i].queueMessageToSend(tCPConnectBackVMsg);
            ++n;
        }
        return n > 0;
    }

    public void updateLocalQueryRoutingTable() {
        this.lastSentQueryRoutingTable = QueryRoutingTable.createLocalQueryRoutingTable();
    }

    private class HopsFlowTimer
    extends TimerTask {
        private static final long TIMER_DELAY = 120000L;
        private static final long TIMER_PERIOD = 15000L;
        private boolean lastBusyState = false;

        private HopsFlowTimer() {
        }

        public void run() {
            try {
                if (!MsgManager.this.hostsContainer.isShieldedLeafNode()) {
                    return;
                }
                Host[] hostArray = MsgManager.this.hostsContainer.getUltrapeerConnections();
                boolean bl = UploadManager.getInstance().isHostBusy();
                int n = bl ? 0 : 5;
                HopsFlowVMsg hopsFlowVMsg = new HopsFlowVMsg(n);
                long l = System.currentTimeMillis();
                for (int i = 0; i < hostArray.length; ++i) {
                    if (!hostArray[i].isHopsFlowSupported() || bl == this.lastBusyState && !((double)hostArray[i].getConnectionUpTime(l) < 16500.0)) continue;
                    hostArray[i].queueMessageToSend(hopsFlowVMsg);
                }
                this.lastBusyState = bl;
            }
            catch (Throwable throwable) {
                NLogger.error("OUTGOING_MESSAGES", (Object)throwable, throwable);
            }
        }
    }

    private class QRPUpdateTimer
    extends TimerTask {
        private static final long TIMER_PERIOD = 10000L;

        private QRPUpdateTimer() {
        }

        public void run() {
            try {
                this.sendQueryRoutingTable();
            }
            catch (Throwable throwable) {
                NLogger.error("GLOBAL", (Object)throwable, throwable);
            }
        }

        private void sendQueryRoutingTable() {
            boolean bl = MsgManager.this.hostMgr.isUltrapeer();
            if (!MsgManager.this.hostMgr.isShieldedLeafNode() && !bl) {
                return;
            }
            Host[] hostArray = MsgManager.this.hostsContainer.getUltrapeerConnections();
            QueryRoutingTable queryRoutingTable = null;
            for (int i = 0; i < hostArray.length; ++i) {
                if ((!bl ? !hostArray[i].isQueryRoutingSupported() : !hostArray[i].isUPQueryRoutingSupported()) || !hostArray[i].isQRTableUpdateRequired()) continue;
                Logger.logMessage(Logger.FINER, (short)16, "Updating QRTable for: " + hostArray[i]);
                if (queryRoutingTable == null) {
                    MsgManager.this.updateLocalQueryRoutingTable();
                    queryRoutingTable = MsgManager.this.lastSentQueryRoutingTable;
                }
                QueryRoutingTable queryRoutingTable2 = hostArray[i].getLastSentRoutingTable();
                Iterator iterator = QueryRoutingTable.buildRouteTableUpdateMsgIterator(queryRoutingTable, queryRoutingTable2);
                while (iterator.hasNext()) {
                    RouteTableUpdateMsg routeTableUpdateMsg = (RouteTableUpdateMsg)iterator.next();
                    hostArray[i].queueMessageToSend(routeTableUpdateMsg);
                }
                hostArray[i].setLastSentRoutingTable(queryRoutingTable);
            }
        }
    }

    private static class Holder {
        protected static final MsgManager manager = new MsgManager();

        private Holder() {
        }
    }
}

