/*
 * Decompiled with CFR 0.152.
 */
package phex.msg;

import java.io.IOException;
import phex.common.ServiceManager;
import phex.host.Host;
import phex.msg.GUID;
import phex.msg.InvalidMessageException;
import phex.utils.GnutellaOutputStream;
import phex.utils.IOUtil;
import phex.utils.NLogger;

public class MsgHeader {
    public static final int DATA_LENGTH = 23;
    public static final byte PING_PAYLOAD = 0;
    public static final byte PONG_PAYLOAD = 1;
    public static final byte ROUTE_TABLE_UPDATE_PAYLOAD = 48;
    public static final byte PUSH_PAYLOAD = 64;
    public static final byte QUERY_PAYLOAD = -128;
    public static final byte QUERY_HIT_PAYLOAD = -127;
    public static final byte VENDOR_MESSAGE_PAYLOAD = 49;
    public static final byte STANDARD_VENDOR_MESSAGE_PAYLOAD = 50;
    public static final byte sUnknown = -1;
    private GUID msgID;
    private byte payload;
    private byte ttl;
    private byte hopsTaken;
    private int dataLength;
    private long arrivalTime;
    private Host fromHost = null;

    public MsgHeader(byte by, int n) {
        this(new GUID(), by, (byte)ServiceManager.sCfg.ttl, 0, n);
    }

    public MsgHeader(byte by, byte by2, int n) {
        this(new GUID(), by, by2, 0, n);
    }

    public MsgHeader(GUID gUID, byte by, byte by2, byte by3, int n) {
        this.msgID = gUID;
        this.payload = by;
        this.ttl = by2;
        this.hopsTaken = by3;
        this.dataLength = n;
    }

    public GUID getMsgID() {
        return this.msgID;
    }

    public void setMsgID(GUID gUID) {
        this.msgID = gUID;
    }

    public byte getPayload() {
        return this.payload;
    }

    public void setPayloadType(byte by) {
        this.payload = by;
    }

    private String getPayloadName() {
        switch (this.payload) {
            case 0: {
                return "Ping";
            }
            case 1: {
                return "Pong";
            }
            case 48: {
                return "RouteTableUpdate";
            }
            case 64: {
                return "Push";
            }
            case -128: {
                return "Query";
            }
            case -127: {
                return "QueryHit";
            }
            case 49: {
                return "Vendor";
            }
            case 50: {
                return "Vendor(st)";
            }
        }
        return "Unknown";
    }

    public byte getTTL() {
        return this.ttl;
    }

    public void setTTL(byte by) {
        this.ttl = by;
    }

    public byte getHopsTaken() {
        return this.hopsTaken;
    }

    public void setHopsTaken(byte by) {
        this.hopsTaken = by;
    }

    public void countHop() {
        if (this.ttl > 0) {
            this.ttl = (byte)(this.ttl - 1);
        }
        this.hopsTaken = (byte)(this.hopsTaken + 1);
    }

    public int getDataLength() {
        return this.dataLength;
    }

    public void setDataLength(int n) {
        this.dataLength = n;
    }

    public long getArrivalTime() {
        return this.arrivalTime;
    }

    public void setArrivalTime(long l) {
        this.arrivalTime = l;
    }

    public Host getFromHost() {
        return this.fromHost;
    }

    public void setFromHost(Host host) {
        this.fromHost = host;
    }

    public void copy(MsgHeader msgHeader) {
        this.msgID = msgHeader.msgID;
        this.payload = msgHeader.payload;
        this.ttl = msgHeader.ttl;
        this.hopsTaken = msgHeader.hopsTaken;
        this.dataLength = msgHeader.dataLength;
    }

    public void writeHeader(GnutellaOutputStream gnutellaOutputStream) throws IOException {
        byte[] byArray = this.getBytes();
        gnutellaOutputStream.write(byArray);
    }

    public byte[] getBytes() {
        byte[] byArray = new byte[23];
        byte[] byArray2 = this.msgID.getGuid();
        System.arraycopy(byArray2, 0, byArray, 0, 16);
        byArray[16] = this.payload;
        byArray[17] = this.ttl;
        byArray[18] = this.hopsTaken;
        IOUtil.serializeIntLE(this.dataLength, byArray, 19);
        return byArray;
    }

    public String getDebugString() {
        return "Header[" + this.payload + "-" + this.getPayloadName() + ",TTL=" + this.ttl + ",Hop=" + this.hopsTaken + ",len=" + this.dataLength + ",GUID=" + this.msgID + " ]";
    }

    public static MsgHeader createMsgHeader(byte[] byArray, int n) throws InvalidMessageException {
        if (byArray.length - n < 23) {
            throw new InvalidMessageException("The byte array Length is less then the message header lenght ");
        }
        byte[] byArray2 = new byte[16];
        System.arraycopy(byArray, n, byArray2, 0, 16);
        GUID gUID = new GUID(byArray2);
        n += 16;
        byte by = byArray[n++];
        byte by2 = byArray[n++];
        byte by3 = byArray[n++];
        int n2 = IOUtil.deserializeIntLE(byArray, n);
        n += 4;
        MsgHeader msgHeader = new MsgHeader(gUID, by, by2, by3, n2);
        int n3 = msgHeader.getDataLength();
        if (n3 < 0) {
            throw new InvalidMessageException("Negative body size when creating header from byte array ");
        }
        if (n3 > ServiceManager.sCfg.maxMessageLength) {
            NLogger.warn("IncomingMessages", (Object)("Body too big. Header: " + msgHeader + " Byte Array : " + new String(byArray)));
            throw new InvalidMessageException("Package too big when creating Message from byte array: " + msgHeader.getDataLength());
        }
        msgHeader.setArrivalTime(System.currentTimeMillis());
        return msgHeader;
    }
}

