/*
 * Decompiled with CFR 0.152.
 */
package phex.http;

public class Range {
    public static final int NOT_SET = -1;
    private long suffixLength;
    private long startOffset;
    private long endOffset;

    public Range(long l) {
        this.startOffset = -1L;
        this.endOffset = -1L;
        this.suffixLength = l;
    }

    public Range(long l, long l2) {
        this.startOffset = l;
        this.endOffset = l2;
        this.suffixLength = -1L;
    }

    public void update(long l) {
        this.startOffset = -1L;
        this.endOffset = -1L;
        this.suffixLength = l;
    }

    public void update(long l, long l2) {
        this.startOffset = l;
        this.endOffset = l2;
        this.suffixLength = -1L;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[Range: " + this.startOffset + "-" + this.endOffset + "]");
        return stringBuffer.toString();
    }

    public long getStartOffset(long l) {
        if (this.suffixLength == -1L) {
            return this.startOffset;
        }
        return l - this.suffixLength;
    }

    public long getEndOffset(long l) {
        if (this.suffixLength == -1L && this.endOffset != -1L) {
            return Math.min(this.endOffset, l - 1L);
        }
        return l - 1L;
    }

    public boolean isRangeSatisfiable(Range range, long l) {
        long l2 = range.getStartOffset(l);
        return this.getStartOffset(l) <= l2 && l2 <= this.getEndOffset(l);
    }

    public String buildHTTPRangeString() {
        if (this.suffixLength == -1L) {
            return String.valueOf(this.startOffset) + '-' + String.valueOf(this.endOffset);
        }
        return '-' + String.valueOf(this.suffixLength);
    }
}

